/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.slides.projector;

import com.mojang.blaze3d.systems.RenderSystem;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_241;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_465;
import net.minecraft.class_5244;
import net.minecraft.class_5481;
import net.minecraft.class_8710;
import org.apache.commons.lang3.StringUtils;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.teacon.slides.network.ProjectorAfterUpdateC2SPayload;
import org.teacon.slides.network.ProjectorExportC2SPayload;
import org.teacon.slides.projector.ProjectorBlock;
import org.teacon.slides.projector.ProjectorBlockEntity;
import org.teacon.slides.projector.ProjectorScreenHandler;
import org.teacon.slides.projector.SourceType;
import org.teacon.slides.renderer.SlideState;
import org.teacon.slides.util.RegistryClient;

public final class ProjectorScreen
extends class_465<ProjectorScreenHandler> {
    private static final class_2960 GUI_TEXTURE = class_2960.method_43902((String)"slide_show", (String)"textures/gui/projector.png");
    private static final class_2561 IMAGE_TEXT = class_2561.method_43471((String)"gui.slide_show.section.image");
    private static final class_2561 OFFSET_TEXT = class_2561.method_43471((String)"gui.slide_show.section.offset");
    private static final class_2561 OTHERS_TEXT = class_2561.method_43471((String)"gui.slide_show.section.others");
    private static final class_2561 URL_TEXT = class_2561.method_43471((String)"gui.slide_show.url");
    private static final class_2561 ID_TEXT = class_2561.method_43471((String)"gui.slide_show.id");
    private static final class_2561 EXPORT_TEXT = class_2561.method_43471((String)"gui.slide_show.export");
    private static final class_2561 CONTAINER_TEXT = class_2561.method_43471((String)"gui.slide_show.container");
    private static final class_2561 COLOR_TEXT = class_2561.method_43471((String)"gui.slide_show.color");
    private static final class_2561 WIDTH_TEXT = class_2561.method_43471((String)"gui.slide_show.width");
    private static final class_2561 HEIGHT_TEXT = class_2561.method_43471((String)"gui.slide_show.height");
    private static final class_2561 OFFSET_X_TEXT = class_2561.method_43471((String)"gui.slide_show.offset_x");
    private static final class_2561 OFFSET_Y_TEXT = class_2561.method_43471((String)"gui.slide_show.offset_y");
    private static final class_2561 OFFSET_Z_TEXT = class_2561.method_43471((String)"gui.slide_show.offset_z");
    private static final class_2561 FLIP_TEXT = class_2561.method_43471((String)"gui.slide_show.flip");
    private static final class_2561 ROTATE_TEXT = class_2561.method_43471((String)"gui.slide_show.rotate");
    private static final class_2561 SINGLE_DOUBLE_SIDED_TEXT = class_2561.method_43471((String)"gui.slide_show.single_double_sided");
    private class_342 mURLInput;
    private class_342 mColorInput;
    private class_342 mWidthInput;
    private class_342 mHeightInput;
    private class_342 mOffsetXInput;
    private class_342 mOffsetYInput;
    private class_342 mOffsetZInput;
    private ScreenTexturedButtonWidget mSwitchURL;
    private ScreenTexturedButtonWidget mSwitchID;
    private ScreenTexturedButtonWidget mSwitchContainer;
    private ScreenTexturedButtonWidget mButtonExport;
    private ScreenTexturedButtonWidget mSwitchSingleSided;
    private ScreenTexturedButtonWidget mSwitchDoubleSided;
    private SourceType mSourceType;
    private boolean mDoubleSided;
    private int mImageColor = -1;
    private class_241 mImageSize = class_241.field_1335;
    private Vector3f mImageOffset = new Vector3f();
    private ProjectorBlock.InternalRotation mRotation = ProjectorBlock.InternalRotation.NONE;
    private boolean mInvalidURL = true;
    private boolean mInvalidColor = true;
    private boolean mInvalidWidth = true;
    private boolean mInvalidHeight = true;
    private boolean mInvalidOffsetX = true;
    private boolean mInvalidOffsetY = true;
    private boolean mInvalidOffsetZ = true;
    private final ProjectorBlockEntity mEntity;
    private final int imageWidth;
    private final int imageHeight;

    public ProjectorScreen(ProjectorScreenHandler handler, class_1661 inventory, class_2561 title) {
        super((class_1703)handler, inventory, title);
        class_2586 blockEntity = class_310.method_1551().field_1687.method_8321(handler.getPos());
        this.mEntity = blockEntity instanceof ProjectorBlockEntity ? (ProjectorBlockEntity)blockEntity : null;
        this.imageWidth = 176;
        this.imageHeight = 217;
    }

    protected void method_25426() {
        super.method_25426();
        if (this.mEntity == null) {
            return;
        }
        this.mSourceType = this.mEntity.mSourceType;
        int leftPos = (this.field_22789 - this.imageWidth) / 2;
        int topPos = (this.field_22790 - this.imageHeight) / 2;
        this.mURLInput = new class_342(this.field_22793, leftPos + 30, topPos + 29, 137, 16, (class_2561)class_2561.method_43471((String)"gui.slide_show.url"));
        this.mURLInput.method_1880(512);
        this.mURLInput.method_1863(text -> {
            if (StringUtils.isNotBlank((CharSequence)text)) {
                this.mInvalidURL = switch (this.mSourceType) {
                    case SourceType.URL -> {
                        if (SlideState.createURI(text) == null) {
                            yield true;
                        }
                        yield false;
                    }
                    case SourceType.ResourceID -> {
                        if (class_2960.method_12829((String)text) == null) {
                            yield true;
                        }
                        yield false;
                    }
                    default -> false;
                };
            } else {
                this.mInvalidURL = false;
            }
            this.mURLInput.method_1868(this.mInvalidURL ? 14699339 : 0xE0E0E0);
        });
        this.mURLInput.method_1852(this.mEntity.mLocation);
        this.method_37063((class_364)this.mURLInput);
        this.method_48265((class_364)this.mURLInput);
        this.mColorInput = new class_342(this.field_22793, leftPos + 55, topPos + 155, 56, 16, (class_2561)class_2561.method_43471((String)"gui.slide_show.color"));
        this.mColorInput.method_1880(8);
        this.mColorInput.method_1863(text -> {
            try {
                this.mImageColor = Integer.parseUnsignedInt(text, 16);
                this.mInvalidColor = false;
            }
            catch (Exception e) {
                this.mInvalidColor = true;
            }
            this.mColorInput.method_1868(this.mInvalidColor ? 14699339 : 0xE0E0E0);
        });
        this.mColorInput.method_1852(String.format("%08X", this.mEntity.mColor));
        this.method_37063((class_364)this.mColorInput);
        this.mWidthInput = new class_342(this.field_22793, leftPos + 30, topPos + 51, 56, 16, (class_2561)class_2561.method_43471((String)"gui.slide_show.width"));
        this.mWidthInput.method_1863(text -> {
            try {
                class_241 newSize = new class_241(ProjectorScreen.parseFloat(text), this.mImageSize.field_1342);
                this.updateSize(newSize);
                this.mInvalidWidth = false;
            }
            catch (Exception e) {
                this.mInvalidWidth = true;
            }
            this.mWidthInput.method_1868(this.mInvalidWidth ? 14699339 : 0xE0E0E0);
        });
        this.mWidthInput.method_1852(ProjectorScreen.floatToString(this.mEntity.mWidth));
        this.method_37063((class_364)this.mWidthInput);
        this.mHeightInput = new class_342(this.field_22793, leftPos + 111, topPos + 51, 56, 16, (class_2561)class_2561.method_43471((String)"gui.slide_show.height"));
        this.mHeightInput.method_1863(input -> {
            try {
                class_241 newSize = new class_241(this.mImageSize.field_1343, ProjectorScreen.parseFloat(input));
                this.updateSize(newSize);
                this.mInvalidHeight = false;
            }
            catch (Exception e) {
                this.mInvalidHeight = true;
            }
            this.mHeightInput.method_1868(this.mInvalidHeight ? 14699339 : 0xE0E0E0);
        });
        this.mHeightInput.method_1852(ProjectorScreen.floatToString(this.mEntity.mHeight));
        this.method_37063((class_364)this.mHeightInput);
        this.mOffsetXInput = new class_342(this.field_22793, leftPos + 30, topPos + 103, 29, 16, (class_2561)class_2561.method_43471((String)"gui.slide_show.offset_x"));
        this.mOffsetXInput.method_1863(input -> {
            try {
                this.mImageOffset = new Vector3f(ProjectorScreen.parseFloat(input), this.mImageOffset.y(), this.mImageOffset.z());
                this.mInvalidOffsetX = false;
            }
            catch (Exception e) {
                this.mInvalidOffsetX = true;
            }
            this.mOffsetXInput.method_1868(this.mInvalidOffsetX ? 14699339 : 0xE0E0E0);
        });
        this.mOffsetXInput.method_1852(ProjectorScreen.floatToString(this.mEntity.mOffsetX));
        this.method_37063((class_364)this.mOffsetXInput);
        this.mOffsetYInput = new class_342(this.field_22793, leftPos + 84, topPos + 103, 29, 16, (class_2561)class_2561.method_43471((String)"gui.slide_show.offset_y"));
        this.mOffsetYInput.method_1863(input -> {
            try {
                this.mImageOffset = new Vector3f(this.mImageOffset.x(), ProjectorScreen.parseFloat(input), this.mImageOffset.z());
                this.mInvalidOffsetY = false;
            }
            catch (Exception e) {
                this.mInvalidOffsetY = true;
            }
            this.mOffsetYInput.method_1868(this.mInvalidOffsetY ? 14699339 : 0xE0E0E0);
        });
        this.mOffsetYInput.method_1852(ProjectorScreen.floatToString(this.mEntity.mOffsetY));
        this.method_37063((class_364)this.mOffsetYInput);
        this.mOffsetZInput = new class_342(this.field_22793, leftPos + 138, topPos + 103, 29, 16, (class_2561)class_2561.method_43471((String)"gui.slide_show.offset_z"));
        this.mOffsetZInput.method_1863(input -> {
            try {
                this.mImageOffset = new Vector3f(this.mImageOffset.x(), this.mImageOffset.y(), ProjectorScreen.parseFloat(input));
                this.mInvalidOffsetZ = false;
            }
            catch (Exception e) {
                this.mInvalidOffsetZ = true;
            }
            this.mOffsetZInput.method_1868(this.mInvalidOffsetZ ? 14699339 : 0xE0E0E0);
        });
        this.mOffsetZInput.method_1852(ProjectorScreen.floatToString(this.mEntity.mOffsetZ));
        this.method_37063((class_364)this.mOffsetZInput);
        this.method_37063((class_364)new ScreenTexturedButtonWidget(leftPos + 117, topPos + 153, 18, 19, 179, 153, GUI_TEXTURE, button -> {
            ProjectorBlock.InternalRotation newRotation = this.mRotation.flip();
            this.updateRotation(newRotation);
        }));
        this.method_37063((class_364)new ScreenTexturedButtonWidget(leftPos + 142, topPos + 153, 18, 19, 179, 173, GUI_TEXTURE, button -> {
            ProjectorBlock.InternalRotation newRotation = this.mRotation.compose(class_2470.field_11463);
            this.updateRotation(newRotation);
        }));
        this.mRotation = (ProjectorBlock.InternalRotation)((Object)this.mEntity.method_11010().method_11654(ProjectorBlock.ROTATION));
        this.mSwitchURL = new ScreenTexturedButtonWidget(leftPos + 9, topPos + 27, 18, 19, 179, 53, GUI_TEXTURE, button -> {
            this.mSourceType = SourceType.ResourceID;
            this.mSwitchID.field_22764 = true;
            this.mSwitchURL.field_22764 = false;
        });
        this.mSwitchID = new ScreenTexturedButtonWidget(leftPos + 9, topPos + 27, 18, 19, 179, 73, GUI_TEXTURE, button -> {
            this.mSourceType = SourceType.ContainerBlock;
            this.mSwitchContainer.field_22764 = true;
            this.mSwitchID.field_22764 = false;
            this.mButtonExport.field_22764 = false;
        });
        this.mSwitchContainer = new ScreenTexturedButtonWidget(leftPos + 9, topPos + 27, 18, 19, 179, 93, GUI_TEXTURE, button -> {
            this.mSourceType = SourceType.URL;
            this.mSwitchURL.field_22764 = true;
            this.mSwitchContainer.field_22764 = false;
            this.mButtonExport.field_22764 = true;
        });
        this.mButtonExport = new ScreenTexturedButtonWidget(leftPos + 149, topPos + 7, 18, 19, 179, 33, GUI_TEXTURE, button -> this.sendExport());
        this.mSwitchSingleSided = new ScreenTexturedButtonWidget(leftPos + 9, topPos + 153, 18, 19, 179, 113, GUI_TEXTURE, button -> {
            this.mDoubleSided = true;
            this.mSwitchDoubleSided.field_22764 = true;
            this.mSwitchSingleSided.field_22764 = false;
        });
        this.mSwitchDoubleSided = new ScreenTexturedButtonWidget(leftPos + 9, topPos + 153, 18, 19, 179, 133, GUI_TEXTURE, button -> {
            this.mDoubleSided = false;
            this.mSwitchSingleSided.field_22764 = true;
            this.mSwitchDoubleSided.field_22764 = false;
        });
        this.mSwitchURL.field_22764 = this.mSourceType == SourceType.URL;
        this.mSwitchID.field_22764 = this.mSourceType == SourceType.ResourceID;
        this.mSwitchContainer.field_22764 = this.mSourceType == SourceType.ContainerBlock;
        this.mButtonExport.field_22764 = this.mSourceType != SourceType.ContainerBlock;
        this.mSwitchDoubleSided.field_22764 = this.mDoubleSided = this.mEntity.mDoubleSided;
        this.mSwitchSingleSided.field_22764 = !this.mDoubleSided;
        this.method_37063((class_364)this.mSwitchURL);
        this.method_37063((class_364)this.mSwitchID);
        this.method_37063((class_364)this.mSwitchContainer);
        this.method_37063((class_364)this.mButtonExport);
        this.method_37063((class_364)this.mSwitchSingleSided);
        this.method_37063((class_364)this.mSwitchDoubleSided);
    }

    private void updateRotation(ProjectorBlock.InternalRotation newRotation) {
        if (!(this.mInvalidOffsetX || this.mInvalidOffsetY || this.mInvalidOffsetZ)) {
            Vector3f absolute = ProjectorScreen.relativeToAbsolute(this.mImageOffset, this.mImageSize, this.mRotation);
            Vector3f newRelative = ProjectorScreen.absoluteToRelative(absolute, this.mImageSize, newRotation);
            this.mOffsetXInput.method_1852(ProjectorScreen.floatToString(newRelative.x()));
            this.mOffsetYInput.method_1852(ProjectorScreen.floatToString(newRelative.y()));
            this.mOffsetZInput.method_1852(ProjectorScreen.floatToString(newRelative.z()));
        }
        this.mRotation = newRotation;
    }

    private void updateSize(class_241 newSize) {
        if (!(this.mInvalidOffsetX || this.mInvalidOffsetY || this.mInvalidOffsetZ)) {
            Vector3f absolute = ProjectorScreen.relativeToAbsolute(this.mImageOffset, this.mImageSize, this.mRotation);
            Vector3f newRelative = ProjectorScreen.absoluteToRelative(absolute, newSize, this.mRotation);
            this.mOffsetXInput.method_1852(ProjectorScreen.floatToString(newRelative.x()));
            this.mOffsetYInput.method_1852(ProjectorScreen.floatToString(newRelative.y()));
            this.mOffsetZInput.method_1852(ProjectorScreen.floatToString(newRelative.z()));
        }
        this.mImageSize = newSize;
    }

    protected void method_37432() {
        if (this.mEntity == null) {
            this.field_22787.field_1724.method_7346();
        }
    }

    private void sendExport() {
        if (this.mSourceType == SourceType.ContainerBlock) {
            return;
        }
        ClientPlayNetworking.send((class_8710)new ProjectorExportC2SPayload(this.mSourceType == SourceType.ResourceID, this.mURLInput.method_1882()));
    }

    public void method_25432() {
        boolean invalidOffset;
        super.method_25432();
        if (this.mEntity == null) {
            return;
        }
        boolean invalidSize = this.mInvalidWidth || this.mInvalidHeight;
        boolean bl = invalidOffset = this.mInvalidOffsetX || this.mInvalidOffsetY || this.mInvalidOffsetZ;
        if (!this.mInvalidURL) {
            this.mEntity.mLocation = this.mURLInput.method_1882();
        }
        if (!this.mInvalidColor) {
            this.mEntity.mColor = this.mImageColor;
        }
        if (!invalidSize) {
            this.mEntity.mWidth = this.mImageSize.field_1343;
            this.mEntity.mHeight = this.mImageSize.field_1342;
        }
        if (!invalidOffset) {
            this.mEntity.mOffsetX = this.mImageOffset.x();
            this.mEntity.mOffsetY = this.mImageOffset.y();
            this.mEntity.mOffsetZ = this.mImageOffset.z();
        }
        this.mEntity.needInitContainer = this.mEntity.mSourceType != this.mSourceType;
        this.mEntity.mSourceType = this.mSourceType;
        this.mEntity.mDoubleSided = this.mDoubleSided;
        RegistryClient.sendToServer(new ProjectorAfterUpdateC2SPayload(this.mEntity, this.mRotation));
    }

    public boolean method_25404(int keyCode, int scanCode, int modifier) {
        if (this.mEntity == null) {
            return super.method_25404(keyCode, scanCode, modifier);
        }
        if (keyCode == 256) {
            this.field_22787.field_1724.method_7346();
            return true;
        }
        return this.mURLInput.method_25404(keyCode, scanCode, modifier) || this.mURLInput.method_20315() || this.mColorInput.method_25404(keyCode, scanCode, modifier) || this.mColorInput.method_20315() || this.mWidthInput.method_25404(keyCode, scanCode, modifier) || this.mWidthInput.method_20315() || this.mHeightInput.method_25404(keyCode, scanCode, modifier) || this.mHeightInput.method_20315() || this.mOffsetXInput.method_25404(keyCode, scanCode, modifier) || this.mOffsetXInput.method_20315() || this.mOffsetYInput.method_25404(keyCode, scanCode, modifier) || this.mOffsetYInput.method_20315() || this.mOffsetZInput.method_25404(keyCode, scanCode, modifier) || this.mOffsetZInput.method_20315() || super.method_25404(keyCode, scanCode, modifier);
    }

    protected void method_2389(class_332 context, float delta, int mouseX, int mouseY) {
        context.method_25302(GUI_TEXTURE, (this.field_22789 - this.imageWidth) / 2, (this.field_22790 - this.imageHeight) / 2, 0, 0, this.imageWidth, this.imageHeight);
    }

    protected void method_2388(class_332 ctx, int mouseX, int mouseY) {
        if (this.mEntity == null) {
            return;
        }
        int alpha = this.mImageColor >>> 24;
        if (alpha > 0) {
            int red = this.mImageColor >> 16 & 0xFF;
            int green = this.mImageColor >> 8 & 0xFF;
            int blue = this.mImageColor & 0xFF;
            RenderSystem.setShaderColor((float)((float)red / 255.0f), (float)((float)green / 255.0f), (float)((float)blue / 255.0f), (float)((float)alpha / 255.0f));
            ctx.method_25302(GUI_TEXTURE, 38, 131, 180, 194, 10, 10);
            ctx.method_25302(GUI_TEXTURE, 82, 159, 180, 194, 17, 17);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ctx.method_25302(GUI_TEXTURE, 82, 159, 202, 194 - this.mRotation.ordinal() * 20, 17, 17);
        ProjectorScreen.drawCenteredStringWithoutShadow(ctx, this.field_22793, IMAGE_TEXT, this.imageWidth / 2, -14);
        ProjectorScreen.drawCenteredStringWithoutShadow(ctx, this.field_22793, OFFSET_TEXT, this.imageWidth / 2, 60);
        ProjectorScreen.drawCenteredStringWithoutShadow(ctx, this.field_22793, OTHERS_TEXT, this.imageWidth / 2, 112);
        int offsetX = mouseX - (this.field_22789 - this.imageWidth) / 2;
        int offsetY = mouseY - (this.field_22790 - this.imageHeight) / 2;
        if (offsetX >= 9 && offsetY >= 27 && offsetX < 27 && offsetY < 46) {
            ctx.method_51438(this.field_22793, switch (this.mSourceType) {
                case SourceType.ResourceID -> ID_TEXT;
                case SourceType.ContainerBlock -> CONTAINER_TEXT;
                default -> URL_TEXT;
            }, offsetX, offsetY);
        } else if (offsetX >= 149 && offsetY >= 7 && offsetX < 167 && offsetY < 26) {
            if (this.mSourceType != SourceType.ContainerBlock) {
                ctx.method_51438(this.field_22793, EXPORT_TEXT, offsetX, offsetY);
            }
        } else if (offsetX >= 34 && offsetY >= 153 && offsetX < 52 && offsetY < 172) {
            ctx.method_51438(this.field_22793, COLOR_TEXT, offsetX, offsetY);
        } else if (offsetX >= 9 && offsetY >= 49 && offsetX < 27 && offsetY < 68) {
            ctx.method_51438(this.field_22793, WIDTH_TEXT, offsetX, offsetY);
        } else if (offsetX >= 90 && offsetY >= 49 && offsetX < 108 && offsetY < 68) {
            ctx.method_51438(this.field_22793, HEIGHT_TEXT, offsetX, offsetY);
        } else if (offsetX >= 9 && offsetY >= 101 && offsetX < 27 && offsetY < 120) {
            ctx.method_51438(this.field_22793, OFFSET_X_TEXT, offsetX, offsetY);
        } else if (offsetX >= 63 && offsetY >= 101 && offsetX < 81 && offsetY < 120) {
            ctx.method_51438(this.field_22793, OFFSET_Y_TEXT, offsetX, offsetY);
        } else if (offsetX >= 117 && offsetY >= 101 && offsetX < 135 && offsetY < 120) {
            ctx.method_51438(this.field_22793, OFFSET_Z_TEXT, offsetX, offsetY);
        } else if (offsetX >= 117 && offsetY >= 153 && offsetX < 135 && offsetY < 172) {
            ctx.method_51438(this.field_22793, FLIP_TEXT, offsetX, offsetY);
        } else if (offsetX >= 142 && offsetY >= 153 && offsetX < 160 && offsetY < 172) {
            ctx.method_51438(this.field_22793, ROTATE_TEXT, offsetX, offsetY);
        } else if (offsetX >= 9 && offsetY >= 153 && offsetX < 27 && offsetY < 172) {
            ctx.method_51438(this.field_22793, SINGLE_DOUBLE_SIDED_TEXT, offsetX, offsetY);
        }
    }

    private static void drawCenteredStringWithoutShadow(class_332 ctx, class_327 textRenderer, class_2561 text, int centerX, int y) {
        class_5481 orderedText = text.method_30937();
        ctx.method_51439(textRenderer, text, centerX - textRenderer.method_30880(orderedText) / 2, y, 0x404040, false);
    }

    private static float parseFloat(String text) {
        return (float)Math.round(Float.parseFloat(text) * 10000.0f) / 10000.0f;
    }

    private static String floatToString(float value) {
        return String.valueOf((float)Math.round(value * 10000.0f) / 10000.0f);
    }

    private static Vector3f relativeToAbsolute(Vector3f relatedOffset, class_241 size, ProjectorBlock.InternalRotation rotation) {
        Vector4f center = new Vector4f(0.5f * size.field_1343, 0.0f, 0.5f * size.field_1342, 1.0f);
        center.mul((Matrix4fc)new Matrix4f().translate(relatedOffset.x(), -relatedOffset.z(), relatedOffset.y()));
        center.mul((Matrix4fc)new Matrix4f().translate(-0.5f, 0.0f, 0.5f - size.field_1342));
        rotation.transform(center);
        return new Vector3f(center.x(), center.y(), center.z());
    }

    private static Vector3f absoluteToRelative(Vector3f absoluteOffset, class_241 size, ProjectorBlock.InternalRotation rotation) {
        Vector4f center = new Vector4f((Vector3fc)absoluteOffset, 1.0f);
        rotation.invert().transform(center);
        center.mul((Matrix4fc)new Matrix4f().translate(0.5f, 0.0f, -0.5f + size.field_1342));
        center.mul((Matrix4fc)new Matrix4f().translate(-0.5f * size.field_1343, 0.0f, -0.5f * size.field_1342));
        return new Vector3f(center.x(), center.z(), -center.y());
    }

    public static class ScreenTexturedButtonWidget
    extends class_4185 {
        public int u;
        public int v;
        public class_2960 texture;

        public ScreenTexturedButtonWidget(int x, int y, int width, int height, int u, int v, class_2960 texture, class_4185.class_4241 pressAction) {
            super(x, y, width, height, class_5244.field_39003, pressAction, field_40754);
            this.u = u;
            this.v = v;
            this.texture = texture;
        }

        public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
            context.method_25302(this.texture, this.method_46426(), this.method_46427(), this.u, this.v, this.field_22758, this.field_22759);
        }
    }
}

