/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.slides.projector;

import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector4f;
import java.nio.FloatBuffer;
import java.util.Arrays;
import java.util.Locale;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.teacon.slides.Slideshow;
import org.teacon.slides.item.FlipperItem;
import org.teacon.slides.projector.ProjectorBlockEntity;
import org.teacon.slides.projector.ProjectorScreenHandler;
import org.teacon.slides.util.Utilities;

public final class ProjectorBlock
extends BaseEntityBlock {
    public static final EnumProperty<InternalRotation> ROTATION = EnumProperty.m_61587_((String)"rotation", InternalRotation.class);
    public static final EnumProperty<Direction> BASE = EnumProperty.m_61594_((String)"base", Direction.class, (Predicate)Direction.Plane.VERTICAL);
    private static final VoxelShape SHAPE_WITH_BASE_UP = Block.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_WITH_BASE_DOWN = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);

    public ProjectorBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60978_(20.0f).m_60953_(state -> 15).m_60910_());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(BASE, (Comparable)Direction.DOWN)).m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)Direction.EAST)).m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.FALSE)).m_61124_(ROTATION, (Comparable)((Object)InternalRotation.NONE)));
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_(BASE)) {
            case Direction.DOWN -> SHAPE_WITH_BASE_DOWN;
            case Direction.UP -> SHAPE_WITH_BASE_UP;
            default -> throw new AssertionError();
        };
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BASE, BlockStateProperties.f_61372_, BlockStateProperties.f_61448_, ROTATION});
    }

    @NotNull
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction facing = context.m_7820_().m_122424_();
        Direction horizontalFacing = context.m_151260_().m_122424_();
        Direction base = Arrays.stream(context.m_6232_()).filter((Predicate<Direction>)Direction.Plane.VERTICAL).findFirst().orElse(Direction.DOWN);
        InternalRotation rotation = InternalRotation.VALUES[4 + Math.floorMod(facing.m_122430_() * horizontalFacing.m_122416_(), 4)];
        return (BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(BASE, (Comparable)base)).m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)facing)).m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.FALSE)).m_61124_(ROTATION, (Comparable)((Object)rotation));
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean powered = worldIn.m_46753_(pos);
        if (powered != (Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_)) {
            worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(powered)));
        }
    }

    public void m_6807_(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        boolean powered;
        if (!oldState.m_60713_(state.m_60734_()) && (powered = worldIn.m_46753_(pos)) != (Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_)) {
            worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(powered)));
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return world.f_46443_ ? null : ProjectorBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)Slideshow.PROJECTOR_BLOCK_ENTITY.get()), (world1, pos, state1, entity) -> ProjectorBlockEntity.tick(world1, pos, entity));
    }

    @NotNull
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        Direction direction = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
        return switch (direction) {
            case Direction.DOWN, Direction.UP -> (BlockState)state.m_61124_(ROTATION, (Comparable)((Object)((InternalRotation)((Object)state.m_61143_(ROTATION))).compose(Rotation.CLOCKWISE_180)));
            default -> (BlockState)state.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)mirror.m_54846_(direction).m_55954_(direction));
        };
    }

    @NotNull
    public BlockState m_6843_(BlockState state, Rotation rotation) {
        Direction direction = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
        return switch (direction) {
            case Direction.DOWN, Direction.UP -> (BlockState)state.m_61124_(ROTATION, (Comparable)((Object)((InternalRotation)((Object)state.m_61143_(ROTATION))).compose(rotation)));
            default -> (BlockState)state.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)rotation.m_55954_(direction));
        };
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!world.m_5776_()) {
            if (!ProjectorBlock.hasProjectorPermission((ServerPlayer)player)) {
                return InteractionResult.FAIL;
            }
            ItemStack itemStack = player.m_21120_(hand);
            if (itemStack.m_150930_((Item)Slideshow.FLIPPER_ITEM.get())) {
                FlipperItem.setProjectorPos(itemStack, pos);
                Utilities.sendOverLayMessage(player, (Component)Component.m_237115_((String)"info.slide_show.bound_projector").m_130940_(ChatFormatting.AQUA));
                return InteractionResult.CONSUME;
            }
            MenuProvider factory = this.m_7246_(state, world, pos);
            if (!(factory instanceof ProjectorBlockEntity)) {
                return InteractionResult.FAIL;
            }
            ProjectorBlockEntity projectorBlockEntity = (ProjectorBlockEntity)factory;
            ProjectorScreenHandler.openScreen((ServerPlayer)player, projectorBlockEntity);
        }
        return InteractionResult.SUCCESS;
    }

    public static boolean hasProjectorPermission(ServerPlayer serverPlayer) {
        return serverPlayer.m_36337_();
    }

    public RenderShape m_7514_(BlockState blockState) {
        return RenderShape.MODEL;
    }

    private static boolean hasPermission(GameType gameType) {
        return gameType == GameType.CREATIVE || gameType == GameType.SURVIVAL;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ProjectorBlockEntity(pos, state);
    }

    public static enum InternalRotation implements StringRepresentable
    {
        NONE(1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f),
        CLOCKWISE_90(0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f),
        CLOCKWISE_180(-1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f),
        COUNTERCLOCKWISE_90(0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f),
        HORIZONTAL_FLIPPED(-1.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f),
        DIAGONAL_FLIPPED(0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f),
        VERTICAL_FLIPPED(1.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f),
        ANTI_DIAGONAL_FLIPPED(0.0f, 0.0f, 1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f);

        public static final InternalRotation[] VALUES;
        private static final int[] INV_INDICES;
        private static final int[] FLIP_INDICES;
        private static final int[][] ROTATION_INDICES;
        private final String mSerializedName;
        private final Matrix4f mMatrix = new Matrix4f();
        private final Matrix3f mNormal = new Matrix3f();

        private InternalRotation(float m00, float m10, float m20, float m30, float m01, float m11, float m21, float m31, float m02, float m12, float m22, float m32) {
            this.mMatrix.m_162212_(FloatBuffer.wrap(new float[]{m00, m01, m02, 0.0f, m10, m11, m12, 0.0f, m20, m21, m22, 0.0f, m30, m31, m32, 1.0f}));
            this.mNormal.m_152768_(FloatBuffer.wrap(new float[]{m00, m01, m02, m10, m11, m12, m20, m21, m22}));
            this.mSerializedName = this.name().toLowerCase(Locale.ROOT);
        }

        public InternalRotation compose(Rotation rotation) {
            return VALUES[ROTATION_INDICES[rotation.ordinal()][this.ordinal()]];
        }

        public InternalRotation flip() {
            return VALUES[FLIP_INDICES[this.ordinal()]];
        }

        public InternalRotation invert() {
            return VALUES[INV_INDICES[this.ordinal()]];
        }

        public boolean isFlipped() {
            return this.ordinal() >= 4;
        }

        public void transform(Vector4f vector) {
            vector.m_123607_(this.mMatrix);
        }

        public void transform(Matrix4f poseMatrix) {
            poseMatrix.m_27644_(this.mMatrix);
        }

        public void transform(Matrix3f normalMatrix) {
            normalMatrix.m_8178_(this.mNormal);
        }

        @NotNull
        public final String m_7912_() {
            return this.mSerializedName;
        }

        static {
            VALUES = InternalRotation.values();
            INV_INDICES = new int[]{0, 3, 2, 1, 4, 5, 6, 7};
            FLIP_INDICES = new int[]{4, 7, 6, 5, 0, 3, 2, 1};
            ROTATION_INDICES = new int[][]{{0, 1, 2, 3, 4, 5, 6, 7}, {1, 2, 3, 0, 5, 6, 7, 4}, {2, 3, 0, 1, 6, 7, 4, 5}, {3, 0, 1, 2, 7, 4, 5, 6}};
        }
    }
}

