/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.slides.renderer;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.teacon.slides.renderer.SlideRenderType;
import org.teacon.slides.texture.TextureProvider;

public abstract class Slide
implements AutoCloseable {
    public abstract void render(@NotNull MultiBufferSource var1, @NotNull Matrix4f var2, @NotNull Matrix3f var3, float var4, float var5, int var6, int var7, int var8, boolean var9, boolean var10, long var11, float var13);

    @Override
    public void close() {
    }

    public int getWidth() {
        return 0;
    }

    public int getHeight() {
        return 0;
    }

    public int getGPUMemorySize() {
        return this.getWidth() * this.getHeight() << 2;
    }

    @NotNull
    static Slide make(TextureProvider texture) {
        return new Image(texture);
    }

    public static Slide empty() {
        return Icon.DEFAULT_EMPTY;
    }

    public static Slide failed() {
        return Icon.DEFAULT_FAILED;
    }

    public static Slide loading() {
        return Icon.DEFAULT_LOADING;
    }

    public static final class Image
    extends Slide {
        private final TextureProvider mTexture;

        private Image(TextureProvider texture) {
            this.mTexture = texture;
        }

        @Override
        public void render(@NotNull MultiBufferSource source, @NotNull Matrix4f matrix, @NotNull Matrix3f normal, float width, float height, int color, int light, int overlay, boolean front, boolean back, long tick, float partialTick) {
            int red = color >> 16 & 0xFF;
            int green = color >> 8 & 0xFF;
            int blue = color & 0xFF;
            int alpha = color >>> 24;
            VertexConsumer builder = source.m_6299_((RenderType)this.mTexture.updateAndGet(tick, partialTick));
            if (front) {
                builder.m_85982_(matrix, 0.0f, 0.0052083335f, 1.0f).m_6122_(red, green, blue, alpha).m_7421_(0.0f, 1.0f).m_85969_(light).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, 1.0f, 0.0052083335f, 1.0f).m_6122_(red, green, blue, alpha).m_7421_(1.0f, 1.0f).m_85969_(light).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, 1.0f, 0.0052083335f, 0.0f).m_6122_(red, green, blue, alpha).m_7421_(1.0f, 0.0f).m_85969_(light).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, 0.0f, 0.0052083335f, 0.0f).m_6122_(red, green, blue, alpha).m_7421_(0.0f, 0.0f).m_85969_(light).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
            }
            if (back) {
                builder.m_85982_(matrix, 0.0f, -0.00390625f, 0.0f).m_6122_(red, green, blue, alpha).m_7421_(0.0f, 0.0f).m_85969_(light).m_85977_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, 1.0f, -0.00390625f, 0.0f).m_6122_(red, green, blue, alpha).m_7421_(1.0f, 0.0f).m_85969_(light).m_85977_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, 1.0f, -0.00390625f, 1.0f).m_6122_(red, green, blue, alpha).m_7421_(1.0f, 1.0f).m_85969_(light).m_85977_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, 0.0f, -0.00390625f, 1.0f).m_6122_(red, green, blue, alpha).m_7421_(0.0f, 1.0f).m_85969_(light).m_85977_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
            }
        }

        @Override
        public void close() {
            this.mTexture.close();
        }

        @Override
        public int getWidth() {
            return this.mTexture.getWidth();
        }

        @Override
        public int getHeight() {
            return this.mTexture.getHeight();
        }

        public String toString() {
            return "ImageSlide{texture=" + this.mTexture + "}";
        }
    }

    public static final class Icon
    extends Slide {
        private static final ResourceLocation BACKGROUND = ResourceLocation.m_214293_((String)"slide_show", (String)"textures/gui/slide_default.png");
        private static final ResourceLocation ICON_EMPTY = ResourceLocation.m_214293_((String)"slide_show", (String)"textures/gui/slide_icon_empty.png");
        private static final ResourceLocation ICON_FAILED = ResourceLocation.m_214293_((String)"slide_show", (String)"textures/gui/slide_icon_failed.png");
        private static final ResourceLocation ICON_LOADING = ResourceLocation.m_214293_((String)"slide_show", (String)"textures/gui/slide_icon_loading.png");
        private static final RenderType sBackgroundRenderType = new SlideRenderType(BACKGROUND);
        private static final Icon DEFAULT_EMPTY = new Icon(ICON_EMPTY);
        private static final Icon DEFAULT_FAILED = new Icon(ICON_FAILED);
        private static final Icon DEFAULT_LOADING = new Icon(ICON_LOADING);
        private final RenderType mIconRenderType;

        private Icon(ResourceLocation icon) {
            this.mIconRenderType = new SlideRenderType(icon);
        }

        private static float getFactor(float width, float height) {
            return Math.min(width, height) / (24.0f + Mth.m_14199_((float)(0.00390625f / (width * width + height * height))));
        }

        @Override
        public void render(@NotNull MultiBufferSource source, @NotNull Matrix4f matrix, @NotNull Matrix3f normal, float width, float height, int color, int light, int overlay, boolean front, boolean back, long tick, float partialTick) {
            int alpha;
            if ((front || back) && (alpha = color >>> 24) > 0) {
                float factor = Icon.getFactor(width, height);
                int xSize = Math.round(width / factor);
                int ySize = Math.round(height / factor);
                this.renderIcon(source, matrix, normal, alpha, light, xSize, ySize, front, back);
                this.renderBackground(source, matrix, normal, alpha, light, xSize, ySize, front, back);
            }
        }

        private void renderIcon(@NotNull MultiBufferSource source, Matrix4f matrix, Matrix3f normal, int alpha, int light, int xSize, int ySize, boolean front, boolean back) {
            VertexConsumer builder = source.m_6299_(this.mIconRenderType);
            float x1 = (1.0f - 19.0f / (float)xSize) / 2.0f;
            float x2 = 1.0f - x1;
            float y1 = (1.0f - 16.0f / (float)ySize) / 2.0f;
            float y2 = 1.0f - y1;
            if (front) {
                builder.m_85982_(matrix, x1, 0.0078125f, y2).m_6122_(255, 255, 255, alpha).m_7421_(0.0f, 1.0f).m_85969_(light).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, x2, 0.0078125f, y2).m_6122_(255, 255, 255, alpha).m_7421_(1.0f, 1.0f).m_85969_(light).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, x2, 0.0078125f, y1).m_6122_(255, 255, 255, alpha).m_7421_(1.0f, 0.0f).m_85969_(light).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, x1, 0.0078125f, y1).m_6122_(255, 255, 255, alpha).m_7421_(0.0f, 0.0f).m_85969_(light).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
            }
            if (back) {
                builder.m_85982_(matrix, x1, -0.0078125f, y1).m_6122_(255, 255, 255, alpha).m_7421_(0.0f, 0.0f).m_85969_(light).m_85977_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, x2, -0.0078125f, y1).m_6122_(255, 255, 255, alpha).m_7421_(1.0f, 0.0f).m_85969_(light).m_85977_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, x2, -0.0078125f, y2).m_6122_(255, 255, 255, alpha).m_7421_(1.0f, 1.0f).m_85969_(light).m_85977_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, x1, -0.0078125f, y2).m_6122_(255, 255, 255, alpha).m_7421_(0.0f, 1.0f).m_85969_(light).m_85977_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
            }
        }

        private void renderBackground(@NotNull MultiBufferSource source, Matrix4f matrix, Matrix3f normal, int alpha, int light, int xSize, int ySize, boolean front, boolean back) {
            VertexConsumer builder = source.m_6299_(sBackgroundRenderType);
            float u1 = 0.47368422f;
            float u2 = 0.5263158f;
            float x1 = 9.0f / (float)xSize;
            float x2 = 1.0f - x1;
            float y1 = 9.0f / (float)ySize;
            float y2 = 1.0f - y1;
            if (front) {
                builder.m_85982_(matrix, 0.0f, 0.00390625f, y1).m_6122_(255, 255, 255, alpha).m_7421_(0.0f, u1).m_85969_(light).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, x1, 0.00390625f, y1).m_6122_(255, 255, 255, alpha).m_7421_(u1, u1).m_85969_(light).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, x1, 0.00390625f, 0.0f).m_6122_(255, 255, 255, alpha).m_7421_(u1, 0.0f).m_85969_(light).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, 0.0f, 0.00390625f, 0.0f).m_6122_(255, 255, 255, alpha).m_7421_(0.0f, 0.0f).m_85969_(light).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, 0.0f, 0.00390625f, y2).m_6122_(255, 255, 255, alpha).m_7421_(0.0f, u2).m_85969_(light).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, x1, 0.00390625f, y2).m_6122_(255, 255, 255, alpha).m_7421_(u1, u2).m_85969_(light).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, x1, 0.00390625f, y1).m_6122_(255, 255, 255, alpha).m_7421_(u1, u1).m_85969_(light).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, 0.0f, 0.00390625f, y1).m_6122_(255, 255, 255, alpha).m_7421_(0.0f, u1).m_85969_(light).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, 0.0f, 0.00390625f, 1.0f).m_6122_(255, 255, 255, alpha).m_7421_(0.0f, 1.0f).m_85969_(light).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, x1, 0.00390625f, 1.0f).m_6122_(255, 255, 255, alpha).m_7421_(u1, 1.0f).m_85969_(light).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, x1, 0.00390625f, y2).m_6122_(255, 255, 255, alpha).m_7421_(u1, u2).m_85969_(light).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, 0.0f, 0.00390625f, y2).m_6122_(255, 255, 255, alpha).m_7421_(0.0f, u2).m_85969_(light).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, x1, 0.00390625f, y1).m_6122_(255, 255, 255, alpha).m_7421_(u1, u1).m_85969_(light).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, x2, 0.00390625f, y1).m_6122_(255, 255, 255, alpha).m_7421_(u2, u1).m_85969_(light).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, x2, 0.00390625f, 0.0f).m_6122_(255, 255, 255, alpha).m_7421_(u2, 0.0f).m_85969_(light).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, x1, 0.00390625f, 0.0f).m_6122_(255, 255, 255, alpha).m_7421_(u1, 0.0f).m_85969_(light).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, x1, 0.00390625f, y2).m_6122_(255, 255, 255, alpha).m_7421_(u1, u2).m_85969_(light).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, x2, 0.00390625f, y2).m_6122_(255, 255, 255, alpha).m_7421_(u2, u2).m_85969_(light).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, x2, 0.00390625f, y1).m_6122_(255, 255, 255, alpha).m_7421_(u2, u1).m_85969_(light).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, x1, 0.00390625f, y1).m_6122_(255, 255, 255, alpha).m_7421_(u1, u1).m_85969_(light).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, x1, 0.00390625f, 1.0f).m_6122_(255, 255, 255, alpha).m_7421_(u1, 1.0f).m_85969_(light).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, x2, 0.00390625f, 1.0f).m_6122_(255, 255, 255, alpha).m_7421_(u2, 1.0f).m_85969_(light).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, x2, 0.00390625f, y2).m_6122_(255, 255, 255, alpha).m_7421_(u2, u2).m_85969_(light).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, x1, 0.00390625f, y2).m_6122_(255, 255, 255, alpha).m_7421_(u1, u2).m_85969_(light).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, x2, 0.00390625f, y1).m_6122_(255, 255, 255, alpha).m_7421_(u2, u1).m_85969_(light).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, 1.0f, 0.00390625f, y1).m_6122_(255, 255, 255, alpha).m_7421_(1.0f, u1).m_85969_(light).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, 1.0f, 0.00390625f, 0.0f).m_6122_(255, 255, 255, alpha).m_7421_(1.0f, 0.0f).m_85969_(light).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, x2, 0.00390625f, 0.0f).m_6122_(255, 255, 255, alpha).m_7421_(u2, 0.0f).m_85969_(light).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, x2, 0.00390625f, y2).m_6122_(255, 255, 255, alpha).m_7421_(u2, u2).m_85969_(light).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, 1.0f, 0.00390625f, y2).m_6122_(255, 255, 255, alpha).m_7421_(1.0f, u2).m_85969_(light).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, 1.0f, 0.00390625f, y1).m_6122_(255, 255, 255, alpha).m_7421_(1.0f, u1).m_85969_(light).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, x2, 0.00390625f, y1).m_6122_(255, 255, 255, alpha).m_7421_(u2, u1).m_85969_(light).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, x2, 0.00390625f, 1.0f).m_6122_(255, 255, 255, alpha).m_7421_(u2, 1.0f).m_85969_(light).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, 1.0f, 0.00390625f, 1.0f).m_6122_(255, 255, 255, alpha).m_7421_(1.0f, 1.0f).m_85969_(light).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, 1.0f, 0.00390625f, y2).m_6122_(255, 255, 255, alpha).m_7421_(1.0f, u2).m_85969_(light).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, x2, 0.00390625f, y2).m_6122_(255, 255, 255, alpha).m_7421_(u2, u2).m_85969_(light).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
            }
            if (back) {
                builder.m_85982_(matrix, 0.0f, -0.00390625f, 0.0f).m_6122_(255, 255, 255, alpha).m_7421_(0.0f, 0.0f).m_85969_(light).m_85977_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, x1, -0.00390625f, 0.0f).m_6122_(255, 255, 255, alpha).m_7421_(u1, 0.0f).m_85969_(light).m_85977_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, x1, -0.00390625f, y1).m_6122_(255, 255, 255, alpha).m_7421_(u1, u1).m_85969_(light).m_85977_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, 0.0f, -0.00390625f, y1).m_6122_(255, 255, 255, alpha).m_7421_(0.0f, u1).m_85969_(light).m_85977_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, 0.0f, -0.00390625f, y1).m_6122_(255, 255, 255, alpha).m_7421_(0.0f, u1).m_85969_(light).m_85977_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, x1, -0.00390625f, y1).m_6122_(255, 255, 255, alpha).m_7421_(u1, u1).m_85969_(light).m_85977_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, x1, -0.00390625f, y2).m_6122_(255, 255, 255, alpha).m_7421_(u1, u2).m_85969_(light).m_85977_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, 0.0f, -0.00390625f, y2).m_6122_(255, 255, 255, alpha).m_7421_(0.0f, u2).m_85969_(light).m_85977_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, 0.0f, -0.00390625f, y2).m_6122_(255, 255, 255, alpha).m_7421_(0.0f, u2).m_85969_(light).m_85977_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, x1, -0.00390625f, y2).m_6122_(255, 255, 255, alpha).m_7421_(u1, u2).m_85969_(light).m_85977_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, x1, -0.00390625f, 1.0f).m_6122_(255, 255, 255, alpha).m_7421_(u1, 1.0f).m_85969_(light).m_85977_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, 0.0f, -0.00390625f, 1.0f).m_6122_(255, 255, 255, alpha).m_7421_(0.0f, 1.0f).m_85969_(light).m_85977_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, x1, -0.00390625f, 0.0f).m_6122_(255, 255, 255, alpha).m_7421_(u1, 0.0f).m_85969_(light).m_85977_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, x2, -0.00390625f, 0.0f).m_6122_(255, 255, 255, alpha).m_7421_(u2, 0.0f).m_85969_(light).m_85977_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, x2, -0.00390625f, y1).m_6122_(255, 255, 255, alpha).m_7421_(u2, u1).m_85969_(light).m_85977_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, x1, -0.00390625f, y1).m_6122_(255, 255, 255, alpha).m_7421_(u1, u1).m_85969_(light).m_85977_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, x1, -0.00390625f, y1).m_6122_(255, 255, 255, alpha).m_7421_(u1, u1).m_85969_(light).m_85977_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, x2, -0.00390625f, y1).m_6122_(255, 255, 255, alpha).m_7421_(u2, u1).m_85969_(light).m_85977_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, x2, -0.00390625f, y2).m_6122_(255, 255, 255, alpha).m_7421_(u2, u2).m_85969_(light).m_85977_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, x1, -0.00390625f, y2).m_6122_(255, 255, 255, alpha).m_7421_(u1, u2).m_85969_(light).m_85977_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, x1, -0.00390625f, y2).m_6122_(255, 255, 255, alpha).m_7421_(u1, u2).m_85969_(light).m_85977_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, x2, -0.00390625f, y2).m_6122_(255, 255, 255, alpha).m_7421_(u2, u2).m_85969_(light).m_85977_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, x2, -0.00390625f, 1.0f).m_6122_(255, 255, 255, alpha).m_7421_(u2, 1.0f).m_85969_(light).m_85977_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, x1, -0.00390625f, 1.0f).m_6122_(255, 255, 255, alpha).m_7421_(u1, 1.0f).m_85969_(light).m_85977_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, x2, -0.00390625f, 0.0f).m_6122_(255, 255, 255, alpha).m_7421_(u2, 0.0f).m_85969_(light).m_85977_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, 1.0f, -0.00390625f, 0.0f).m_6122_(255, 255, 255, alpha).m_7421_(1.0f, 0.0f).m_85969_(light).m_85977_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, 1.0f, -0.00390625f, y1).m_6122_(255, 255, 255, alpha).m_7421_(1.0f, u1).m_85969_(light).m_85977_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, x2, -0.00390625f, y1).m_6122_(255, 255, 255, alpha).m_7421_(u2, u1).m_85969_(light).m_85977_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, x2, -0.00390625f, y1).m_6122_(255, 255, 255, alpha).m_7421_(u2, u1).m_85969_(light).m_85977_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, 1.0f, -0.00390625f, y1).m_6122_(255, 255, 255, alpha).m_7421_(1.0f, u1).m_85969_(light).m_85977_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, 1.0f, -0.00390625f, y2).m_6122_(255, 255, 255, alpha).m_7421_(1.0f, u2).m_85969_(light).m_85977_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, x2, -0.00390625f, y2).m_6122_(255, 255, 255, alpha).m_7421_(u2, u2).m_85969_(light).m_85977_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, x2, -0.00390625f, y2).m_6122_(255, 255, 255, alpha).m_7421_(u2, u2).m_85969_(light).m_85977_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, 1.0f, -0.00390625f, y2).m_6122_(255, 255, 255, alpha).m_7421_(1.0f, u2).m_85969_(light).m_85977_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, 1.0f, -0.00390625f, 1.0f).m_6122_(255, 255, 255, alpha).m_7421_(1.0f, 1.0f).m_85969_(light).m_85977_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
                builder.m_85982_(matrix, x2, -0.00390625f, 1.0f).m_6122_(255, 255, 255, alpha).m_7421_(u2, 1.0f).m_85969_(light).m_85977_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
            }
        }

        public String toString() {
            return "IconSlide{iconRenderType=" + this.mIconRenderType + "}";
        }
    }
}

