/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.slides.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.teacon.slides.command.UnsignedMessageArgumentType;
import org.teacon.slides.network.ProjectorExportC2SPayload;

public class ImageCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"image").requires(source -> source.hasPermission(2) && source.getEntity() instanceof Player)).then(Commands.literal((String)"id").then(Commands.argument((String)"identifier", (ArgumentType)ResourceLocationArgument.id()).executes(context -> ImageCommand.executeExportId((CommandSourceStack)context.getSource(), ResourceLocationArgument.getId((CommandContext)context, (String)"identifier")))))).then(Commands.literal((String)"url").then(Commands.argument((String)"url_string", (ArgumentType)UnsignedMessageArgumentType.message()).executes(context -> ImageCommand.executeExportUrl((CommandSourceStack)context.getSource(), UnsignedMessageArgumentType.getMessage((CommandContext<CommandSourceStack>)context, "url_string"))))));
    }

    private static int executeExportId(CommandSourceStack source, ResourceLocation id) {
        Entity entity = source.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return 0;
        }
        ServerPlayer player = (ServerPlayer)entity;
        return ProjectorExportC2SPayload.giveImageItem(player, true, id.toString()) ? 1 : 0;
    }

    private static int executeExportUrl(CommandSourceStack source, String url) {
        Entity entity = source.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return 0;
        }
        ServerPlayer player = (ServerPlayer)entity;
        return ProjectorExportC2SPayload.giveImageItem(player, false, url) ? 1 : 0;
    }
}

