/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.slides.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.teacon.slides.projector.ProjectorBlockEntity;

public class ProjectorCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"projector").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"next").then(Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).executes(context -> ProjectorCommand.executeFlip((CommandSourceStack)context.getSource(), BlockPosArgument.getBlockPos((CommandContext)context, (String)"pos"), false, false))))).then(Commands.literal((String)"prev").then(Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).executes(context -> ProjectorCommand.executeFlip((CommandSourceStack)context.getSource(), BlockPosArgument.getBlockPos((CommandContext)context, (String)"pos"), true, false))))).then(Commands.literal((String)"first").then(Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).executes(context -> ProjectorCommand.executeFlip((CommandSourceStack)context.getSource(), BlockPosArgument.getBlockPos((CommandContext)context, (String)"pos"), false, true)))));
    }

    public static int executeFlip(CommandSourceStack source, BlockPos pos, boolean back, boolean init) {
        BlockEntity entity = source.getLevel().getBlockEntity(pos);
        if (!(entity instanceof ProjectorBlockEntity)) {
            source.sendFailure((Component)Component.translatable((String)"chat.slide_show.no_projector"));
            return 0;
        }
        ProjectorBlockEntity entity1 = (ProjectorBlockEntity)entity;
        if (!entity1.canFlip()) {
            source.sendFailure((Component)Component.translatable((String)"chat.slide_show.cannot_flip"));
            return 0;
        }
        if (init) {
            entity1.needInitContainer = true;
            source.sendSystemMessage((Component)Component.translatable((String)"chat.slide_show.initialized"));
            return 1;
        }
        entity1.needHandleReadImage = true;
        if (back) {
            entity1.flipBack = true;
        }
        source.sendSystemMessage((Component)Component.translatable((String)"chat.slide_show.flipped"));
        return 1;
    }
}

