/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.slides.network;

import java.util.List;
import java.util.Optional;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.NetworkRegistry;
import org.teacon.slides.network.FlipperFlipBackC2SPayload;
import org.teacon.slides.network.ProjectorAfterUpdateC2SPayload;
import org.teacon.slides.network.ProjectorExportC2SPayload;
import org.teacon.slides.network.ProjectorImageInfoS2CPayload;

public class Network {
    public static final String NETWORK_VERSION = "1";
    public static final ResourceLocation PACKET_UPDATE = ResourceLocation.fromNamespaceAndPath((String)"slide_show", (String)"update");
    public static final ResourceLocation PACKET_EXPORT = ResourceLocation.fromNamespaceAndPath((String)"slide_show", (String)"export");
    public static final ResourceLocation PACKET_FLIP_BACK = ResourceLocation.fromNamespaceAndPath((String)"slide_show", (String)"flip_back");
    public static final ResourceLocation PACKET_TAG_UPDATE = ResourceLocation.fromNamespaceAndPath((String)"slide_show", (String)"tag_update");

    private static <T extends CustomPacketPayload> void register(CustomPacketPayload.Type<T> type, StreamCodec<? super RegistryFriendlyByteBuf, T> reader, IPayloadHandler<T> handler, PacketFlow flow) {
        NetworkRegistry.register(type, reader, handler, List.of(ConnectionProtocol.PLAY), Optional.of(flow), (String)NETWORK_VERSION, (boolean)false);
    }

    public static void registerNetwork() {
        Network.register(FlipperFlipBackC2SPayload.ID, StreamCodec.ofMember(FlipperFlipBackC2SPayload::writeBuffer, FlipperFlipBackC2SPayload::new), FlipperFlipBackC2SPayload::handle, PacketFlow.SERVERBOUND);
        Network.register(ProjectorAfterUpdateC2SPayload.ID, StreamCodec.ofMember(ProjectorAfterUpdateC2SPayload::writeBuffer, ProjectorAfterUpdateC2SPayload::new), ProjectorAfterUpdateC2SPayload::handle, PacketFlow.SERVERBOUND);
        Network.register(ProjectorExportC2SPayload.ID, StreamCodec.ofMember(ProjectorExportC2SPayload::writeBuffer, ProjectorExportC2SPayload::new), ProjectorExportC2SPayload::handle, PacketFlow.SERVERBOUND);
        Network.register(ProjectorImageInfoS2CPayload.ID, StreamCodec.ofMember(ProjectorImageInfoS2CPayload::writeBuffer, ProjectorImageInfoS2CPayload::new), ProjectorImageInfoS2CPayload::handle, PacketFlow.CLIENTBOUND);
    }
}

