/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.slides.config;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import net.minecraft.client.Minecraft;
import org.apache.http.HttpHost;
import org.teacon.slides.Slideshow;

public final class Config {
    private static boolean proxySwitch = false;
    private static String host = "localhost";
    private static int port = 8080;
    private static int renderDistance = 256;
    private static HttpHost PROXY;
    private static final String PROXY_SWITCH = "proxySwitch";
    private static final String HOST = "host";
    private static final String PORT = "port";
    private static final String VIEW_DISTANCE = "slideshowViewDistance";
    public static final int MAX_VIEW_DISTANCE = 512;
    private static final Path CONFIG_PATH;

    public static boolean isProxySwitch() {
        return proxySwitch;
    }

    public static int getRenderDistance() {
        return renderDistance;
    }

    public static String getHost() {
        return host;
    }

    public static int getPort() {
        return port;
    }

    public static HttpHost getPROXY() {
        return PROXY;
    }

    public static void setProxySwitch(boolean proxySwitch) {
        Config.proxySwitch = proxySwitch;
    }

    public static void setHost(String host) {
        Config.host = host;
    }

    public static void setPort(int port) {
        Config.port = port;
    }

    public static void setRenderDistance(int renderDistance) {
        Config.renderDistance = renderDistance;
    }

    public static void saveToFile() {
        Config.writeToFile();
    }

    public static void refreshProperties() {
        Slideshow.LOGGER.info("Refreshed Slideshow mod config");
        try {
            JsonParser parser = new JsonParser();
            JsonObject jsonConfig = parser.parse(String.join((CharSequence)"", Files.readAllLines(CONFIG_PATH))).getAsJsonObject();
            try {
                proxySwitch = jsonConfig.get(PROXY_SWITCH).getAsBoolean();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                host = jsonConfig.get(HOST).getAsString();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                port = jsonConfig.get(PORT).getAsInt();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                renderDistance = jsonConfig.get(VIEW_DISTANCE).getAsInt();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (proxySwitch) {
                PROXY = new HttpHost(host, port);
                Slideshow.LOGGER.info("Proxy loaded");
                Slideshow.LOGGER.info("host: {}", (Object)host);
                Slideshow.LOGGER.info("port: {}", (Object)port);
            } else {
                PROXY = null;
            }
        }
        catch (Exception e) {
            Config.writeToFile();
            Config.refreshProperties();
        }
    }

    private static void writeToFile() {
        Slideshow.LOGGER.info("Wrote Slideshow mod config to file");
        JsonObject jsonConfig = new JsonObject();
        jsonConfig.addProperty(PROXY_SWITCH, Boolean.valueOf(proxySwitch));
        jsonConfig.addProperty(HOST, host);
        jsonConfig.addProperty(PORT, (Number)port);
        jsonConfig.addProperty(VIEW_DISTANCE, (Number)renderDistance);
        try {
            if (!Files.exists(CONFIG_PATH.getParent(), new LinkOption[0])) {
                Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            }
            Files.write(CONFIG_PATH, Collections.singleton(Config.prettyPrint((JsonElement)jsonConfig)), new OpenOption[0]);
        }
        catch (IOException e) {
            Slideshow.LOGGER.error("Configuration file write exception", (Throwable)e);
        }
    }

    private static String prettyPrint(JsonElement jsonElement) {
        return new GsonBuilder().setPrettyPrinting().create().toJson(jsonElement);
    }

    static {
        CONFIG_PATH = Minecraft.m_91087_().f_91069_.toPath().resolve("config").resolve("slideshow.json");
    }
}

