/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.slides.projector;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec2;
import org.apache.commons.lang3.StringUtils;
import org.teacon.slides.network.Network;
import org.teacon.slides.network.ProjectorAfterUpdateC2SPacket;
import org.teacon.slides.network.ProjectorExportC2SPacket;
import org.teacon.slides.projector.ProjectorBlock;
import org.teacon.slides.projector.ProjectorBlockEntity;
import org.teacon.slides.projector.ProjectorScreenHandler;
import org.teacon.slides.projector.SourceType;
import org.teacon.slides.renderer.SlideState;
import org.teacon.slides.util.RenderUtils;
import org.teacon.slides.util.Text;

public final class ProjectorScreen
extends AbstractContainerScreen<ProjectorScreenHandler> {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("slide_show", "textures/gui/projector.png");
    private static final Component IMAGE_TEXT = Text.translatable("gui.slide_show.section.image", new Object[0]);
    private static final Component OFFSET_TEXT = Text.translatable("gui.slide_show.section.offset", new Object[0]);
    private static final Component OTHERS_TEXT = Text.translatable("gui.slide_show.section.others", new Object[0]);
    private static final Component URL_TEXT = Text.translatable("gui.slide_show.url", new Object[0]);
    private static final Component ID_TEXT = Text.translatable("gui.slide_show.id", new Object[0]);
    private static final Component EXPORT_TEXT = Text.translatable("gui.slide_show.export", new Object[0]);
    private static final Component CONTAINER_TEXT = Text.translatable("gui.slide_show.container", new Object[0]);
    private static final Component COLOR_TEXT = Text.translatable("gui.slide_show.color", new Object[0]);
    private static final Component WIDTH_TEXT = Text.translatable("gui.slide_show.width", new Object[0]);
    private static final Component HEIGHT_TEXT = Text.translatable("gui.slide_show.height", new Object[0]);
    private static final Component OFFSET_X_TEXT = Text.translatable("gui.slide_show.offset_x", new Object[0]);
    private static final Component OFFSET_Y_TEXT = Text.translatable("gui.slide_show.offset_y", new Object[0]);
    private static final Component OFFSET_Z_TEXT = Text.translatable("gui.slide_show.offset_z", new Object[0]);
    private static final Component FLIP_TEXT = Text.translatable("gui.slide_show.flip", new Object[0]);
    private static final Component ROTATE_TEXT = Text.translatable("gui.slide_show.rotate", new Object[0]);
    private static final Component SINGLE_DOUBLE_SIDED_TEXT = Text.translatable("gui.slide_show.single_double_sided", new Object[0]);
    private EditBox mURLInput;
    private EditBox mColorInput;
    private EditBox mWidthInput;
    private EditBox mHeightInput;
    private EditBox mOffsetXInput;
    private EditBox mOffsetYInput;
    private EditBox mOffsetZInput;
    private ImageButton mSwitchURL;
    private ImageButton mSwitchID;
    private ImageButton mSwitchContainer;
    private ImageButton mButtonExport;
    private ImageButton mSwitchSingleSided;
    private ImageButton mSwitchDoubleSided;
    private SourceType mSourceType;
    private boolean mDoubleSided;
    private int mImageColor = -1;
    private Vec2 mImageSize = Vec2.f_82463_;
    private Vector3f mImageOffset = new Vector3f();
    private ProjectorBlock.InternalRotation mRotation = ProjectorBlock.InternalRotation.NONE;
    private boolean mInvalidURL = true;
    private boolean mInvalidColor = true;
    private boolean mInvalidWidth = true;
    private boolean mInvalidHeight = true;
    private boolean mInvalidOffsetX = true;
    private boolean mInvalidOffsetY = true;
    private boolean mInvalidOffsetZ = true;
    private final ProjectorBlockEntity mEntity;
    private final int imageWidth;
    private final int imageHeight;

    public ProjectorScreen(ProjectorScreenHandler handler, Inventory inventory, Component title) {
        super((AbstractContainerMenu)handler, inventory, title);
        BlockEntity blockEntity = Minecraft.m_91087_().f_91073_.m_7702_(handler.getPos());
        this.mEntity = blockEntity instanceof ProjectorBlockEntity ? (ProjectorBlockEntity)blockEntity : null;
        this.imageWidth = 176;
        this.imageHeight = 217;
    }

    protected void m_7856_() {
        super.m_7856_();
        if (this.mEntity == null) {
            return;
        }
        this.mSourceType = this.mEntity.mSourceType;
        this.f_96541_.f_91068_.m_90926_(true);
        int leftPos = (this.f_96543_ - this.imageWidth) / 2;
        int topPos = (this.f_96544_ - this.imageHeight) / 2;
        this.mURLInput = new EditBox(this.f_96547_, leftPos + 30, topPos + 29, 137, 16, (Component)Text.translatable("gui.slide_show.url", new Object[0]));
        this.mURLInput.m_94199_(512);
        this.mURLInput.m_94151_(text -> {
            if (StringUtils.isNotBlank((CharSequence)text)) {
                this.mInvalidURL = switch (this.mSourceType) {
                    case SourceType.URL -> {
                        if (SlideState.createURI(text) == null) {
                            yield true;
                        }
                        yield false;
                    }
                    case SourceType.ResourceID -> {
                        if (ResourceLocation.m_135820_((String)text) == null) {
                            yield true;
                        }
                        yield false;
                    }
                    default -> false;
                };
            } else {
                this.mInvalidURL = false;
            }
            this.mURLInput.m_94202_(this.mInvalidURL ? 14699339 : 0xE0E0E0);
        });
        this.mURLInput.m_94144_(this.mEntity.mLocation);
        this.m_142416_((GuiEventListener)this.mURLInput);
        this.m_94718_((GuiEventListener)this.mURLInput);
        this.mColorInput = new EditBox(this.f_96547_, leftPos + 55, topPos + 155, 56, 16, (Component)Text.translatable("gui.slide_show.color", new Object[0]));
        this.mColorInput.m_94199_(8);
        this.mColorInput.m_94151_(text -> {
            try {
                this.mImageColor = Integer.parseUnsignedInt(text, 16);
                this.mInvalidColor = false;
            }
            catch (Exception e) {
                this.mInvalidColor = true;
            }
            this.mColorInput.m_94202_(this.mInvalidColor ? 14699339 : 0xE0E0E0);
        });
        this.mColorInput.m_94144_(String.format("%08X", this.mEntity.mColor));
        this.m_142416_((GuiEventListener)this.mColorInput);
        this.mWidthInput = new EditBox(this.f_96547_, leftPos + 30, topPos + 51, 56, 16, (Component)Text.translatable("gui.slide_show.width", new Object[0]));
        this.mWidthInput.m_94151_(text -> {
            try {
                Vec2 newSize = new Vec2(ProjectorScreen.parseFloat(text), this.mImageSize.f_82471_);
                this.updateSize(newSize);
                this.mInvalidWidth = false;
            }
            catch (Exception e) {
                this.mInvalidWidth = true;
            }
            this.mWidthInput.m_94202_(this.mInvalidWidth ? 14699339 : 0xE0E0E0);
        });
        this.mWidthInput.m_94144_(ProjectorScreen.floatToString(this.mEntity.mWidth));
        this.m_142416_((GuiEventListener)this.mWidthInput);
        this.mHeightInput = new EditBox(this.f_96547_, leftPos + 111, topPos + 51, 56, 16, (Component)Text.translatable("gui.slide_show.height", new Object[0]));
        this.mHeightInput.m_94151_(input -> {
            try {
                Vec2 newSize = new Vec2(this.mImageSize.f_82470_, ProjectorScreen.parseFloat(input));
                this.updateSize(newSize);
                this.mInvalidHeight = false;
            }
            catch (Exception e) {
                this.mInvalidHeight = true;
            }
            this.mHeightInput.m_94202_(this.mInvalidHeight ? 14699339 : 0xE0E0E0);
        });
        this.mHeightInput.m_94144_(ProjectorScreen.floatToString(this.mEntity.mHeight));
        this.m_142416_((GuiEventListener)this.mHeightInput);
        this.mOffsetXInput = new EditBox(this.f_96547_, leftPos + 30, topPos + 103, 29, 16, (Component)Text.translatable("gui.slide_show.offset_x", new Object[0]));
        this.mOffsetXInput.m_94151_(input -> {
            try {
                this.mImageOffset = new Vector3f(ProjectorScreen.parseFloat(input), this.mImageOffset.m_122260_(), this.mImageOffset.m_122269_());
                this.mInvalidOffsetX = false;
            }
            catch (Exception e) {
                this.mInvalidOffsetX = true;
            }
            this.mOffsetXInput.m_94202_(this.mInvalidOffsetX ? 14699339 : 0xE0E0E0);
        });
        this.mOffsetXInput.m_94144_(ProjectorScreen.floatToString(this.mEntity.mOffsetX));
        this.m_142416_((GuiEventListener)this.mOffsetXInput);
        this.mOffsetYInput = new EditBox(this.f_96547_, leftPos + 84, topPos + 103, 29, 16, (Component)Text.translatable("gui.slide_show.offset_y", new Object[0]));
        this.mOffsetYInput.m_94151_(input -> {
            try {
                this.mImageOffset = new Vector3f(this.mImageOffset.m_122239_(), ProjectorScreen.parseFloat(input), this.mImageOffset.m_122269_());
                this.mInvalidOffsetY = false;
            }
            catch (Exception e) {
                this.mInvalidOffsetY = true;
            }
            this.mOffsetYInput.m_94202_(this.mInvalidOffsetY ? 14699339 : 0xE0E0E0);
        });
        this.mOffsetYInput.m_94144_(ProjectorScreen.floatToString(this.mEntity.mOffsetY));
        this.m_142416_((GuiEventListener)this.mOffsetYInput);
        this.mOffsetZInput = new EditBox(this.f_96547_, leftPos + 138, topPos + 103, 29, 16, (Component)Text.translatable("gui.slide_show.offset_z", new Object[0]));
        this.mOffsetZInput.m_94151_(input -> {
            try {
                this.mImageOffset = new Vector3f(this.mImageOffset.m_122239_(), this.mImageOffset.m_122260_(), ProjectorScreen.parseFloat(input));
                this.mInvalidOffsetZ = false;
            }
            catch (Exception e) {
                this.mInvalidOffsetZ = true;
            }
            this.mOffsetZInput.m_94202_(this.mInvalidOffsetZ ? 14699339 : 0xE0E0E0);
        });
        this.mOffsetZInput.m_94144_(ProjectorScreen.floatToString(this.mEntity.mOffsetZ));
        this.m_142416_((GuiEventListener)this.mOffsetZInput);
        this.m_142416_((GuiEventListener)new ImageButton(leftPos + 117, topPos + 153, 18, 19, 179, 153, 0, GUI_TEXTURE, button -> {
            ProjectorBlock.InternalRotation newRotation = this.mRotation.flip();
            this.updateRotation(newRotation);
        }));
        this.m_142416_((GuiEventListener)new ImageButton(leftPos + 142, topPos + 153, 18, 19, 179, 173, 0, GUI_TEXTURE, button -> {
            ProjectorBlock.InternalRotation newRotation = this.mRotation.compose(Rotation.CLOCKWISE_90);
            this.updateRotation(newRotation);
        }));
        this.mRotation = (ProjectorBlock.InternalRotation)((Object)this.mEntity.m_58900_().m_61143_(ProjectorBlock.ROTATION));
        this.mSwitchURL = new ImageButton(leftPos + 9, topPos + 27, 18, 19, 179, 53, 0, GUI_TEXTURE, button -> {
            this.mSourceType = SourceType.ResourceID;
            this.mSwitchID.f_93624_ = true;
            this.mSwitchURL.f_93624_ = false;
        });
        this.mSwitchID = new ImageButton(leftPos + 9, topPos + 27, 18, 19, 179, 73, 0, GUI_TEXTURE, button -> {
            this.mSourceType = SourceType.ContainerBlock;
            this.mSwitchContainer.f_93624_ = true;
            this.mSwitchID.f_93624_ = false;
            this.mButtonExport.f_93624_ = false;
        });
        this.mSwitchContainer = new ImageButton(leftPos + 9, topPos + 27, 18, 19, 179, 93, 0, GUI_TEXTURE, button -> {
            this.mSourceType = SourceType.URL;
            this.mSwitchURL.f_93624_ = true;
            this.mSwitchContainer.f_93624_ = false;
            this.mButtonExport.f_93624_ = true;
        });
        this.mButtonExport = new ImageButton(leftPos + 149, topPos + 7, 18, 19, 179, 33, 0, GUI_TEXTURE, button -> this.sendExport());
        this.mSwitchSingleSided = new ImageButton(leftPos + 9, topPos + 153, 18, 19, 179, 113, 0, GUI_TEXTURE, button -> {
            this.mDoubleSided = false;
            this.mSwitchDoubleSided.f_93624_ = true;
            this.mSwitchSingleSided.f_93624_ = false;
        });
        this.mSwitchDoubleSided = new ImageButton(leftPos + 9, topPos + 153, 18, 19, 179, 133, 0, GUI_TEXTURE, button -> {
            this.mDoubleSided = true;
            this.mSwitchSingleSided.f_93624_ = true;
            this.mSwitchDoubleSided.f_93624_ = false;
        });
        this.mSwitchURL.f_93624_ = this.mSourceType == SourceType.URL;
        this.mSwitchID.f_93624_ = this.mSourceType == SourceType.ResourceID;
        this.mSwitchContainer.f_93624_ = this.mSourceType == SourceType.ContainerBlock;
        this.mButtonExport.f_93624_ = this.mSourceType != SourceType.ContainerBlock;
        this.mSwitchDoubleSided.f_93624_ = this.mDoubleSided = this.mEntity.mDoubleSided;
        this.mSwitchSingleSided.f_93624_ = !this.mDoubleSided;
        this.m_142416_((GuiEventListener)this.mSwitchURL);
        this.m_142416_((GuiEventListener)this.mSwitchID);
        this.m_142416_((GuiEventListener)this.mSwitchContainer);
        this.m_142416_((GuiEventListener)this.mButtonExport);
        this.m_142416_((GuiEventListener)this.mSwitchSingleSided);
        this.m_142416_((GuiEventListener)this.mSwitchDoubleSided);
    }

    private void updateRotation(ProjectorBlock.InternalRotation newRotation) {
        if (!(this.mInvalidOffsetX || this.mInvalidOffsetY || this.mInvalidOffsetZ)) {
            Vector3f absolute = ProjectorScreen.relativeToAbsolute(this.mImageOffset, this.mImageSize, this.mRotation);
            Vector3f newRelative = ProjectorScreen.absoluteToRelative(absolute, this.mImageSize, newRotation);
            this.mOffsetXInput.m_94144_(ProjectorScreen.floatToString(newRelative.m_122239_()));
            this.mOffsetYInput.m_94144_(ProjectorScreen.floatToString(newRelative.m_122260_()));
            this.mOffsetZInput.m_94144_(ProjectorScreen.floatToString(newRelative.m_122269_()));
        }
        this.mRotation = newRotation;
    }

    private void updateSize(Vec2 newSize) {
        if (!(this.mInvalidOffsetX || this.mInvalidOffsetY || this.mInvalidOffsetZ)) {
            Vector3f absolute = ProjectorScreen.relativeToAbsolute(this.mImageOffset, this.mImageSize, this.mRotation);
            Vector3f newRelative = ProjectorScreen.absoluteToRelative(absolute, newSize, this.mRotation);
            this.mOffsetXInput.m_94144_(ProjectorScreen.floatToString(newRelative.m_122239_()));
            this.mOffsetYInput.m_94144_(ProjectorScreen.floatToString(newRelative.m_122260_()));
            this.mOffsetZInput.m_94144_(ProjectorScreen.floatToString(newRelative.m_122269_()));
        }
        this.mImageSize = newSize;
    }

    public void m_181908_() {
        if (this.mEntity == null) {
            this.f_96541_.f_91074_.m_6915_();
            return;
        }
        this.mURLInput.m_94120_();
        this.mColorInput.m_94120_();
        this.mWidthInput.m_94120_();
        this.mHeightInput.m_94120_();
        this.mOffsetXInput.m_94120_();
        this.mOffsetYInput.m_94120_();
        this.mOffsetZInput.m_94120_();
    }

    private void sendExport() {
        if (this.mSourceType == SourceType.ContainerBlock) {
            return;
        }
        Network.CHANNEL.sendToServer((Object)new ProjectorExportC2SPacket(this.mSourceType == SourceType.ResourceID, this.mURLInput.m_94155_()));
    }

    public void m_7861_() {
        boolean invalidOffset;
        super.m_7861_();
        this.f_96541_.f_91068_.m_90926_(false);
        if (this.mEntity == null) {
            return;
        }
        boolean invalidSize = this.mInvalidWidth || this.mInvalidHeight;
        boolean bl = invalidOffset = this.mInvalidOffsetX || this.mInvalidOffsetY || this.mInvalidOffsetZ;
        if (!this.mInvalidURL) {
            this.mEntity.mLocation = this.mURLInput.m_94155_();
        }
        if (!this.mInvalidColor) {
            this.mEntity.mColor = this.mImageColor;
        }
        if (!invalidSize) {
            this.mEntity.mWidth = this.mImageSize.f_82470_;
            this.mEntity.mHeight = this.mImageSize.f_82471_;
        }
        if (!invalidOffset) {
            this.mEntity.mOffsetX = this.mImageOffset.m_122239_();
            this.mEntity.mOffsetY = this.mImageOffset.m_122260_();
            this.mEntity.mOffsetZ = this.mImageOffset.m_122269_();
        }
        this.mEntity.needInitContainer = this.mEntity.mSourceType == this.mSourceType;
        this.mEntity.mSourceType = this.mSourceType;
        this.mEntity.mDoubleSided = this.mDoubleSided;
        Network.CHANNEL.sendToServer((Object)new ProjectorAfterUpdateC2SPacket(this.mEntity, this.mRotation));
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifier) {
        if (keyCode == 256) {
            this.f_96541_.f_91074_.m_6915_();
            return true;
        }
        return this.mURLInput.m_7933_(keyCode, scanCode, modifier) || this.mURLInput.m_94204_() || this.mColorInput.m_7933_(keyCode, scanCode, modifier) || this.mColorInput.m_94204_() || this.mWidthInput.m_7933_(keyCode, scanCode, modifier) || this.mWidthInput.m_94204_() || this.mHeightInput.m_7933_(keyCode, scanCode, modifier) || this.mHeightInput.m_94204_() || this.mOffsetXInput.m_7933_(keyCode, scanCode, modifier) || this.mOffsetXInput.m_94204_() || this.mOffsetYInput.m_7933_(keyCode, scanCode, modifier) || this.mOffsetYInput.m_94204_() || this.mOffsetZInput.m_7933_(keyCode, scanCode, modifier) || this.mOffsetZInput.m_94204_() || super.m_7933_(keyCode, scanCode, modifier);
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        this.m_7333_(matrices);
        super.m_6305_(matrices, mouseX, mouseY, delta);
    }

    protected void m_7286_(PoseStack matrixStack, float f, int i, int j) {
        this.m_7333_(matrixStack);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)GUI_TEXTURE);
        this.m_93228_(matrixStack, (this.f_96543_ - this.imageWidth) / 2, (this.f_96544_ - this.imageHeight) / 2, 0, 0, this.imageWidth, this.imageHeight);
    }

    protected void m_7027_(PoseStack matrixStack, int mouseX, int mouseY) {
        if (this.mEntity == null) {
            return;
        }
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)GUI_TEXTURE);
        int alpha = this.mImageColor >>> 24;
        if (alpha > 0) {
            int red = this.mImageColor >> 16 & 0xFF;
            int green = this.mImageColor >> 8 & 0xFF;
            int blue = this.mImageColor & 0xFF;
            RenderUtils.setShaderColor((float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f, (float)alpha / 255.0f);
            this.m_93228_(matrixStack, 38, 131, 180, 194, 10, 10);
            this.m_93228_(matrixStack, 82, 159, 180, 194, 17, 17);
        }
        RenderUtils.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
        this.m_93228_(matrixStack, 82, 159, 202, 194 - this.mRotation.ordinal() * 20, 17, 17);
        ProjectorScreen.drawCenteredStringWithoutShadow(matrixStack, this.f_96547_, IMAGE_TEXT, (float)this.imageWidth / 2.0f, -14.0f);
        ProjectorScreen.drawCenteredStringWithoutShadow(matrixStack, this.f_96547_, OFFSET_TEXT, (float)this.imageWidth / 2.0f, 60.0f);
        ProjectorScreen.drawCenteredStringWithoutShadow(matrixStack, this.f_96547_, OTHERS_TEXT, (float)this.imageWidth / 2.0f, 112.0f);
        int offsetX = mouseX - (this.f_96543_ - this.imageWidth) / 2;
        int offsetY = mouseY - (this.f_96544_ - this.imageHeight) / 2;
        if (offsetX >= 9 && offsetY >= 27 && offsetX < 27 && offsetY < 46) {
            this.m_96602_(matrixStack, switch (this.mSourceType) {
                case SourceType.ResourceID -> ID_TEXT;
                case SourceType.ContainerBlock -> CONTAINER_TEXT;
                default -> URL_TEXT;
            }, offsetX, offsetY);
        } else if (offsetX >= 149 && offsetY >= 7 && offsetX < 167 && offsetY < 26) {
            if (this.mSourceType != SourceType.ContainerBlock) {
                this.m_96602_(matrixStack, EXPORT_TEXT, offsetX, offsetY);
            }
        } else if (offsetX >= 34 && offsetY >= 153 && offsetX < 52 && offsetY < 172) {
            this.m_96602_(matrixStack, COLOR_TEXT, offsetX, offsetY);
        } else if (offsetX >= 9 && offsetY >= 49 && offsetX < 27 && offsetY < 68) {
            this.m_96602_(matrixStack, WIDTH_TEXT, offsetX, offsetY);
        } else if (offsetX >= 90 && offsetY >= 49 && offsetX < 108 && offsetY < 68) {
            this.m_96602_(matrixStack, HEIGHT_TEXT, offsetX, offsetY);
        } else if (offsetX >= 9 && offsetY >= 101 && offsetX < 27 && offsetY < 120) {
            this.m_96602_(matrixStack, OFFSET_X_TEXT, offsetX, offsetY);
        } else if (offsetX >= 63 && offsetY >= 101 && offsetX < 81 && offsetY < 120) {
            this.m_96602_(matrixStack, OFFSET_Y_TEXT, offsetX, offsetY);
        } else if (offsetX >= 117 && offsetY >= 101 && offsetX < 135 && offsetY < 120) {
            this.m_96602_(matrixStack, OFFSET_Z_TEXT, offsetX, offsetY);
        } else if (offsetX >= 117 && offsetY >= 153 && offsetX < 135 && offsetY < 172) {
            this.m_96602_(matrixStack, FLIP_TEXT, offsetX, offsetY);
        } else if (offsetX >= 142 && offsetY >= 153 && offsetX < 160 && offsetY < 172) {
            this.m_96602_(matrixStack, ROTATE_TEXT, offsetX, offsetY);
        } else if (offsetX >= 9 && offsetY >= 153 && offsetX < 27 && offsetY < 172) {
            this.m_96602_(matrixStack, SINGLE_DOUBLE_SIDED_TEXT, offsetX, offsetY);
        }
    }

    private static void drawCenteredStringWithoutShadow(PoseStack stack, Font renderer, Component string, float x, float y) {
        renderer.m_92889_(stack, string, x - (float)renderer.m_92852_((FormattedText)string) / 2.0f, y, 0x404040);
    }

    private static float parseFloat(String text) {
        return (float)Math.round(Float.parseFloat(text) * 10000.0f) / 10000.0f;
    }

    private static String floatToString(float value) {
        return String.valueOf((float)Math.round(value * 10000.0f) / 10000.0f);
    }

    private static Vector3f relativeToAbsolute(Vector3f relatedOffset, Vec2 size, ProjectorBlock.InternalRotation rotation) {
        Vector4f center = new Vector4f(0.5f * size.f_82470_, 0.0f, 0.5f * size.f_82471_, 1.0f);
        center.m_123607_(Matrix4f.m_27653_((float)relatedOffset.m_122239_(), (float)(-relatedOffset.m_122269_()), (float)relatedOffset.m_122260_()));
        center.m_123607_(Matrix4f.m_27653_((float)-0.5f, (float)0.0f, (float)(0.5f - size.f_82471_)));
        rotation.transform(center);
        return new Vector3f(center.m_123601_(), center.m_123615_(), center.m_123616_());
    }

    private static Vector3f absoluteToRelative(Vector3f absoluteOffset, Vec2 size, ProjectorBlock.InternalRotation rotation) {
        Vector4f center = new Vector4f(absoluteOffset);
        rotation.invert().transform(center);
        center.m_123607_(Matrix4f.m_27653_((float)0.5f, (float)0.0f, (float)(-0.5f + size.f_82471_)));
        center.m_123607_(Matrix4f.m_27653_((float)(-0.5f * size.f_82470_), (float)0.0f, (float)(-0.5f * size.f_82471_)));
        return new Vector3f(center.m_123601_(), center.m_123616_(), -center.m_123615_());
    }
}

