/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.slides.texture;

import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletionException;
import javax.annotation.Nonnull;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11C;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.MemoryUtil;
import org.teacon.slides.Slideshow;
import org.teacon.slides.renderer.SlideRenderType;
import org.teacon.slides.texture.GIFDecoder;
import org.teacon.slides.texture.LZWDecoder;
import org.teacon.slides.texture.TextureProvider;

public final class AnimatedTextureProvider
implements TextureProvider {
    private static final LZWDecoder gRenderThreadDecoder = new LZWDecoder();
    private static float sMaxAnisotropic = -1.0f;
    private final GIFDecoder mDecoder;
    private int mTexture;
    private final SlideRenderType mRenderType;
    private long mFrameStartTime;
    private long mFrameDelayTime;

    public AnimatedTextureProvider(byte[] data) {
        if (sMaxAnisotropic < 0.0f) {
            GLCapabilities caps = GL.getCapabilities();
            if (caps.OpenGL46 || caps.GL_ARB_texture_filter_anisotropic || caps.GL_EXT_texture_filter_anisotropic) {
                sMaxAnisotropic = Math.max(1.0f, GL11C.glGetFloat((int)34047));
                Slideshow.LOGGER.info("Max anisotropic: {}", (Object)Float.valueOf(sMaxAnisotropic));
            } else {
                sMaxAnisotropic = 0.0f;
            }
        }
        ByteBuffer buffer = null;
        try {
            this.mDecoder = new GIFDecoder(data, gRenderThreadDecoder, false);
            int width = this.mDecoder.getScreenWidth();
            int height = this.mDecoder.getScreenHeight();
            buffer = MemoryUtil.memAlloc((int)(width * height * 4));
            this.mFrameDelayTime = this.mDecoder.decodeNextFrame(buffer);
            this.mTexture = GL11C.glGenTextures();
            RenderSystem.m_69396_((int)this.mTexture);
            GL11C.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL11C.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11C.glTexParameteri((int)3553, (int)10242, (int)33071);
            GL11C.glTexParameteri((int)3553, (int)10243, (int)33071);
            if (sMaxAnisotropic > 0.0f) {
                GL11C.glTexParameterf((int)3553, (int)34046, (float)sMaxAnisotropic);
            }
            GL11C.glPixelStorei((int)3314, (int)0);
            GL11C.glPixelStorei((int)3316, (int)0);
            GL11C.glPixelStorei((int)3315, (int)0);
            GL11C.glPixelStorei((int)3317, (int)1);
            GL11C.glTexImage2D((int)3553, (int)0, (int)32856, (int)width, (int)height, (int)0, (int)6408, (int)5121, (ByteBuffer)buffer);
            this.mRenderType = new SlideRenderType(this.mTexture);
        }
        catch (Throwable t) {
            try {
                this.close();
                throw new CompletionException(t);
            }
            catch (Throwable throwable) {
                MemoryUtil.memFree(buffer);
                throw throwable;
            }
        }
        MemoryUtil.memFree((Buffer)buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public SlideRenderType updateAndGet(long tick, float partialTick) {
        long timeMillis = (long)(((float)tick + partialTick) * 50.0f);
        if (this.mFrameStartTime == 0L) {
            this.mFrameStartTime = timeMillis;
        } else if (this.mFrameStartTime + this.mFrameDelayTime <= timeMillis) {
            ByteBuffer buffer = null;
            try {
                int width = this.getWidth();
                int height = this.getHeight();
                buffer = MemoryUtil.memAlloc((int)(width * height * 4));
                this.mFrameDelayTime = this.mDecoder.decodeNextFrame(buffer);
                RenderSystem.m_69396_((int)this.mTexture);
                GL11C.glPixelStorei((int)3314, (int)0);
                GL11C.glPixelStorei((int)3316, (int)0);
                GL11C.glPixelStorei((int)3315, (int)0);
                GL11C.glPixelStorei((int)3317, (int)1);
                GL11C.glTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)width, (int)height, (int)6408, (int)5121, (ByteBuffer)buffer);
                MemoryUtil.memFree((Buffer)buffer);
            }
            catch (IOException e) {
                this.mFrameDelayTime = Integer.MAX_VALUE;
            }
            finally {
                MemoryUtil.memFree(buffer);
            }
            this.mFrameStartTime = timeMillis;
        }
        return this.mRenderType;
    }

    @Override
    public int getWidth() {
        return this.mDecoder.getScreenWidth();
    }

    @Override
    public int getHeight() {
        return this.mDecoder.getScreenHeight();
    }

    @Override
    public void close() {
        if (this.mTexture != 0) {
            RenderSystem.m_69454_((int)this.mTexture);
        }
        this.mTexture = 0;
    }
}

