/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.slides.cache;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import com.google.common.hash.Hashing;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.ref.ReferenceQueue;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import net.minecraft.Util;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.Header;
import org.apache.http.StatusLine;
import org.apache.http.client.utils.DateUtils;
import org.apache.http.message.BasicLineParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.jetbrains.annotations.Nullable;
import org.teacon.slides.Slideshow;
import org.teacon.slides.cache.LegacyStorage;
import org.teacon.slides.cache.ResourceReference;
import org.teacon.slides.http.client.cache.HttpCacheEntry;
import org.teacon.slides.http.client.cache.HttpCacheStorage;
import org.teacon.slides.http.client.cache.HttpCacheUpdateCallback;
import org.teacon.slides.http.client.cache.Resource;
import org.teacon.slides.http.impl.client.cache.FileResource;

final class CacheStorage
implements HttpCacheStorage {
    private static final Logger LOGGER = LogManager.getLogger(Slideshow.class);
    private static final Marker MARKER = MarkerManager.getMarker((String)"Downloader");
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
    private final Object keyLock;
    private final Path parentPath;
    private final Path keyFilePath;
    private final AtomicInteger markedDirty = new AtomicInteger();
    private final Map<String, Pair<Path, HttpCacheEntry>> entries = new LinkedHashMap<String, Pair<Path, HttpCacheEntry>>();
    private final ReferenceQueue<HttpCacheEntry> referenceQueue;
    private final Set<ResourceReference> resourceReferenceHolder;

    private static Pair<Path, HttpCacheEntry> normalize(Path parentPath, HttpCacheEntry entry) throws IOException {
        byte[] bytes = IOUtils.toByteArray((InputStream)entry.getResource().getInputStream());
        Path tmp = Files.write(Files.createTempFile("slideshow-", ".tmp", new FileAttribute[0]), bytes, new OpenOption[0]);
        Path path = Files.move(tmp, parentPath.resolve(CacheStorage.allocateImageName(bytes)), StandardCopyOption.REPLACE_EXISTING);
        return Pair.of((Object)path, (Object)new HttpCacheEntry(entry.getRequestDate(), entry.getResponseDate(), entry.getStatusLine(), entry.getAllHeaders(), (Resource)new FileResource(path.toFile()), entry.getVariantMap()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String allocateImageName(byte[] bytes) {
        String hashString = Hashing.sha1().hashBytes(bytes).toString();
        try (ByteArrayInputStream stream = new ByteArrayInputStream(bytes);){
            try (ImageInputStream imageStream = ImageIO.createImageInputStream(stream);){
                String[] suffixes;
                Iterator<ImageReader> readers = ImageIO.getImageReaders(imageStream);
                if (readers.hasNext() && (suffixes = readers.next().getOriginatingProvider().getFileSuffixes()).length > 0) {
                    String string = hashString + "." + suffixes[0].toLowerCase(Locale.ENGLISH);
                    return string;
                }
            }
            String string = hashString;
            return string;
        }
        catch (IOException e) {
            return hashString;
        }
    }

    private static void saveJson(Map<String, Pair<Path, HttpCacheEntry>> entries, JsonObject root) {
        for (Map.Entry<String, Pair<Path, HttpCacheEntry>> entry : entries.entrySet()) {
            Path filePath = (Path)entry.getValue().getKey();
            HttpCacheEntry cacheEntry = (HttpCacheEntry)entry.getValue().getValue();
            root.add(entry.getKey(), (JsonElement)Util.make((Object)new JsonObject(), child -> {
                child.addProperty("request_date", DateUtils.formatDate((Date)cacheEntry.getRequestDate()));
                child.addProperty("response_date", DateUtils.formatDate((Date)cacheEntry.getResponseDate()));
                child.addProperty("status_line", cacheEntry.getStatusLine().toString());
                child.add("headers", (JsonElement)Util.make((Object)new JsonArray(), array -> {
                    for (Header header : cacheEntry.getAllHeaders()) {
                        array.add(header.toString());
                    }
                }));
                child.addProperty("resource", filePath.toString());
                child.add("variant_map", (JsonElement)Util.make((Object)new JsonObject(), object -> {
                    for (Map.Entry<String, String> variantEntry : cacheEntry.getVariantMap().entrySet()) {
                        object.addProperty(variantEntry.getKey(), variantEntry.getValue());
                    }
                }));
            }));
        }
    }

    private static void loadJson(Map<String, Pair<Path, HttpCacheEntry>> entries, JsonObject root) {
        for (Map.Entry entry : root.entrySet()) {
            JsonObject child = ((JsonElement)entry.getValue()).getAsJsonObject();
            Date requestDate = DateUtils.parseDate((String)child.get("request_date").getAsString());
            Date responseDate = DateUtils.parseDate((String)child.get("response_date").getAsString());
            StatusLine statusLine = BasicLineParser.parseStatusLine((String)child.get("status_line").getAsString(), null);
            Path filePath = Paths.get(child.get("resource").getAsString(), new String[0]);
            Header[] headers = CacheStorage.loadHeaders(child);
            Map<String, String> variantMap = CacheStorage.loadVariantMap(child);
            HttpCacheEntry cacheEntry = new HttpCacheEntry(requestDate, responseDate, statusLine, headers, (Resource)new FileResource(filePath.toFile()), variantMap);
            entries.put((String)entry.getKey(), (Pair<Path, HttpCacheEntry>)Pair.of((Object)filePath, (Object)cacheEntry));
        }
    }

    private static Map<String, String> loadVariantMap(JsonObject child) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        JsonObject map = child.has("variant_map") ? child.get("variant_map").getAsJsonObject() : new JsonObject();
        for (Map.Entry entry : map.entrySet()) {
            builder.put((Object)((String)entry.getKey()), (Object)((JsonElement)entry.getValue()).getAsString());
        }
        return builder.build();
    }

    private static Header[] loadHeaders(JsonObject child) {
        JsonArray list = child.has("headers") ? child.get("headers").getAsJsonArray() : new JsonArray();
        return (Header[])Streams.stream((Iterable)list).map(e -> BasicLineParser.parseHeader((String)e.getAsString(), null)).toArray(Header[]::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save() {
        JsonObject root = new JsonObject();
        Object object = this.entries;
        synchronized (object) {
            CacheStorage.saveJson(this.entries, root);
        }
        object = this.keyLock;
        synchronized (object) {
            try (BufferedWriter writer = Files.newBufferedWriter(this.keyFilePath, StandardCharsets.UTF_8, new OpenOption[0]);){
                GSON.toJson((JsonElement)root, (Appendable)writer);
            }
            catch (Exception e) {
                LOGGER.warn(MARKER, "Failed to save cache storage. ", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        JsonObject root = new JsonObject();
        Map<String, Pair<Path, HttpCacheEntry>> map = this.keyLock;
        synchronized (map) {
            try (BufferedReader reader = Files.newBufferedReader(this.keyFilePath, StandardCharsets.UTF_8);){
                root = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            }
            catch (Exception e) {
                LOGGER.warn(MARKER, "Failed to load cache storage. ", (Throwable)e);
            }
        }
        map = this.entries;
        synchronized (map) {
            CacheStorage.loadJson(this.entries, root);
        }
    }

    private void scheduleSave() {
        if (this.markedDirty.getAndIncrement() == 0) {
            Executor executor = CompletableFuture.delayedExecutor(5L, TimeUnit.SECONDS, Util.backgroundExecutor());
            CompletableFuture.runAsync(this::save, executor).thenRun(() -> {
                int changes = this.markedDirty.getAndSet(0);
                LOGGER.debug(MARKER, "Attempted to save {} change(s) to cache storage. ", (Object)changes);
            });
        }
    }

    public CacheStorage(Path parentPath) {
        this.keyLock = new Object();
        this.parentPath = parentPath;
        this.keyFilePath = this.parentPath.resolve("storage-keys.json");
        if (Files.exists(this.keyFilePath, new LinkOption[0])) {
            this.load();
        } else if (LegacyStorage.loadLegacy(parentPath, this.entries)) {
            this.save();
        }
        this.referenceQueue = new ReferenceQueue();
        this.resourceReferenceHolder = Sets.newConcurrentHashSet();
    }

    private void keepResourceReference(HttpCacheEntry entry) {
        Resource resource = entry.getResource();
        if (resource != null) {
            ResourceReference ref = new ResourceReference(entry, this.referenceQueue);
            this.resourceReferenceHolder.add(ref);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public HttpCacheEntry getEntry(String url) {
        Map<String, Pair<Path, HttpCacheEntry>> map = this.entries;
        synchronized (map) {
            Pair<Path, HttpCacheEntry> pair = this.entries.get(url);
            return pair != null ? (HttpCacheEntry)pair.getValue() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putEntry(String url, HttpCacheEntry entry) throws IOException {
        Map<String, Pair<Path, HttpCacheEntry>> map = this.entries;
        synchronized (map) {
            Pair<Path, HttpCacheEntry> normalizedEntry = CacheStorage.normalize(this.parentPath, entry);
            this.entries.put(url, normalizedEntry);
            this.keepResourceReference(entry);
        }
        this.scheduleSave();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeEntry(String url) {
        Map<String, Pair<Path, HttpCacheEntry>> map = this.entries;
        synchronized (map) {
            this.entries.remove(url);
        }
        this.scheduleSave();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateEntry(String url, HttpCacheUpdateCallback cb) throws IOException {
        Map<String, Pair<Path, HttpCacheEntry>> map = this.entries;
        synchronized (map) {
            Pair<Path, HttpCacheEntry> pair = this.entries.get(url);
            this.entries.put(url, CacheStorage.normalize(this.parentPath, cb.update(pair != null ? (HttpCacheEntry)pair.getValue() : null)));
            HttpCacheEntry existing = (HttpCacheEntry)this.entries.get(url).getValue();
            HttpCacheEntry updated = cb.update(existing);
            if (existing != updated) {
                this.keepResourceReference(updated);
            }
        }
        this.scheduleSave();
    }

    public int cleanResources() {
        ResourceReference ref;
        int prevCount = this.resourceReferenceHolder.size();
        while ((ref = (ResourceReference)this.referenceQueue.poll()) != null) {
            this.resourceReferenceHolder.remove(ref);
            ref.getResource().dispose();
        }
        return prevCount - this.resourceReferenceHolder.size();
    }
}

