/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.slides.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.teacon.slides.command.ProjectorCommand;
import org.teacon.slides.projector.ProjectorBlockEntity;
import org.teacon.slides.projector.SourceType;

public class ImageinfoCommand {
    private static final Component IMAGE_INFO_CHANGED = Component.translatable((String)"chat.slide_show.image_info_changed");

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"imageinfo").requires(source -> source.hasPermission(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).then(((LiteralArgumentBuilder)Commands.literal((String)"id").executes(context -> ImageinfoCommand.execute((CommandSourceStack)context.getSource(), BlockPosArgument.getSpawnablePos((CommandContext)context, (String)"pos"), SourceType.ResourceID, null))).then(Commands.argument((String)"location", (ArgumentType)StringArgumentType.string()).executes(context -> ImageinfoCommand.execute((CommandSourceStack)context.getSource(), BlockPosArgument.getSpawnablePos((CommandContext)context, (String)"pos"), SourceType.ResourceID, StringArgumentType.getString((CommandContext)context, (String)"location")))))).then(((LiteralArgumentBuilder)Commands.literal((String)"url").executes(context -> ImageinfoCommand.execute((CommandSourceStack)context.getSource(), BlockPosArgument.getSpawnablePos((CommandContext)context, (String)"pos"), SourceType.URL, null))).then(Commands.argument((String)"location", (ArgumentType)StringArgumentType.string()).executes(context -> ImageinfoCommand.execute((CommandSourceStack)context.getSource(), BlockPosArgument.getSpawnablePos((CommandContext)context, (String)"pos"), SourceType.URL, StringArgumentType.getString((CommandContext)context, (String)"location")))))).then(((LiteralArgumentBuilder)Commands.literal((String)"container").executes(context -> ImageinfoCommand.execute((CommandSourceStack)context.getSource(), BlockPosArgument.getSpawnablePos((CommandContext)context, (String)"pos"), SourceType.ContainerBlock, null))).then(Commands.argument((String)"location", (ArgumentType)StringArgumentType.string()).executes(context -> ImageinfoCommand.execute((CommandSourceStack)context.getSource(), BlockPosArgument.getSpawnablePos((CommandContext)context, (String)"pos"), SourceType.ContainerBlock, StringArgumentType.getString((CommandContext)context, (String)"location")))))).then(Commands.argument((String)"location", (ArgumentType)StringArgumentType.string()).executes(context -> ImageinfoCommand.execute((CommandSourceStack)context.getSource(), BlockPosArgument.getSpawnablePos((CommandContext)context, (String)"pos"), null, StringArgumentType.getString((CommandContext)context, (String)"location"))))));
    }

    private static int execute(CommandSourceStack source, BlockPos blockPos, @Nullable SourceType sourceType, @Nullable String location) {
        ServerLevel world = source.getLevel();
        if (!world.isLoaded(blockPos)) {
            return 0;
        }
        BlockEntity blockEntity = world.getBlockEntity(blockPos);
        if (blockEntity instanceof ProjectorBlockEntity) {
            ProjectorBlockEntity projectorBlockEntity = (ProjectorBlockEntity)blockEntity;
            if (sourceType == null && location == null) {
                return 0;
            }
            if (sourceType != null) {
                projectorBlockEntity.mSourceType = sourceType;
            }
            if (location != null) {
                projectorBlockEntity.mLocation = location;
            }
            projectorBlockEntity.setChanged();
            BlockState state = projectorBlockEntity.getBlockState();
            world.sendBlockUpdated(blockPos, state, state, 3);
            source.sendSystemMessage(IMAGE_INFO_CHANGED);
            return 1;
        }
        source.sendFailure(ProjectorCommand.NO_PROJECTOR);
        return 0;
    }
}

