/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.slides.projector;

import com.mojang.serialization.MapCodec;
import java.util.Arrays;
import java.util.Locale;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;
import org.teacon.slides.Slideshow;
import org.teacon.slides.projector.ProjectorBlockEntity;
import org.teacon.slides.projector.ProjectorScreenHandler;

public final class ProjectorBlock
extends BaseEntityBlock {
    public static final EnumProperty<InternalRotation> ROTATION = EnumProperty.create((String)"rotation", InternalRotation.class);
    public static final EnumProperty<Direction> BASE = EnumProperty.create((String)"base", Direction.class, (Predicate)Direction.Plane.VERTICAL);
    private static final VoxelShape SHAPE_WITH_BASE_UP = Block.box((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_WITH_BASE_DOWN = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);

    public ProjectorBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(BASE, (Comparable)Direction.DOWN)).setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.EAST)).setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.FALSE)).setValue(ROTATION, (Comparable)((Object)InternalRotation.NONE)));
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue(BASE)) {
            case Direction.DOWN -> SHAPE_WITH_BASE_DOWN;
            case Direction.UP -> SHAPE_WITH_BASE_UP;
            default -> throw new AssertionError();
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BASE, BlockStateProperties.FACING, BlockStateProperties.POWERED, ROTATION});
    }

    @NotNull
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction facing = context.getNearestLookingDirection().getOpposite();
        Direction horizontalFacing = context.getNearestLookingVerticalDirection().getOpposite();
        Direction base = Arrays.stream(context.getNearestLookingDirections()).filter((Predicate<Direction>)Direction.Plane.VERTICAL).findFirst().orElse(Direction.DOWN);
        InternalRotation rotation = InternalRotation.VALUES[4 + Math.floorMod(facing.getStepY() * horizontalFacing.get2DDataValue(), 4)];
        return (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(BASE, (Comparable)base)).setValue((Property)BlockStateProperties.FACING, (Comparable)facing)).setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.FALSE)).setValue(ROTATION, (Comparable)((Object)rotation));
    }

    public void neighborChanged(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean powered = worldIn.hasNeighborSignal(pos);
        if (powered != (Boolean)state.getValue((Property)BlockStateProperties.POWERED)) {
            worldIn.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(powered)));
        }
    }

    public void onPlace(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        boolean powered;
        if (!oldState.is(state.getBlock()) && (powered = worldIn.hasNeighborSignal(pos)) != (Boolean)state.getValue((Property)BlockStateProperties.POWERED)) {
            worldIn.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(powered)));
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return world.isClientSide ? null : ProjectorBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)Slideshow.PROJECTOR_BLOCK_ENTITY.get()), (world1, pos, state1, entity) -> ProjectorBlockEntity.tick(world1, pos, entity));
    }

    @NotNull
    public BlockState mirror(BlockState state, Mirror mirror) {
        Direction direction = (Direction)state.getValue((Property)BlockStateProperties.FACING);
        return switch (direction) {
            case Direction.DOWN, Direction.UP -> (BlockState)state.setValue(ROTATION, (Comparable)((Object)((InternalRotation)((Object)state.getValue(ROTATION))).compose(Rotation.CLOCKWISE_180)));
            default -> (BlockState)state.setValue((Property)BlockStateProperties.FACING, (Comparable)mirror.getRotation(direction).rotate(direction));
        };
    }

    @NotNull
    public BlockState rotate(BlockState state, Rotation rotation) {
        Direction direction = (Direction)state.getValue((Property)BlockStateProperties.FACING);
        return switch (direction) {
            case Direction.DOWN, Direction.UP -> (BlockState)state.setValue(ROTATION, (Comparable)((Object)((InternalRotation)((Object)state.getValue(ROTATION))).compose(rotation)));
            default -> (BlockState)state.setValue((Property)BlockStateProperties.FACING, (Comparable)rotation.rotate(direction));
        };
    }

    @NotNull
    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (!world.isClientSide()) {
            if (!ProjectorBlock.hasProjectorPermission((ServerPlayer)player)) {
                return InteractionResult.FAIL;
            }
            if (player.getMainHandItem().is(Slideshow.FLIPPER_ITEM) || player.getOffhandItem().is(Slideshow.FLIPPER_ITEM)) {
                return InteractionResult.PASS;
            }
            MenuProvider factory = this.getMenuProvider(state, world, pos);
            if (!(factory instanceof ProjectorBlockEntity)) {
                return InteractionResult.FAIL;
            }
            ProjectorBlockEntity projectorBlockEntity = (ProjectorBlockEntity)factory;
            ProjectorScreenHandler.openScreen((ServerPlayer)player, projectorBlockEntity);
        }
        return InteractionResult.SUCCESS;
    }

    public static boolean hasProjectorPermission(ServerPlayer serverPlayer) {
        return serverPlayer.canUseGameMasterBlocks();
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return ProjectorBlock.simpleCodec(ProjectorBlock::new);
    }

    public RenderShape getRenderShape(BlockState blockState) {
        return RenderShape.MODEL;
    }

    private static boolean hasPermission(GameType gameType) {
        return gameType == GameType.CREATIVE || gameType == GameType.SURVIVAL;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ProjectorBlockEntity(pos, state);
    }

    public static enum InternalRotation implements StringRepresentable
    {
        NONE(1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f),
        CLOCKWISE_90(0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f),
        CLOCKWISE_180(-1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f),
        COUNTERCLOCKWISE_90(0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f),
        HORIZONTAL_FLIPPED(-1.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f),
        DIAGONAL_FLIPPED(0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f),
        VERTICAL_FLIPPED(1.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f),
        ANTI_DIAGONAL_FLIPPED(0.0f, 0.0f, 1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f);

        public static final InternalRotation[] VALUES;
        private static final int[] INV_INDICES;
        private static final int[] FLIP_INDICES;
        private static final int[][] ROTATION_INDICES;
        private final String mSerializedName;
        private final Matrix4f mMatrix;
        private final Matrix3f mNormal;

        private InternalRotation(float m00, float m10, float m20, float m30, float m01, float m11, float m21, float m31, float m02, float m12, float m22, float m32) {
            this.mMatrix = new Matrix4f(m00, m01, m02, 0.0f, m10, m11, m12, 0.0f, m20, m21, m22, 0.0f, m30, m31, m32, 1.0f);
            this.mNormal = new Matrix3f(m00, m01, m02, m10, m11, m12, m20, m21, m22);
            this.mSerializedName = this.name().toLowerCase(Locale.ROOT);
        }

        public InternalRotation compose(Rotation rotation) {
            return VALUES[ROTATION_INDICES[rotation.ordinal()][this.ordinal()]];
        }

        public InternalRotation flip() {
            return VALUES[FLIP_INDICES[this.ordinal()]];
        }

        public InternalRotation invert() {
            return VALUES[INV_INDICES[this.ordinal()]];
        }

        public boolean isFlipped() {
            return this.ordinal() >= 4;
        }

        public void transform(Vector4f vector) {
            vector.mul((Matrix4fc)this.mMatrix);
        }

        public void transform(Matrix4f poseMatrix) {
            poseMatrix.mul((Matrix4fc)this.mMatrix);
        }

        public void transform(Matrix3f normalMatrix) {
            normalMatrix.mul((Matrix3fc)this.mNormal);
        }

        @NotNull
        public final String getSerializedName() {
            return this.mSerializedName;
        }

        static {
            VALUES = InternalRotation.values();
            INV_INDICES = new int[]{0, 3, 2, 1, 4, 5, 6, 7};
            FLIP_INDICES = new int[]{4, 7, 6, 5, 0, 3, 2, 1};
            ROTATION_INDICES = new int[][]{{0, 1, 2, 3, 4, 5, 6, 7}, {1, 2, 3, 0, 5, 6, 7, 4}, {2, 3, 0, 1, 6, 7, 4, 5}, {3, 0, 1, 2, 7, 4, 5, 6}};
        }
    }
}

