/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.slides.projector;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import org.teacon.slides.Slideshow;
import org.teacon.slides.projector.ProjectorBlockEntity;

public class ProjectorScreenHandler
extends AbstractContainerMenu {
    private final BlockPos pos;

    public ProjectorScreenHandler(int syncId, FriendlyByteBuf packetByteBuf) {
        super((MenuType)Slideshow.PROJECTOR_SCREEN_HANDLER.get(), syncId);
        this.pos = packetByteBuf.readBlockPos();
    }

    public ProjectorScreenHandler(int syncId, Inventory playerInv, FriendlyByteBuf packetByteBuf) {
        super((MenuType)Slideshow.PROJECTOR_SCREEN_HANDLER.get(), syncId);
        this.pos = packetByteBuf.readBlockPos();
    }

    public static void openScreen(ServerPlayer player, ProjectorBlockEntity tile) {
        player.openMenu((MenuProvider)tile, buf -> buf.writeBlockPos(tile.getBlockPos()));
    }

    public static MenuType<ProjectorScreenHandler> create() {
        return IMenuTypeExtension.create(ProjectorScreenHandler::new);
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public ItemStack quickMoveStack(Player player, int slot) {
        return ItemStack.EMPTY;
    }

    public boolean stillValid(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            return switch (serverPlayer.gameMode.getGameModeForPlayer()) {
                case GameType.CREATIVE, GameType.SPECTATOR -> true;
                default -> false;
            };
        }
        return false;
    }
}

