/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.slides.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.teacon.slides.config.Config;
import org.teacon.slides.projector.ProjectorBlock;
import org.teacon.slides.projector.ProjectorBlockEntity;
import org.teacon.slides.projector.SourceType;
import org.teacon.slides.renderer.Slide;
import org.teacon.slides.renderer.SlideState;

public class ProjectorRenderer
implements BlockEntityRenderer<ProjectorBlockEntity> {
    public void render(ProjectorBlockEntity blockEntity, float partialTick, PoseStack matrices, MultiBufferSource source, int packedLight, int packedOverlay) {
        BlockState state = blockEntity.getBlockState();
        Slide slide = SlideState.getSlide(blockEntity.getLocation(), blockEntity.getFromID());
        if (blockEntity.mSourceType == SourceType.ContainerBlock) {
            SlideState.cacheSlide(blockEntity.mCNextLocation, blockEntity.mCNextFromID);
        }
        if (slide == null) {
            return;
        }
        float width = blockEntity.mWidth;
        float height = blockEntity.mHeight;
        int color = blockEntity.mColor;
        boolean isTransparent = (color & 0xFF000000) == 0;
        boolean isPowered = (Boolean)state.getValue((Property)BlockStateProperties.POWERED);
        boolean doubleSided = blockEntity.mDoubleSided;
        if (!isTransparent && !isPowered) {
            matrices.pushPose();
            PoseStack.Pose lastPose = matrices.last();
            Matrix4f pose = new Matrix4f((Matrix4fc)lastPose.pose());
            Matrix3f normal = new Matrix3f((Matrix3fc)lastPose.normal());
            blockEntity.transformToSlideSpace(pose, normal);
            boolean flipped = ((ProjectorBlock.InternalRotation)((Object)state.getValue(ProjectorBlock.ROTATION))).isFlipped();
            slide.render(source, pose, lastPose, width, height, color, packedLight, OverlayTexture.NO_OVERLAY, flipped || doubleSided, !flipped || doubleSided, SlideState.getAnimationTick(), partialTick);
            matrices.popPose();
        }
    }

    public boolean shouldRenderOffScreen(ProjectorBlockEntity blockEntity) {
        return true;
    }

    public int getViewDistance() {
        return Config.getRenderDistance();
    }
}

