/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.slides;

import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.AddClientReloadListenersEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import org.teacon.slides.Slideshow;
import org.teacon.slides.config.Config;
import org.teacon.slides.item.FlipperItem;
import org.teacon.slides.projector.ProjectorScreen;
import org.teacon.slides.renderer.ProjectorRenderer;
import org.teacon.slides.renderer.SlideState;

public class SlideshowClient {
    @SubscribeEvent
    public static void registerRenders(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)Slideshow.PROJECTOR_BLOCK_ENTITY.get(), ctx -> new ProjectorRenderer());
    }

    @SubscribeEvent
    public static void setupClient(FMLClientSetupEvent event) {
        event.enqueueWork(() -> Config.refreshProperties());
    }

    @SubscribeEvent
    public static void onRegisterMenu(RegisterMenuScreensEvent event) {
        event.register((MenuType)Slideshow.PROJECTOR_SCREEN_HANDLER.get(), ProjectorScreen::new);
    }

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Pre event) {
        Minecraft mc = Minecraft.getInstance();
        SlideState.tick(mc);
        LocalPlayer player = mc.player;
        if (player != null) {
            FlipperItem.clientPlayerTick((Player)player);
        }
    }

    @SubscribeEvent
    public static void onRegisterReloadListeners(AddClientReloadListenersEvent event) {
        event.addListener(ResourceLocation.fromNamespaceAndPath((String)"slide_show", (String)"client_reload"), (PreparableReloadListener)new ResourceManagerReloadListener(){

            public void onResourceManagerReload(@Nonnull ResourceManager manager) {
                SlideState.clearCacheID();
                Config.refreshProperties();
            }
        });
    }
}

