/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.slides.network;

import com.mojang.authlib.GameProfile;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.teacon.slides.Slideshow;
import org.teacon.slides.network.Network;
import org.teacon.slides.projector.ProjectorBlock;
import org.teacon.slides.util.Utilities;

public class ProjectorExportC2SPayload
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<ProjectorExportC2SPayload> ID = new CustomPacketPayload.Type(Network.PACKET_EXPORT);
    private final boolean mFromID;
    private final String mLocation;

    public ProjectorExportC2SPayload(boolean fromID, String location) {
        this.mFromID = fromID;
        this.mLocation = location;
    }

    public ProjectorExportC2SPayload(RegistryFriendlyByteBuf buf) {
        this.mFromID = buf.readBoolean();
        this.mLocation = buf.readUtf();
    }

    public static void writeBuffer(ProjectorExportC2SPayload payload, RegistryFriendlyByteBuf buffer) {
        buffer.writeBoolean(payload.mFromID);
        buffer.writeUtf(payload.mLocation);
    }

    public static void handle(ProjectorExportC2SPayload payload, IPayloadContext context) {
        ServerPlayer serverPlayer = (ServerPlayer)context.player();
        if (ProjectorExportC2SPayload.giveImageItem(serverPlayer, payload.mFromID, payload.mLocation)) {
            return;
        }
        GameProfile profile = serverPlayer.getGameProfile();
        Slideshow.LOGGER.debug(Utilities.MARKER, "Received illegal packet for projector export: player = {}", (Object)profile);
    }

    public static boolean giveImageItem(ServerPlayer serverPlayer, boolean fromID, String location) {
        if (ProjectorBlock.hasProjectorPermission(serverPlayer)) {
            ItemStack itemStack = new ItemStack((ItemLike)Slideshow.IMAGE_ITEM.get(), 1);
            itemStack.set(Slideshow.FROM_ID_COMPONENT, (Object)fromID);
            itemStack.set(Slideshow.LOCATION_COMPONENT, (Object)location);
            boolean bl = serverPlayer.getInventory().add(itemStack);
            if (bl && itemStack.isEmpty()) {
                itemStack.setCount(1);
                ItemEntity itemEntity = serverPlayer.drop(itemStack, false);
                if (itemEntity != null) {
                    itemEntity.makeFakeItem();
                }
                serverPlayer.level().playSound(null, serverPlayer.getX(), serverPlayer.getY(), serverPlayer.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, ((serverPlayer.getRandom().nextFloat() - serverPlayer.getRandom().nextFloat()) * 0.7f + 1.0f) * 2.0f);
                serverPlayer.inventoryMenu.broadcastChanges();
            } else {
                ItemEntity itemEntity = serverPlayer.drop(itemStack, false);
                if (itemEntity != null) {
                    itemEntity.setNoPickUpDelay();
                    itemEntity.setTarget(serverPlayer.getUUID());
                }
            }
            return true;
        }
        return false;
    }

    public CustomPacketPayload.Type<ProjectorExportC2SPayload> type() {
        return ID;
    }
}

