/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.slides.projector;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.commons.lang3.StringUtils;
import org.teacon.slides.Slideshow;
import org.teacon.slides.network.ImageAfterUpdateC2SPayload;
import org.teacon.slides.network.Network;
import org.teacon.slides.renderer.SlideState;

@OnlyIn(value=Dist.CLIENT)
public class ImageSourceScreen
extends Screen {
    private final InteractionHand hand;
    private boolean fromId = false;
    private String location = "";
    private EditBox locationInput;
    private Button sourceUrlButton;
    private Button sourceIdButton;
    private boolean invalidLocation = false;
    private boolean resultDone = true;

    public ImageSourceScreen(InteractionHand hand, ItemStack itemStack) {
        super((Component)Component.translatable((String)"gui.slide_show.edit_image_source"));
        this.hand = hand;
        if (itemStack == null || itemStack.isEmpty()) {
            return;
        }
        this.fromId = Boolean.TRUE.equals(itemStack.get(Slideshow.FROM_ID_COMPONENT));
        this.location = (String)itemStack.get(Slideshow.LOCATION_COMPONENT);
        if (this.location == null) {
            this.location = "";
        }
    }

    protected void init() {
        super.init();
        this.sourceUrlButton = Button.builder((Component)Component.translatable((String)"gui.slide_show.url"), button -> {
            this.fromId = true;
            button.visible = false;
            this.sourceIdButton.visible = true;
        }).bounds(this.width / 2 - 100, 80, 200, 20).build();
        this.addRenderableWidget((GuiEventListener)this.sourceUrlButton);
        this.sourceIdButton = Button.builder((Component)Component.translatable((String)"gui.slide_show.id"), button -> {
            this.fromId = false;
            button.visible = false;
            this.sourceUrlButton.visible = true;
        }).bounds(this.width / 2 - 100, 80, 200, 20).build();
        this.addRenderableWidget((GuiEventListener)this.sourceIdButton);
        this.sourceUrlButton.visible = !this.fromId;
        this.sourceIdButton.visible = this.fromId;
        this.locationInput = new EditBox(this.font, this.width / 2 - 100, 110, 200, 16, (Component)Component.translatable((String)"gui.slide_show.url"));
        this.locationInput.setMaxLength(512);
        this.locationInput.setResponder(text -> {
            this.invalidLocation = StringUtils.isNotBlank((CharSequence)text) ? (this.fromId ? ResourceLocation.tryParse((String)text) == null : SlideState.createURI(text) == null) : false;
            this.locationInput.setTextColor(this.invalidLocation ? 14699339 : 0xE0E0E0);
            this.location = text;
        });
        this.locationInput.setValue(this.location);
        this.addRenderableWidget((GuiEventListener)this.locationInput);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, button -> {
            this.resultDone = true;
            this.finishEditing();
        }).bounds(this.width / 2 - 90, this.height / 4 + 114, 80, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_CANCEL, button -> {
            this.resultDone = false;
            this.finishEditing();
        }).bounds(this.width / 2 + 10, this.height / 4 + 114, 80, 20).build());
    }

    public void removed() {
        if (this.resultDone) {
            Network.adaptive$sendToServer(new ImageAfterUpdateC2SPayload(this.hand, this.fromId, this.location), new CustomPacketPayload[0]);
        }
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        this.renderBackground(context, mouseX, mouseY, delta);
        context.drawCenteredString(this.font, this.title, this.width / 2, 40, 0xFFFFFF);
        super.render(context, mouseX, mouseY, delta);
    }

    private void finishEditing() {
        this.minecraft.setScreen(null);
    }
}

