/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.slides.projector;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec2;
import org.apache.commons.lang3.StringUtils;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.teacon.slides.network.Network;
import org.teacon.slides.network.ProjectorAfterUpdateC2SPayload;
import org.teacon.slides.network.ProjectorExportC2SPayload;
import org.teacon.slides.projector.ProjectorBlock;
import org.teacon.slides.projector.ProjectorBlockEntity;
import org.teacon.slides.projector.ProjectorScreenHandler;
import org.teacon.slides.projector.SourceType;
import org.teacon.slides.renderer.SlideState;

public final class ProjectorScreen
extends AbstractContainerScreen<ProjectorScreenHandler> {
    private static final ResourceLocation GUI_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"slide_show", (String)"textures/gui/projector.png");
    private static final Component IMAGE_TEXT = Component.translatable((String)"gui.slide_show.section.image");
    private static final Component OFFSET_TEXT = Component.translatable((String)"gui.slide_show.section.offset");
    private static final Component OTHERS_TEXT = Component.translatable((String)"gui.slide_show.section.others");
    private static final Component URL_TEXT = Component.translatable((String)"gui.slide_show.url");
    private static final Component ID_TEXT = Component.translatable((String)"gui.slide_show.id");
    private static final Component EXPORT_TEXT = Component.translatable((String)"gui.slide_show.export");
    private static final Component CONTAINER_TEXT = Component.translatable((String)"gui.slide_show.container");
    private static final Component COLOR_TEXT = Component.translatable((String)"gui.slide_show.color");
    private static final Component WIDTH_TEXT = Component.translatable((String)"gui.slide_show.width");
    private static final Component HEIGHT_TEXT = Component.translatable((String)"gui.slide_show.height");
    private static final Component OFFSET_X_TEXT = Component.translatable((String)"gui.slide_show.offset_x");
    private static final Component OFFSET_Y_TEXT = Component.translatable((String)"gui.slide_show.offset_y");
    private static final Component OFFSET_Z_TEXT = Component.translatable((String)"gui.slide_show.offset_z");
    private static final Component FLIP_TEXT = Component.translatable((String)"gui.slide_show.flip");
    private static final Component ROTATE_TEXT = Component.translatable((String)"gui.slide_show.rotate");
    private static final Component SINGLE_DOUBLE_SIDED_TEXT = Component.translatable((String)"gui.slide_show.single_double_sided");
    private EditBox mURLInput;
    private EditBox mColorInput;
    private EditBox mWidthInput;
    private EditBox mHeightInput;
    private EditBox mOffsetXInput;
    private EditBox mOffsetYInput;
    private EditBox mOffsetZInput;
    private ScreenTexturedButtonWidget mSwitchURL;
    private ScreenTexturedButtonWidget mSwitchID;
    private ScreenTexturedButtonWidget mSwitchContainer;
    private ScreenTexturedButtonWidget mButtonExport;
    private ScreenTexturedButtonWidget mSwitchSingleSided;
    private ScreenTexturedButtonWidget mSwitchDoubleSided;
    private SourceType mSourceType;
    private boolean mDoubleSided;
    private int mImageColor = -1;
    private Vec2 mImageSize = Vec2.ONE;
    private Vector3f mImageOffset = new Vector3f();
    private ProjectorBlock.InternalRotation mRotation = ProjectorBlock.InternalRotation.NONE;
    private boolean mInvalidURL = true;
    private boolean mInvalidColor = true;
    private boolean mInvalidWidth = true;
    private boolean mInvalidHeight = true;
    private boolean mInvalidOffsetX = true;
    private boolean mInvalidOffsetY = true;
    private boolean mInvalidOffsetZ = true;
    private final ProjectorBlockEntity mEntity;
    private final int imageWidth;
    private final int imageHeight;

    public ProjectorScreen(ProjectorScreenHandler handler, Inventory inventory, Component title) {
        super((AbstractContainerMenu)handler, inventory, title);
        BlockEntity blockEntity = Minecraft.getInstance().level.getBlockEntity(handler.getPos());
        this.mEntity = blockEntity instanceof ProjectorBlockEntity ? (ProjectorBlockEntity)blockEntity : null;
        this.imageWidth = 176;
        this.imageHeight = 217;
    }

    protected void init() {
        super.init();
        if (this.mEntity == null) {
            return;
        }
        this.mSourceType = this.mEntity.mSourceType;
        int leftPos = (this.width - this.imageWidth) / 2;
        int topPos = (this.height - this.imageHeight) / 2;
        this.mURLInput = new EditBox(this.font, leftPos + 30, topPos + 29, 137, 16, (Component)Component.translatable((String)"gui.slide_show.url"));
        this.mURLInput.setMaxLength(512);
        this.mURLInput.setResponder(text -> {
            if (StringUtils.isNotBlank((CharSequence)text)) {
                this.mInvalidURL = switch (this.mSourceType) {
                    case SourceType.URL -> {
                        if (SlideState.createURI(text) == null) {
                            yield true;
                        }
                        yield false;
                    }
                    case SourceType.ResourceID -> {
                        if (ResourceLocation.tryParse((String)text) == null) {
                            yield true;
                        }
                        yield false;
                    }
                    default -> false;
                };
            } else {
                this.mInvalidURL = false;
            }
            this.mURLInput.setTextColor(this.mInvalidURL ? -2077877 : -2039584);
        });
        this.mURLInput.setValue(this.mEntity.mLocation);
        this.addRenderableWidget((GuiEventListener)this.mURLInput);
        this.setInitialFocus((GuiEventListener)this.mURLInput);
        this.mColorInput = new EditBox(this.font, leftPos + 55, topPos + 155, 56, 16, (Component)Component.translatable((String)"gui.slide_show.color"));
        this.mColorInput.setMaxLength(8);
        this.mColorInput.setResponder(text -> {
            try {
                this.mImageColor = Integer.parseUnsignedInt(text, 16);
                this.mInvalidColor = false;
            }
            catch (Exception e) {
                this.mInvalidColor = true;
            }
            this.mColorInput.setTextColor(this.mInvalidColor ? -2077877 : -2039584);
        });
        this.mColorInput.setValue(String.format("%08X", this.mEntity.mColor));
        this.mColorInput.setTooltip(Tooltip.create((Component)COLOR_TEXT));
        this.addRenderableWidget((GuiEventListener)this.mColorInput);
        this.mWidthInput = new EditBox(this.font, leftPos + 30, topPos + 51, 56, 16, (Component)Component.translatable((String)"gui.slide_show.width"));
        this.mWidthInput.setResponder(text -> {
            try {
                Vec2 newSize = new Vec2(ProjectorScreen.parseFloat(text), this.mImageSize.y);
                this.updateSize(newSize);
                this.mInvalidWidth = false;
            }
            catch (Exception e) {
                this.mInvalidWidth = true;
            }
            this.mWidthInput.setTextColor(this.mInvalidWidth ? -2077877 : -2039584);
        });
        this.mWidthInput.setValue(ProjectorScreen.floatToString(this.mEntity.mWidth));
        this.mWidthInput.setTooltip(Tooltip.create((Component)WIDTH_TEXT));
        this.addRenderableWidget((GuiEventListener)this.mWidthInput);
        this.mHeightInput = new EditBox(this.font, leftPos + 111, topPos + 51, 56, 16, (Component)Component.translatable((String)"gui.slide_show.height"));
        this.mHeightInput.setResponder(input -> {
            try {
                Vec2 newSize = new Vec2(this.mImageSize.x, ProjectorScreen.parseFloat(input));
                this.updateSize(newSize);
                this.mInvalidHeight = false;
            }
            catch (Exception e) {
                this.mInvalidHeight = true;
            }
            this.mHeightInput.setTextColor(this.mInvalidHeight ? -2077877 : -2039584);
        });
        this.mHeightInput.setValue(ProjectorScreen.floatToString(this.mEntity.mHeight));
        this.mHeightInput.setTooltip(Tooltip.create((Component)HEIGHT_TEXT));
        this.addRenderableWidget((GuiEventListener)this.mHeightInput);
        this.mOffsetXInput = new EditBox(this.font, leftPos + 30, topPos + 103, 29, 16, (Component)Component.translatable((String)"gui.slide_show.offset_x"));
        this.mOffsetXInput.setResponder(input -> {
            try {
                this.mImageOffset = new Vector3f(ProjectorScreen.parseFloat(input), this.mImageOffset.y(), this.mImageOffset.z());
                this.mInvalidOffsetX = false;
            }
            catch (Exception e) {
                this.mInvalidOffsetX = true;
            }
            this.mOffsetXInput.setTextColor(this.mInvalidOffsetX ? -2077877 : -2039584);
        });
        this.mOffsetXInput.setValue(ProjectorScreen.floatToString(this.mEntity.mOffsetX));
        this.mOffsetXInput.setTooltip(Tooltip.create((Component)OFFSET_X_TEXT));
        this.addRenderableWidget((GuiEventListener)this.mOffsetXInput);
        this.mOffsetYInput = new EditBox(this.font, leftPos + 84, topPos + 103, 29, 16, (Component)Component.translatable((String)"gui.slide_show.offset_y"));
        this.mOffsetYInput.setResponder(input -> {
            try {
                this.mImageOffset = new Vector3f(this.mImageOffset.x(), ProjectorScreen.parseFloat(input), this.mImageOffset.z());
                this.mInvalidOffsetY = false;
            }
            catch (Exception e) {
                this.mInvalidOffsetY = true;
            }
            this.mOffsetYInput.setTextColor(this.mInvalidOffsetY ? -2077877 : -2039584);
        });
        this.mOffsetYInput.setValue(ProjectorScreen.floatToString(this.mEntity.mOffsetY));
        this.mOffsetYInput.setTooltip(Tooltip.create((Component)OFFSET_Y_TEXT));
        this.addRenderableWidget((GuiEventListener)this.mOffsetYInput);
        this.mOffsetZInput = new EditBox(this.font, leftPos + 138, topPos + 103, 29, 16, (Component)Component.translatable((String)"gui.slide_show.offset_z"));
        this.mOffsetZInput.setResponder(input -> {
            try {
                this.mImageOffset = new Vector3f(this.mImageOffset.x(), this.mImageOffset.y(), ProjectorScreen.parseFloat(input));
                this.mInvalidOffsetZ = false;
            }
            catch (Exception e) {
                this.mInvalidOffsetZ = true;
            }
            this.mOffsetZInput.setTextColor(this.mInvalidOffsetZ ? -2077877 : -2039584);
        });
        this.mOffsetZInput.setValue(ProjectorScreen.floatToString(this.mEntity.mOffsetZ));
        this.mOffsetZInput.setTooltip(Tooltip.create((Component)OFFSET_Z_TEXT));
        this.addRenderableWidget((GuiEventListener)this.mOffsetZInput);
        ScreenTexturedButtonWidget flipBtn = new ScreenTexturedButtonWidget(leftPos + 117, topPos + 153, 18, 19, 179, 153, GUI_TEXTURE, button -> {
            ProjectorBlock.InternalRotation newRotation = this.mRotation.flip();
            this.updateRotation(newRotation);
        });
        flipBtn.setTooltip(Tooltip.create((Component)FLIP_TEXT));
        this.addRenderableWidget((GuiEventListener)flipBtn);
        ScreenTexturedButtonWidget rotationBtn = new ScreenTexturedButtonWidget(leftPos + 142, topPos + 153, 18, 19, 179, 173, GUI_TEXTURE, button -> {
            ProjectorBlock.InternalRotation newRotation = this.mRotation.compose(Rotation.CLOCKWISE_90);
            this.updateRotation(newRotation);
        });
        rotationBtn.setTooltip(Tooltip.create((Component)ROTATE_TEXT));
        this.addRenderableWidget((GuiEventListener)rotationBtn);
        this.mRotation = (ProjectorBlock.InternalRotation)((Object)this.mEntity.getBlockState().getValue(ProjectorBlock.ROTATION));
        this.mSwitchURL = new ScreenTexturedButtonWidget(leftPos + 9, topPos + 27, 18, 19, 179, 53, GUI_TEXTURE, button -> {
            this.mSourceType = SourceType.ResourceID;
            this.mSwitchID.visible = true;
            this.mSwitchURL.visible = false;
        });
        this.mSwitchURL.setTooltip(Tooltip.create((Component)URL_TEXT));
        this.mSwitchID = new ScreenTexturedButtonWidget(leftPos + 9, topPos + 27, 18, 19, 179, 73, GUI_TEXTURE, button -> {
            this.mSourceType = SourceType.ContainerBlock;
            this.mSwitchContainer.visible = true;
            this.mSwitchID.visible = false;
            this.mButtonExport.visible = false;
        });
        this.mSwitchID.setTooltip(Tooltip.create((Component)ID_TEXT));
        this.mSwitchContainer = new ScreenTexturedButtonWidget(leftPos + 9, topPos + 27, 18, 19, 179, 93, GUI_TEXTURE, button -> {
            this.mSourceType = SourceType.URL;
            this.mSwitchURL.visible = true;
            this.mSwitchContainer.visible = false;
            this.mButtonExport.visible = true;
        });
        this.mSwitchContainer.setTooltip(Tooltip.create((Component)CONTAINER_TEXT));
        this.mButtonExport = new ScreenTexturedButtonWidget(leftPos + 149, topPos + 7, 18, 19, 179, 33, GUI_TEXTURE, button -> this.sendExport());
        this.mButtonExport.setTooltip(Tooltip.create((Component)EXPORT_TEXT));
        this.mSwitchSingleSided = new ScreenTexturedButtonWidget(leftPos + 9, topPos + 153, 18, 19, 179, 113, GUI_TEXTURE, button -> {
            this.mDoubleSided = true;
            this.mSwitchDoubleSided.visible = true;
            this.mSwitchSingleSided.visible = false;
        });
        this.mSwitchSingleSided.setTooltip(Tooltip.create((Component)SINGLE_DOUBLE_SIDED_TEXT));
        this.mSwitchDoubleSided = new ScreenTexturedButtonWidget(leftPos + 9, topPos + 153, 18, 19, 179, 133, GUI_TEXTURE, button -> {
            this.mDoubleSided = false;
            this.mSwitchSingleSided.visible = true;
            this.mSwitchDoubleSided.visible = false;
        });
        this.mSwitchDoubleSided.setTooltip(Tooltip.create((Component)SINGLE_DOUBLE_SIDED_TEXT));
        this.mSwitchURL.visible = this.mSourceType == SourceType.URL;
        this.mSwitchID.visible = this.mSourceType == SourceType.ResourceID;
        this.mSwitchContainer.visible = this.mSourceType == SourceType.ContainerBlock;
        this.mButtonExport.visible = this.mSourceType != SourceType.ContainerBlock;
        this.mSwitchDoubleSided.visible = this.mDoubleSided = this.mEntity.mDoubleSided;
        this.mSwitchSingleSided.visible = !this.mDoubleSided;
        this.addRenderableWidget((GuiEventListener)this.mSwitchURL);
        this.addRenderableWidget((GuiEventListener)this.mSwitchID);
        this.addRenderableWidget((GuiEventListener)this.mSwitchContainer);
        this.addRenderableWidget((GuiEventListener)this.mButtonExport);
        this.addRenderableWidget((GuiEventListener)this.mSwitchSingleSided);
        this.addRenderableWidget((GuiEventListener)this.mSwitchDoubleSided);
    }

    private void updateRotation(ProjectorBlock.InternalRotation newRotation) {
        if (!(this.mInvalidOffsetX || this.mInvalidOffsetY || this.mInvalidOffsetZ)) {
            Vector3f absolute = ProjectorScreen.relativeToAbsolute(this.mImageOffset, this.mImageSize, this.mRotation);
            Vector3f newRelative = ProjectorScreen.absoluteToRelative(absolute, this.mImageSize, newRotation);
            this.mOffsetXInput.setValue(ProjectorScreen.floatToString(newRelative.x()));
            this.mOffsetYInput.setValue(ProjectorScreen.floatToString(newRelative.y()));
            this.mOffsetZInput.setValue(ProjectorScreen.floatToString(newRelative.z()));
        }
        this.mRotation = newRotation;
    }

    private void updateSize(Vec2 newSize) {
        if (!(this.mInvalidOffsetX || this.mInvalidOffsetY || this.mInvalidOffsetZ)) {
            Vector3f absolute = ProjectorScreen.relativeToAbsolute(this.mImageOffset, this.mImageSize, this.mRotation);
            Vector3f newRelative = ProjectorScreen.absoluteToRelative(absolute, newSize, this.mRotation);
            this.mOffsetXInput.setValue(ProjectorScreen.floatToString(newRelative.x()));
            this.mOffsetYInput.setValue(ProjectorScreen.floatToString(newRelative.y()));
            this.mOffsetZInput.setValue(ProjectorScreen.floatToString(newRelative.z()));
        }
        this.mImageSize = newSize;
    }

    protected void containerTick() {
        if (this.mEntity == null) {
            this.minecraft.player.closeContainer();
        }
    }

    private void sendExport() {
        if (this.mSourceType == SourceType.ContainerBlock) {
            return;
        }
        Network.adaptive$sendToServer(new ProjectorExportC2SPayload(this.mSourceType == SourceType.ResourceID, this.mURLInput.getValue()), new CustomPacketPayload[0]);
    }

    public void removed() {
        boolean invalidOffset;
        super.removed();
        if (this.mEntity == null) {
            return;
        }
        boolean invalidSize = this.mInvalidWidth || this.mInvalidHeight;
        boolean bl = invalidOffset = this.mInvalidOffsetX || this.mInvalidOffsetY || this.mInvalidOffsetZ;
        if (!this.mInvalidURL) {
            this.mEntity.mLocation = this.mURLInput.getValue();
        }
        if (!this.mInvalidColor) {
            this.mEntity.mColor = this.mImageColor;
        }
        if (!invalidSize) {
            this.mEntity.mWidth = this.mImageSize.x;
            this.mEntity.mHeight = this.mImageSize.y;
        }
        if (!invalidOffset) {
            this.mEntity.mOffsetX = this.mImageOffset.x();
            this.mEntity.mOffsetY = this.mImageOffset.y();
            this.mEntity.mOffsetZ = this.mImageOffset.z();
        }
        this.mEntity.needInitContainer = this.mEntity.mSourceType != this.mSourceType;
        this.mEntity.mSourceType = this.mSourceType;
        this.mEntity.mDoubleSided = this.mDoubleSided;
        Network.adaptive$sendToServer(new ProjectorAfterUpdateC2SPayload(this.mEntity, this.mRotation), new CustomPacketPayload[0]);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifier) {
        if (this.mEntity == null) {
            return super.keyPressed(keyCode, scanCode, modifier);
        }
        if (keyCode == 256) {
            this.minecraft.player.closeContainer();
            return true;
        }
        return this.mURLInput.keyPressed(keyCode, scanCode, modifier) || this.mURLInput.canConsumeInput() || this.mColorInput.keyPressed(keyCode, scanCode, modifier) || this.mColorInput.canConsumeInput() || this.mWidthInput.keyPressed(keyCode, scanCode, modifier) || this.mWidthInput.canConsumeInput() || this.mHeightInput.keyPressed(keyCode, scanCode, modifier) || this.mHeightInput.canConsumeInput() || this.mOffsetXInput.keyPressed(keyCode, scanCode, modifier) || this.mOffsetXInput.canConsumeInput() || this.mOffsetYInput.keyPressed(keyCode, scanCode, modifier) || this.mOffsetYInput.canConsumeInput() || this.mOffsetZInput.keyPressed(keyCode, scanCode, modifier) || this.mOffsetZInput.canConsumeInput() || super.keyPressed(keyCode, scanCode, modifier);
    }

    protected void renderBg(GuiGraphics context, float delta, int mouseX, int mouseY) {
        context.blit(RenderPipelines.GUI_TEXTURED, GUI_TEXTURE, (this.width - this.imageWidth) / 2, (this.height - this.imageHeight) / 2, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
    }

    protected void renderLabels(GuiGraphics ctx, int mouseX, int mouseY) {
        if (this.mEntity == null) {
            return;
        }
        int alpha = this.mImageColor >>> 24;
        if (alpha > 0) {
            ctx.blit(RenderPipelines.GUI_TEXTURED, GUI_TEXTURE, 38, 131, 180.0f, 194.0f, 10, 10, 256, 256, this.mImageColor);
            ctx.blit(RenderPipelines.GUI_TEXTURED, GUI_TEXTURE, 82, 159, 180.0f, 194.0f, 17, 17, 256, 256, this.mImageColor);
        }
        ctx.blit(RenderPipelines.GUI_TEXTURED, GUI_TEXTURE, 82, 159, 202.0f, (float)(194 - this.mRotation.ordinal() * 20), 17, 17, 256, 256);
        ProjectorScreen.drawCenteredStringWithoutShadow(ctx, this.font, IMAGE_TEXT, this.imageWidth / 2, -14);
        ProjectorScreen.drawCenteredStringWithoutShadow(ctx, this.font, OFFSET_TEXT, this.imageWidth / 2, 60);
        ProjectorScreen.drawCenteredStringWithoutShadow(ctx, this.font, OTHERS_TEXT, this.imageWidth / 2, 112);
    }

    private static void drawCenteredStringWithoutShadow(GuiGraphics ctx, Font textRenderer, Component text, int centerX, int y) {
        FormattedCharSequence orderedText = text.getVisualOrderText();
        ctx.drawString(textRenderer, orderedText, centerX - textRenderer.width(orderedText) / 2, y, -12566464, false);
    }

    private static float parseFloat(String text) {
        return (float)Math.round(Float.parseFloat(text) * 10000.0f) / 10000.0f;
    }

    private static String floatToString(float value) {
        return String.valueOf((float)Math.round(value * 10000.0f) / 10000.0f);
    }

    private static Vector3f relativeToAbsolute(Vector3f relatedOffset, Vec2 size, ProjectorBlock.InternalRotation rotation) {
        Vector4f center = new Vector4f(0.5f * size.x, 0.0f, 0.5f * size.y, 1.0f);
        center.mul((Matrix4fc)new Matrix4f().translate(relatedOffset.x(), -relatedOffset.z(), relatedOffset.y()));
        center.mul((Matrix4fc)new Matrix4f().translate(-0.5f, 0.0f, 0.5f - size.y));
        rotation.transform(center);
        return new Vector3f(center.x(), center.y(), center.z());
    }

    private static Vector3f absoluteToRelative(Vector3f absoluteOffset, Vec2 size, ProjectorBlock.InternalRotation rotation) {
        Vector4f center = new Vector4f((Vector3fc)absoluteOffset, 1.0f);
        rotation.invert().transform(center);
        center.mul((Matrix4fc)new Matrix4f().translate(0.5f, 0.0f, -0.5f + size.y));
        center.mul((Matrix4fc)new Matrix4f().translate(-0.5f * size.x, 0.0f, -0.5f * size.y));
        return new Vector3f(center.x(), center.z(), -center.y());
    }

    public static class ScreenTexturedButtonWidget
    extends Button {
        public int u;
        public int v;
        public ResourceLocation texture;

        public ScreenTexturedButtonWidget(int x, int y, int width, int height, int u, int v, ResourceLocation texture, Button.OnPress pressAction) {
            super(x, y, width, height, CommonComponents.EMPTY, pressAction, DEFAULT_NARRATION);
            this.u = u;
            this.v = v;
            this.texture = texture;
        }

        public void renderWidget(GuiGraphics context, int mouseX, int mouseY, float delta) {
            context.blit(RenderPipelines.GUI_TEXTURED, this.texture, this.getX(), this.getY(), (float)this.u, (float)this.v, this.width, this.height, 256, 256);
        }
    }
}

