/*
 * Decompiled with CFR 0.152.
 */
package dev.matrixlab.webp4j;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;

public class NativeLibraryLoaderUtils {
    private static final String LIBWEBP_VERSION = "1.4.0";

    public static void loadLibrary() {
        String libExtension;
        String architecture;
        String platform;
        String os = System.getProperty("os.name").toLowerCase();
        String arch = System.getProperty("os.arch").toLowerCase();
        if (os.contains("win")) {
            platform = "windows";
            architecture = "x64";
            libExtension = "dll";
        } else if (os.contains("nux") || os.contains("linux")) {
            platform = "linux";
            architecture = arch.contains("aarch64") ? "aarch64" : "x86-64";
            libExtension = "so";
        } else if (os.contains("mac")) {
            platform = "mac";
            architecture = arch.contains("aarch64") ? "arm64" : "x86-64";
            libExtension = "dylib";
        } else {
            throw new UnsupportedOperationException(String.format("Unsupported os: %s, arch: %s", os, arch));
        }
        String libraryFileName = String.format("webp4j-%s-%s-%s.%s", LIBWEBP_VERSION, platform, architecture, libExtension);
        String resourcePath = String.format("/native/%s", libraryFileName);
        try (InputStream in = NativeLibraryLoaderUtils.class.getResourceAsStream(resourcePath);){
            if (in == null) {
                throw new RuntimeException(String.format("Could not find WebP native library(%s) for %s %s in the jar", libraryFileName, os, arch));
            }
            File tempLibraryFile = Files.createTempFile("", libraryFileName, new FileAttribute[0]).toFile();
            tempLibraryFile.deleteOnExit();
            try (FileOutputStream out = new FileOutputStream(tempLibraryFile);){
                int bytesRead;
                byte[] buffer = new byte[8192];
                while ((bytesRead = in.read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                }
            }
            System.load(tempLibraryFile.getAbsolutePath());
        }
        catch (IOException e) {
            throw new RuntimeException("Could not load native WebP library", e);
        }
    }
}

