/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.slides.projector;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1162;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_241;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_342;
import net.minecraft.class_344;
import net.minecraft.class_364;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_5348;
import org.apache.commons.lang3.StringUtils;
import org.teacon.slides.network.ProjectorAfterUpdateC2SPacket;
import org.teacon.slides.network.ProjectorExportC2SPacket;
import org.teacon.slides.projector.ImageProperties;
import org.teacon.slides.projector.ProjectorBlock;
import org.teacon.slides.projector.ProjectorBlockEntity;
import org.teacon.slides.projector.ProjectorScreenHandler;
import org.teacon.slides.projector.SourceType;
import org.teacon.slides.renderer.SlideState;
import org.teacon.slides.util.RenderUtils;
import org.teacon.slides.util.Text;

public final class ProjectorScreen
extends class_465<ProjectorScreenHandler> {
    private static final class_2960 GUI_TEXTURE = new class_2960("slide_show", "textures/gui/projector.png");
    private static final class_2561 IMAGE_TEXT = Text.translatable("gui.slide_show.section.image", new Object[0]);
    private static final class_2561 OFFSET_TEXT = Text.translatable("gui.slide_show.section.offset", new Object[0]);
    private static final class_2561 OTHERS_TEXT = Text.translatable("gui.slide_show.section.others", new Object[0]);
    private static final class_2561 URL_TEXT = Text.translatable("gui.slide_show.url", new Object[0]);
    private static final class_2561 ID_TEXT = Text.translatable("gui.slide_show.id", new Object[0]);
    private static final class_2561 EXPORT_TEXT = Text.translatable("gui.slide_show.export", new Object[0]);
    private static final class_2561 CONTAINER_TEXT = Text.translatable("gui.slide_show.container", new Object[0]);
    private static final class_2561 COLOR_TEXT = Text.translatable("gui.slide_show.color", new Object[0]);
    private static final class_2561 WIDTH_TEXT = Text.translatable("gui.slide_show.width", new Object[0]);
    private static final class_2561 HEIGHT_TEXT = Text.translatable("gui.slide_show.height", new Object[0]);
    private static final class_2561 ANGLE_X_TEXT = Text.translatable("gui.slide_show.angle_x", new Object[0]);
    private static final class_2561 ANGLE_Y_TEXT = Text.translatable("gui.slide_show.angle_y", new Object[0]);
    private static final class_2561 ANGLE_Z_TEXT = Text.translatable("gui.slide_show.angle_z", new Object[0]);
    private static final class_2561 OFFSET_X_TEXT = Text.translatable("gui.slide_show.offset_x", new Object[0]);
    private static final class_2561 OFFSET_Y_TEXT = Text.translatable("gui.slide_show.offset_y", new Object[0]);
    private static final class_2561 OFFSET_Z_TEXT = Text.translatable("gui.slide_show.offset_z", new Object[0]);
    private static final class_2561 FLIP_TEXT = Text.translatable("gui.slide_show.flip", new Object[0]);
    private static final class_2561 ROTATE_TEXT = Text.translatable("gui.slide_show.rotate", new Object[0]);
    private static final class_2561 SINGLE_DOUBLE_SIDED_TEXT = Text.translatable("gui.slide_show.single_double_sided", new Object[0]);
    private static final class_2561 LAST_SCREEN_TEXT = Text.translatable("gui.slide_show.last_screen", new Object[0]);
    private static final class_2561 NEXT_SCREEN_TEXT = Text.translatable("gui.slide_show.next_screen", new Object[0]);
    private static final class_2561 NEW_SCREEN_TEXT = Text.translatable("gui.slide_show.new_screen", new Object[0]);
    private static final class_2561 REMOVE_SCREEN_TEXT = Text.translatable("gui.slide_show.remove_screen", new Object[0]);
    private static final Predicate<String> COLOR_PREDICATE = string -> string.matches("^[0-9A-Fa-f]+$");
    private static final Predicate<String> INTEGER_PREDICATE = string -> string.matches("^[-+]?\\d*$");
    private static int LAST_SCREEN = 0;
    private static class_2338 LAST_PROJECTOR_POS = null;
    private boolean editBool = true;
    private class_2350 blockDirection;
    private class_342 mURLInput;
    private class_342 mColorInput;
    private class_342 mWidthInput;
    private class_342 mHeightInput;
    private class_342 mOffsetXInput;
    private class_342 mOffsetYInput;
    private class_342 mOffsetZInput;
    private class_342 mAngleXInput;
    private class_342 mAngleYInput;
    private class_342 mAngleZInput;
    private class_344 mLastScreen;
    private class_344 mNextScreen;
    private class_344 mNewScreen;
    private class_344 mRemoveScreen;
    private class_344 mSwitchURL;
    private class_344 mSwitchID;
    private class_344 mSwitchContainer;
    private class_344 mButtonExport;
    private class_344 mSwitchSingleSided;
    private class_344 mSwitchDoubleSided;
    private SourceType mSourceType;
    private List<ImageProperties> props;
    private int propIndex;
    private boolean mDoubleSided;
    private int mImageColor = -1;
    private class_241 mImageSize = class_241.field_1335;
    private class_1160 mImageOffset = new class_1160(0.0f, 0.0f, 0.0f);
    private class_2382 mImageAngles = new class_2382(0, 0, 0);
    private ProjectorBlock.InternalRotation mRotation = ProjectorBlock.InternalRotation.NONE;
    private boolean mInvalidURL = true;
    private boolean mInvalidColor = false;
    private boolean mInvalidWidth = false;
    private boolean mInvalidHeight = false;
    private boolean mInvalidOffsetX = false;
    private boolean mInvalidOffsetY = false;
    private boolean mInvalidOffsetZ = false;
    private final ProjectorBlockEntity mEntity;
    private final int imageWidth;
    private final int imageHeight;

    public ProjectorScreen(ProjectorScreenHandler handler, class_1661 inventory, class_2561 title) {
        super((class_1703)handler, inventory, title);
        class_2586 blockEntity = class_310.method_1551().field_1687.method_8321(handler.getPos());
        this.mEntity = blockEntity instanceof ProjectorBlockEntity ? (ProjectorBlockEntity)blockEntity : null;
        this.imageWidth = 176;
        this.imageHeight = 217;
    }

    protected void method_25426() {
        super.method_25426();
        if (this.mEntity == null) {
            return;
        }
        this.mSourceType = this.mEntity.mSourceType;
        this.field_22787.field_1774.method_1462(true);
        this.props = new ArrayList<ImageProperties>();
        this.blockDirection = (class_2350)this.mEntity.method_11010().method_11654((class_2769)class_2741.field_12525);
        this.mEntity.imageProps.forEach(prop -> {
            ImageProperties nP = prop.copy();
            if (nP.anglesUseDefault) {
                nP.updateAngles(this.blockDirection);
            }
            this.props.add(nP);
        });
        if (this.props.isEmpty()) {
            this.props.add(new ImageProperties());
        }
        this.propIndex = 0;
        if (this.mEntity.method_11016().equals((Object)LAST_PROJECTOR_POS) && LAST_SCREEN < this.props.size()) {
            this.propIndex = LAST_SCREEN;
        }
        int leftPos = (this.field_22789 - this.imageWidth) / 2;
        int topPos = (this.field_22790 - this.imageHeight) / 2;
        this.mURLInput = new class_342(this.field_22793, leftPos + 30, topPos + 29, 137, 16, (class_2561)Text.translatable("gui.slide_show.url", new Object[0]));
        this.mURLInput.method_1880(512);
        this.mURLInput.method_1863(text -> {
            if (StringUtils.isNotBlank((CharSequence)text)) {
                this.mInvalidURL = switch (this.mSourceType) {
                    case SourceType.URL -> {
                        if (SlideState.createURI(text) == null) {
                            yield true;
                        }
                        yield false;
                    }
                    case SourceType.ResourceID -> {
                        if (class_2960.method_12829((String)text) == null) {
                            yield true;
                        }
                        yield false;
                    }
                    default -> false;
                };
            } else {
                this.mInvalidURL = false;
            }
            this.mURLInput.method_1868(this.mInvalidURL ? 14699339 : 0xE0E0E0);
        });
        this.mURLInput.method_1852(this.mEntity.mLocation);
        this.method_37063((class_364)this.mURLInput);
        this.method_20085((class_364)this.mURLInput);
        this.mColorInput = new class_342(this.field_22793, leftPos + 55, topPos + 155, 56, 16, (class_2561)Text.translatable("gui.slide_show.color", new Object[0]));
        this.mColorInput.method_1880(8);
        this.mColorInput.method_1890(COLOR_PREDICATE);
        this.mColorInput.method_1863(text -> {
            try {
                this.mImageColor = Integer.parseUnsignedInt(text, 16);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.mColorInput.method_1852(String.format("%08X", this.mEntity.mColor));
        this.mColorInput.method_1868(0xE0E0E0);
        this.method_37063((class_364)this.mColorInput);
        this.mLastScreen = new class_344(leftPos + 9, topPos + 55, 9, 9, 201, 33, 0, GUI_TEXTURE, button -> this.switchToScreen(this.propIndex - 1));
        this.mNextScreen = new class_344(leftPos + 157, topPos + 55, 9, 9, 211, 33, 0, GUI_TEXTURE, button -> this.switchToScreen(this.propIndex + 1));
        this.mNewScreen = new class_344(leftPos + 157, topPos + 55, 9, 9, 201, 43, 0, GUI_TEXTURE, button -> {
            ImageProperties prop = new ImageProperties();
            prop.updateAngles(this.blockDirection);
            this.props.add(prop);
            this.switchToScreen(this.props.size() - 1);
        });
        this.mRemoveScreen = new class_344(leftPos + 142, topPos + 55, 9, 9, 211, 43, 0, GUI_TEXTURE, button -> {
            if (this.props.size() == 1) {
                return;
            }
            this.props.remove(this.propIndex);
            if (this.propIndex == this.props.size()) {
                --this.propIndex;
            }
            this.switchToScreen(this.propIndex);
        });
        this.method_37063((class_364)this.mLastScreen);
        this.method_37063((class_364)this.mNextScreen);
        this.method_37063((class_364)this.mNewScreen);
        this.method_37063((class_364)this.mRemoveScreen);
        this.mWidthInput = new class_342(this.field_22793, leftPos + 30, topPos + 68, 56, 16, (class_2561)Text.translatable("gui.slide_show.width", new Object[0]));
        this.mWidthInput.method_1863(input -> {
            if (this.editBool) {
                try {
                    float nValue = ProjectorScreen.parseFloat(input);
                    class_241 newSize = new class_241(nValue, this.mImageSize.field_1342);
                    this.updateSize(newSize);
                    this.props.get((int)this.propIndex).width = nValue;
                    this.mInvalidWidth = false;
                }
                catch (Exception e) {
                    this.mInvalidWidth = true;
                }
                this.mWidthInput.method_1868(this.mInvalidWidth ? 14699339 : 0xE0E0E0);
            } else {
                this.mInvalidWidth = false;
                this.mWidthInput.method_1868(0xE0E0E0);
            }
        });
        this.method_37063((class_364)this.mWidthInput);
        this.mHeightInput = new class_342(this.field_22793, leftPos + 111, topPos + 68, 56, 16, (class_2561)Text.translatable("gui.slide_show.height", new Object[0]));
        this.mHeightInput.method_1863(input -> {
            if (this.editBool) {
                try {
                    float nValue = ProjectorScreen.parseFloat(input);
                    class_241 newSize = new class_241(this.mImageSize.field_1343, nValue);
                    this.updateSize(newSize);
                    this.props.get((int)this.propIndex).height = nValue;
                    this.mInvalidHeight = false;
                }
                catch (Exception e) {
                    this.mInvalidHeight = true;
                }
                this.mHeightInput.method_1868(this.mInvalidHeight ? 14699339 : 0xE0E0E0);
            } else {
                this.mInvalidWidth = false;
                this.mWidthInput.method_1868(0xE0E0E0);
            }
        });
        this.method_37063((class_364)this.mHeightInput);
        this.mAngleXInput = new class_342(this.field_22793, leftPos + 30, topPos + 90, 29, 16, (class_2561)Text.translatable("gui.slide_show.angle_x", new Object[0]));
        this.mAngleXInput.method_1890(INTEGER_PREDICATE);
        this.mAngleXInput.method_1863(input -> {
            if (this.editBool) {
                try {
                    ImageProperties prop = this.props.get(this.propIndex);
                    int nValue = Integer.parseInt(input);
                    if (prop.angleX != nValue) {
                        this.mImageAngles = new class_2382(nValue, this.mImageAngles.method_10264(), this.mImageAngles.method_10260());
                        prop.anglesUseDefault = false;
                        prop.angleX = nValue;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.mAngleXInput.method_1868(0xE0E0E0);
        this.method_37063((class_364)this.mAngleXInput);
        this.mAngleYInput = new class_342(this.field_22793, leftPos + 84, topPos + 90, 29, 16, (class_2561)Text.translatable("gui.slide_show.angle_y", new Object[0]));
        this.mAngleYInput.method_1890(INTEGER_PREDICATE);
        this.mAngleYInput.method_1863(input -> {
            if (this.editBool) {
                try {
                    ImageProperties prop = this.props.get(this.propIndex);
                    int nValue = Integer.parseInt(input);
                    if (prop.angleY != nValue) {
                        this.mImageAngles = new class_2382(this.mImageAngles.method_10263(), nValue, this.mImageAngles.method_10260());
                        prop.anglesUseDefault = false;
                        prop.angleY = nValue;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.mAngleYInput.method_1868(0xE0E0E0);
        this.method_37063((class_364)this.mAngleYInput);
        this.mAngleZInput = new class_342(this.field_22793, leftPos + 138, topPos + 90, 29, 16, (class_2561)Text.translatable("gui.slide_show.angle_z", new Object[0]));
        this.mAngleZInput.method_1890(INTEGER_PREDICATE);
        this.mAngleZInput.method_1863(input -> {
            if (this.editBool) {
                try {
                    ImageProperties prop = this.props.get(this.propIndex);
                    int nValue = Integer.parseInt(input);
                    if (prop.angleZ != nValue) {
                        this.mImageAngles = new class_2382(this.mImageAngles.method_10263(), this.mImageAngles.method_10264(), nValue);
                        prop.anglesUseDefault = false;
                        prop.angleZ = nValue;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.mAngleZInput.method_1868(0xE0E0E0);
        this.method_37063((class_364)this.mAngleZInput);
        this.mOffsetXInput = new class_342(this.field_22793, leftPos + 30, topPos + 112, 29, 16, (class_2561)Text.translatable("gui.slide_show.offset_x", new Object[0]));
        this.mOffsetXInput.method_1863(input -> {
            if (this.editBool) {
                try {
                    float nValue = ProjectorScreen.parseFloat(input);
                    this.mImageOffset = new class_1160(ProjectorScreen.parseFloat(input), this.mImageOffset.method_4945(), this.mImageOffset.method_4947());
                    this.props.get((int)this.propIndex).offsetX = nValue;
                    this.mInvalidOffsetX = false;
                }
                catch (Exception e) {
                    this.mInvalidOffsetX = true;
                }
                this.mOffsetXInput.method_1868(this.mInvalidOffsetX ? 14699339 : 0xE0E0E0);
            } else {
                this.mInvalidWidth = false;
                this.mWidthInput.method_1868(0xE0E0E0);
            }
        });
        this.method_37063((class_364)this.mOffsetXInput);
        this.mOffsetYInput = new class_342(this.field_22793, leftPos + 84, topPos + 112, 29, 16, (class_2561)Text.translatable("gui.slide_show.offset_y", new Object[0]));
        this.mOffsetYInput.method_1863(input -> {
            if (this.editBool) {
                try {
                    float nValue = ProjectorScreen.parseFloat(input);
                    this.mImageOffset = new class_1160(this.mImageOffset.method_4943(), ProjectorScreen.parseFloat(input), this.mImageOffset.method_4947());
                    this.props.get((int)this.propIndex).offsetY = nValue;
                    this.mInvalidOffsetY = false;
                }
                catch (Exception e) {
                    this.mInvalidOffsetY = true;
                }
                this.mOffsetYInput.method_1868(this.mInvalidOffsetY ? 14699339 : 0xE0E0E0);
            } else {
                this.mInvalidWidth = false;
                this.mWidthInput.method_1868(0xE0E0E0);
            }
        });
        this.method_37063((class_364)this.mOffsetYInput);
        this.mOffsetZInput = new class_342(this.field_22793, leftPos + 138, topPos + 112, 29, 16, (class_2561)Text.translatable("gui.slide_show.offset_z", new Object[0]));
        this.mOffsetZInput.method_1863(input -> {
            if (this.editBool) {
                try {
                    float nValue = ProjectorScreen.parseFloat(input);
                    this.mImageOffset = new class_1160(this.mImageOffset.method_4943(), this.mImageOffset.method_4945(), ProjectorScreen.parseFloat(input));
                    this.props.get((int)this.propIndex).offsetZ = nValue;
                    this.mInvalidOffsetZ = false;
                }
                catch (Exception e) {
                    this.mInvalidOffsetZ = true;
                }
                this.mOffsetZInput.method_1868(this.mInvalidOffsetZ ? 14699339 : 0xE0E0E0);
            } else {
                this.mInvalidWidth = false;
                this.mWidthInput.method_1868(0xE0E0E0);
            }
        });
        this.method_37063((class_364)this.mOffsetZInput);
        this.switchToScreen(this.propIndex);
        this.method_37063((class_364)new class_344(leftPos + 117, topPos + 153, 18, 19, 179, 153, 0, GUI_TEXTURE, button -> {
            ProjectorBlock.InternalRotation newRotation = this.mRotation.flip();
            this.updateRotation(newRotation);
        }));
        this.method_37063((class_364)new class_344(leftPos + 142, topPos + 153, 18, 19, 179, 173, 0, GUI_TEXTURE, button -> {
            ProjectorBlock.InternalRotation newRotation = this.mRotation.compose(class_2470.field_11463);
            this.updateRotation(newRotation);
        }));
        this.mRotation = (ProjectorBlock.InternalRotation)((Object)this.mEntity.method_11010().method_11654(ProjectorBlock.ROTATION));
        this.mSwitchURL = new class_344(leftPos + 9, topPos + 27, 18, 19, 179, 53, 0, GUI_TEXTURE, button -> {
            this.mSourceType = SourceType.ResourceID;
            this.mSwitchID.field_22764 = true;
            this.mSwitchURL.field_22764 = false;
        });
        this.mSwitchID = new class_344(leftPos + 9, topPos + 27, 18, 19, 179, 73, 0, GUI_TEXTURE, button -> {
            this.mSourceType = SourceType.ContainerBlock;
            this.mSwitchContainer.field_22764 = true;
            this.mSwitchID.field_22764 = false;
            this.mButtonExport.field_22764 = false;
        });
        this.mSwitchContainer = new class_344(leftPos + 9, topPos + 27, 18, 19, 179, 93, 0, GUI_TEXTURE, button -> {
            this.mSourceType = SourceType.URL;
            this.mSwitchURL.field_22764 = true;
            this.mSwitchContainer.field_22764 = false;
            this.mButtonExport.field_22764 = true;
        });
        this.mButtonExport = new class_344(leftPos + 149, topPos + 7, 18, 19, 179, 33, 0, GUI_TEXTURE, button -> this.sendExport());
        this.mSwitchSingleSided = new class_344(leftPos + 9, topPos + 153, 18, 19, 179, 113, 0, GUI_TEXTURE, button -> {
            this.mDoubleSided = true;
            this.mSwitchDoubleSided.field_22764 = true;
            this.mSwitchSingleSided.field_22764 = false;
        });
        this.mSwitchDoubleSided = new class_344(leftPos + 9, topPos + 153, 18, 19, 179, 133, 0, GUI_TEXTURE, button -> {
            this.mDoubleSided = false;
            this.mSwitchSingleSided.field_22764 = true;
            this.mSwitchDoubleSided.field_22764 = false;
        });
        this.mSwitchURL.field_22764 = this.mSourceType == SourceType.URL;
        this.mSwitchID.field_22764 = this.mSourceType == SourceType.ResourceID;
        this.mSwitchContainer.field_22764 = this.mSourceType == SourceType.ContainerBlock;
        this.mButtonExport.field_22764 = this.mSourceType != SourceType.ContainerBlock;
        this.mSwitchDoubleSided.field_22764 = this.mDoubleSided = this.mEntity.mDoubleSided;
        this.mSwitchSingleSided.field_22764 = !this.mDoubleSided;
        this.method_37063((class_364)this.mSwitchURL);
        this.method_37063((class_364)this.mSwitchID);
        this.method_37063((class_364)this.mSwitchContainer);
        this.method_37063((class_364)this.mButtonExport);
        this.method_37063((class_364)this.mSwitchSingleSided);
        this.method_37063((class_364)this.mSwitchDoubleSided);
    }

    private void syncNewSize(ImageProperties prop) {
        this.mImageSize = new class_241(prop.width, prop.height);
        this.editBool = false;
        this.mWidthInput.method_1852(ProjectorScreen.floatToString(prop.width));
        this.mHeightInput.method_1852(ProjectorScreen.floatToString(prop.height));
        this.editBool = true;
    }

    private void syncNewOffset(ImageProperties prop) {
        this.mImageOffset = new class_1160(prop.offsetX, prop.offsetY, prop.offsetZ);
        this.editBool = false;
        this.mOffsetXInput.method_1852(ProjectorScreen.floatToString(prop.offsetX));
        this.mOffsetYInput.method_1852(ProjectorScreen.floatToString(prop.offsetY));
        this.mOffsetZInput.method_1852(ProjectorScreen.floatToString(prop.offsetZ));
        this.editBool = true;
    }

    private void syncNewAngles(ImageProperties prop) {
        this.mImageAngles = new class_2382(prop.angleX, prop.angleY, prop.angleZ);
        this.editBool = false;
        this.mAngleXInput.method_1852(String.valueOf(prop.angleX));
        this.mAngleYInput.method_1852(String.valueOf(prop.angleY));
        this.mAngleZInput.method_1852(String.valueOf(prop.angleZ));
        this.editBool = true;
    }

    private void switchToScreen(int index) {
        this.propIndex = index;
        ImageProperties prop = this.props.get(this.propIndex);
        this.syncNewSize(prop);
        this.syncNewOffset(prop);
        this.syncNewAngles(prop);
        this.mLastScreen.field_22764 = this.propIndex > 0;
        this.mNextScreen.field_22764 = this.propIndex < this.props.size() - 1;
        this.mNewScreen.field_22764 = !this.mNextScreen.field_22764;
        this.mRemoveScreen.field_22764 = this.props.size() > 1;
    }

    private void updateRotation(ProjectorBlock.InternalRotation newRotation) {
        if (!(this.mInvalidOffsetX || this.mInvalidOffsetY || this.mInvalidOffsetZ)) {
            class_1160 absolute = ProjectorScreen.relativeToAbsolute(this.mImageOffset, this.mImageSize, this.mRotation);
            class_1160 newRelative = ProjectorScreen.absoluteToRelative(absolute, this.mImageSize, newRotation);
            ImageProperties prop = this.props.get(this.propIndex);
            prop.offsetX = newRelative.method_4943();
            prop.offsetY = newRelative.method_4945();
            prop.offsetZ = newRelative.method_4947();
            this.syncNewOffset(prop);
        }
        this.mRotation = newRotation;
    }

    private void updateSize(class_241 newSize) {
        if (!(this.mInvalidOffsetX || this.mInvalidOffsetY || this.mInvalidOffsetZ)) {
            class_1160 absolute = ProjectorScreen.relativeToAbsolute(this.mImageOffset, this.mImageSize, this.mRotation);
            class_1160 newRelative = ProjectorScreen.absoluteToRelative(absolute, newSize, this.mRotation);
            ImageProperties prop = this.props.get(this.propIndex);
            prop.offsetX = newRelative.method_4943();
            prop.offsetY = newRelative.method_4945();
            prop.offsetZ = newRelative.method_4947();
            this.syncNewOffset(prop);
        }
        this.mImageSize = newSize;
    }

    protected void method_37432() {
        if (this.mEntity == null) {
            this.field_22787.field_1724.method_7346();
            return;
        }
        this.mURLInput.method_1865();
        this.mColorInput.method_1865();
        this.mAngleXInput.method_1865();
        this.mAngleYInput.method_1865();
        this.mAngleZInput.method_1865();
        this.mWidthInput.method_1865();
        this.mHeightInput.method_1865();
        this.mOffsetXInput.method_1865();
        this.mOffsetYInput.method_1865();
        this.mOffsetZInput.method_1865();
    }

    private void sendExport() {
        if (this.mSourceType == SourceType.ContainerBlock) {
            return;
        }
        new ProjectorExportC2SPacket(this.mSourceType == SourceType.ResourceID, this.mURLInput.method_1882()).sendToServer();
    }

    public void method_25432() {
        super.method_25432();
        if (this.mEntity == null) {
            return;
        }
        LAST_SCREEN = this.propIndex;
        LAST_PROJECTOR_POS = this.mEntity.method_11016();
        if (!this.mInvalidURL) {
            this.mEntity.mLocation = this.mURLInput.method_1882();
        }
        if (!this.mInvalidColor) {
            this.mEntity.mColor = this.mImageColor;
        }
        this.mEntity.updateProps(this.props);
        this.mEntity.needInitContainer = this.mEntity.mSourceType != this.mSourceType;
        this.mEntity.mSourceType = this.mSourceType;
        this.mEntity.mDoubleSided = this.mDoubleSided;
        new ProjectorAfterUpdateC2SPacket(this.mEntity, this.mRotation).sendToServer();
    }

    public boolean method_25404(int keyCode, int scanCode, int modifier) {
        if (keyCode == 256) {
            this.field_22787.field_1724.method_7346();
            return true;
        }
        return this.mURLInput.method_25404(keyCode, scanCode, modifier) || this.mURLInput.method_20315() || this.mColorInput.method_25404(keyCode, scanCode, modifier) || this.mColorInput.method_20315() || this.mAngleXInput.method_25404(keyCode, scanCode, modifier) || this.mAngleXInput.method_20315() || this.mAngleYInput.method_25404(keyCode, scanCode, modifier) || this.mAngleYInput.method_20315() || this.mAngleZInput.method_25404(keyCode, scanCode, modifier) || this.mAngleZInput.method_20315() || this.mWidthInput.method_25404(keyCode, scanCode, modifier) || this.mWidthInput.method_20315() || this.mHeightInput.method_25404(keyCode, scanCode, modifier) || this.mHeightInput.method_20315() || this.mOffsetXInput.method_25404(keyCode, scanCode, modifier) || this.mOffsetXInput.method_20315() || this.mOffsetYInput.method_25404(keyCode, scanCode, modifier) || this.mOffsetYInput.method_20315() || this.mOffsetZInput.method_25404(keyCode, scanCode, modifier) || this.mOffsetZInput.method_20315() || super.method_25404(keyCode, scanCode, modifier);
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.method_25420(matrices);
        super.method_25394(matrices, mouseX, mouseY, delta);
    }

    protected void method_2389(class_4587 matrixStack, float f, int i, int j) {
        this.method_25420(matrixStack);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)GUI_TEXTURE);
        this.method_25302(matrixStack, (this.field_22789 - this.imageWidth) / 2, (this.field_22790 - this.imageHeight) / 2, 0, 0, this.imageWidth, this.imageHeight);
    }

    protected void method_2388(class_4587 matrixStack, int mouseX, int mouseY) {
        if (this.mEntity == null) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderTexture((int)0, (class_2960)GUI_TEXTURE);
        int alpha = this.mImageColor >>> 24;
        if (alpha > 0) {
            int red = this.mImageColor >> 16 & 0xFF;
            int green = this.mImageColor >> 8 & 0xFF;
            int blue = this.mImageColor & 0xFF;
            RenderUtils.setShaderColor((float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f, (float)alpha / 255.0f);
            this.method_25302(matrixStack, 38, 131, 180, 194, 10, 10);
            this.method_25302(matrixStack, 82, 159, 180, 194, 17, 17);
        }
        RenderUtils.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
        this.method_25302(matrixStack, 82, 159, 202, 194 - this.mRotation.ordinal() * 20, 17, 17);
        ProjectorScreen.drawCenteredStringWithoutShadow(matrixStack, this.field_22793, IMAGE_TEXT, (float)this.imageWidth / 2.0f, -14.0f);
        this.field_22793.method_1729(matrixStack, this.propIndex + 1 + "/" + this.props.size(), (float)this.imageWidth / 2.0f - 50.0f, 31.0f, -12566464);
        ProjectorScreen.drawCenteredStringWithoutShadow(matrixStack, this.field_22793, OTHERS_TEXT, (float)this.imageWidth / 2.0f, 112.0f);
        int offsetX = mouseX - (this.field_22789 - this.imageWidth) / 2;
        int offsetY = mouseY - (this.field_22790 - this.imageHeight) / 2;
        if (offsetX >= 9 && offsetY >= 27 && offsetX < 27 && offsetY < 46) {
            this.method_25424(matrixStack, switch (this.mSourceType) {
                case SourceType.ResourceID -> ID_TEXT;
                case SourceType.ContainerBlock -> CONTAINER_TEXT;
                default -> URL_TEXT;
            }, offsetX, offsetY);
        } else if (offsetX >= 149 && offsetY >= 7 && offsetX < 167 && offsetY < 26) {
            if (this.mSourceType != SourceType.ContainerBlock) {
                this.method_25424(matrixStack, EXPORT_TEXT, offsetX, offsetY);
            }
        } else if (offsetX >= 34 && offsetY >= 153 && offsetX < 52 && offsetY < 172) {
            this.method_25424(matrixStack, COLOR_TEXT, offsetX, offsetY);
        } else if (offsetX >= 9 && offsetY >= 55 && offsetX < 18 && offsetY < 64) {
            if (this.mLastScreen.field_22764) {
                this.method_25424(matrixStack, LAST_SCREEN_TEXT, offsetX, offsetY);
            }
        } else if (offsetX >= 142 && offsetY >= 55 && offsetX < 151 && offsetY < 64) {
            if (this.mRemoveScreen.field_22764) {
                this.method_25424(matrixStack, REMOVE_SCREEN_TEXT, offsetX, offsetY);
            }
        } else if (offsetX >= 157 && offsetY >= 55 && offsetX < 166 && offsetY < 64) {
            if (this.mNewScreen.field_22764) {
                this.method_25424(matrixStack, NEW_SCREEN_TEXT, offsetX, offsetY);
            } else if (this.mNextScreen.field_22764) {
                this.method_25424(matrixStack, NEXT_SCREEN_TEXT, offsetX, offsetY);
            }
        } else if (offsetX >= 9 && offsetY >= 66 && offsetX < 27 && offsetY < 85) {
            this.method_25424(matrixStack, WIDTH_TEXT, offsetX, offsetY);
        } else if (offsetX >= 90 && offsetY >= 66 && offsetX < 108 && offsetY < 85) {
            this.method_25424(matrixStack, HEIGHT_TEXT, offsetX, offsetY);
        } else if (offsetX >= 9 && offsetY >= 88 && offsetX < 27 && offsetY < 107) {
            this.method_25424(matrixStack, ANGLE_X_TEXT, offsetX, offsetY);
        } else if (offsetX >= 63 && offsetY >= 88 && offsetX < 81 && offsetY < 107) {
            this.method_25424(matrixStack, ANGLE_Y_TEXT, offsetX, offsetY);
        } else if (offsetX >= 117 && offsetY >= 88 && offsetX < 135 && offsetY < 107) {
            this.method_25424(matrixStack, ANGLE_Z_TEXT, offsetX, offsetY);
        } else if (offsetX >= 9 && offsetY >= 110 && offsetX < 27 && offsetY < 129) {
            this.method_25424(matrixStack, OFFSET_X_TEXT, offsetX, offsetY);
        } else if (offsetX >= 63 && offsetY >= 110 && offsetX < 81 && offsetY < 129) {
            this.method_25424(matrixStack, OFFSET_Y_TEXT, offsetX, offsetY);
        } else if (offsetX >= 117 && offsetY >= 110 && offsetX < 135 && offsetY < 129) {
            this.method_25424(matrixStack, OFFSET_Z_TEXT, offsetX, offsetY);
        } else if (offsetX >= 117 && offsetY >= 153 && offsetX < 135 && offsetY < 172) {
            this.method_25424(matrixStack, FLIP_TEXT, offsetX, offsetY);
        } else if (offsetX >= 142 && offsetY >= 153 && offsetX < 160 && offsetY < 172) {
            this.method_25424(matrixStack, ROTATE_TEXT, offsetX, offsetY);
        } else if (offsetX >= 9 && offsetY >= 153 && offsetX < 27 && offsetY < 172) {
            this.method_25424(matrixStack, SINGLE_DOUBLE_SIDED_TEXT, offsetX, offsetY);
        }
    }

    private static void drawCenteredStringWithoutShadow(class_4587 stack, class_327 renderer, class_2561 string, float x, float y) {
        renderer.method_30883(stack, string, x - (float)renderer.method_27525((class_5348)string) / 2.0f, y, 0x404040);
    }

    private static float parseFloat(String text) {
        return (float)Math.round(Float.parseFloat(text) * 10000.0f) / 10000.0f;
    }

    private static String floatToString(float value) {
        return String.valueOf((float)Math.round(value * 10000.0f) / 10000.0f);
    }

    private static class_1160 relativeToAbsolute(class_1160 relatedOffset, class_241 size, ProjectorBlock.InternalRotation rotation) {
        class_1162 center = new class_1162(0.5f * size.field_1343, 0.0f, 0.5f * size.field_1342, 1.0f);
        center.method_22674(class_1159.method_24021((float)relatedOffset.method_4943(), (float)(-relatedOffset.method_4947()), (float)relatedOffset.method_4945()));
        center.method_22674(class_1159.method_24021((float)-0.5f, (float)0.0f, (float)(0.5f - size.field_1342)));
        rotation.transform(center);
        return new class_1160(center.method_4953(), center.method_4956(), center.method_4957());
    }

    private static class_1160 absoluteToRelative(class_1160 absoluteOffset, class_241 size, ProjectorBlock.InternalRotation rotation) {
        class_1162 center = new class_1162(absoluteOffset);
        rotation.invert().transform(center);
        center.method_22674(class_1159.method_24021((float)0.5f, (float)0.0f, (float)(-0.5f + size.field_1342)));
        center.method_22674(class_1159.method_24021((float)(-0.5f * size.field_1343), (float)0.0f, (float)(-0.5f * size.field_1342)));
        return new class_1160(center.method_4953(), center.method_4957(), -center.method_4956());
    }
}

