/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.slides.texture;

import dev.matrixlab.webp4j.NativeWebP;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Objects;
import net.minecraft.class_1011;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.system.MemoryUtil;
import org.teacon.slides.Slideshow;

public final class WebPDecoder {
    private static boolean initialized = false;
    private static NativeWebP nativeWebP;
    private static boolean disabled;

    public static void init() {
        if (initialized) {
            return;
        }
        try {
            nativeWebP = new NativeWebP();
            disabled = false;
        }
        catch (ExceptionInInitializerError e) {
            Slideshow.LOGGER.warn("Failed to load WebP native library, WebPDecoder is disabled! ", (Throwable)e);
        }
        catch (Throwable e) {
            Slideshow.LOGGER.warn("WebPDecoder is disabled! ", e);
        }
        initialized = true;
    }

    public static boolean checkMagic(byte @NotNull [] buf) {
        if (buf.length >= 12) {
            ByteBuffer wr = ByteBuffer.wrap(buf).order(ByteOrder.LITTLE_ENDIAN);
            boolean riff = wr.getInt() == 1179011410;
            boolean size = wr.getInt() == buf.length - 8;
            boolean webp = wr.getInt() == 1346520407;
            boolean vp8_ = ArrayUtils.contains((int[])new int[]{1480085590, 1278758998, 540561494}, (int)wr.getInt());
            return riff && size && webp && vp8_;
        }
        return false;
    }

    public static class_1011 toNativeImage(byte @NotNull [] buf) {
        if (disabled) {
            return null;
        }
        try {
            int[] dimensions = new int[2];
            byte[] output = WebPDecoder.decodeImage(buf, dimensions);
            class_1011 nativeImage = new class_1011(dimensions[0], dimensions[1], false);
            int size = dimensions[0] * dimensions[1] * 4;
            ByteBuffer nativeBuffer = MemoryUtil.memByteBuffer((long)nativeImage.field_4988, (int)Math.toIntExact(size));
            Objects.requireNonNull(nativeBuffer).put(output);
            return nativeImage;
        }
        catch (Throwable e) {
            return null;
        }
    }

    private static byte[] decodeImage(byte[] webPData, int[] dimensions) throws IOException {
        if (webPData == null || webPData.length == 0) {
            throw new IllegalArgumentException("The input WebP data cannot be null or empty.");
        }
        boolean success0 = nativeWebP.getInfo(webPData, dimensions);
        if (!success0) {
            throw new IOException("Failed to retrieve WebP image information.");
        }
        int height = dimensions[1];
        int width = dimensions[0];
        int outputStride = width * 4;
        byte[] outputBuffer = new byte[height * outputStride];
        boolean success1 = nativeWebP.decodeRGBAInto(webPData, outputBuffer, outputStride);
        if (!success1) {
            throw new IOException("Failed to decode WebP data into RGB buffer.");
        }
        return outputBuffer;
    }

    static {
        disabled = true;
        WebPDecoder.init();
    }
}

