/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.slides.renderer;

import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.teacon.slides.renderer.SlideRenderType;
import org.teacon.slides.texture.TextureProvider;

public abstract class Slide
implements AutoCloseable {
    public abstract void render(@NotNull class_4597 var1, @NotNull Matrix4f var2, @NotNull Matrix3f var3, float var4, float var5, int var6, int var7, int var8, boolean var9, boolean var10, long var11, float var13);

    @Override
    public void close() {
    }

    public int getWidth() {
        return 0;
    }

    public int getHeight() {
        return 0;
    }

    public int getGPUMemorySize() {
        return this.getWidth() * this.getHeight() << 2;
    }

    @NotNull
    static Slide make(TextureProvider texture) {
        return new Image(texture);
    }

    public static Slide empty() {
        return Icon.DEFAULT_EMPTY;
    }

    public static Slide failed() {
        return Icon.DEFAULT_FAILED;
    }

    public static Slide loading() {
        return Icon.DEFAULT_LOADING;
    }

    public static final class Image
    extends Slide {
        private final TextureProvider mTexture;

        private Image(TextureProvider texture) {
            this.mTexture = texture;
        }

        @Override
        public void render(@NotNull class_4597 source, @NotNull Matrix4f matrix, @NotNull Matrix3f normal, float width, float height, int color, int light, int overlay, boolean front, boolean back, long tick, float partialTick) {
            int red = color >> 16 & 0xFF;
            int green = color >> 8 & 0xFF;
            int blue = color & 0xFF;
            int alpha = color >>> 24;
            class_4588 builder = source.getBuffer((class_1921)this.mTexture.updateAndGet(tick, partialTick));
            if (front) {
                builder.method_22918(matrix, 0.0f, 0.0052083335f, 1.0f).method_1336(red, green, blue, alpha).method_22913(0.0f, 1.0f).method_22916(light).method_23763(normal, 0.0f, 1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, 1.0f, 0.0052083335f, 1.0f).method_1336(red, green, blue, alpha).method_22913(1.0f, 1.0f).method_22916(light).method_23763(normal, 0.0f, 1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, 1.0f, 0.0052083335f, 0.0f).method_1336(red, green, blue, alpha).method_22913(1.0f, 0.0f).method_22916(light).method_23763(normal, 0.0f, 1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, 0.0f, 0.0052083335f, 0.0f).method_1336(red, green, blue, alpha).method_22913(0.0f, 0.0f).method_22916(light).method_23763(normal, 0.0f, 1.0f, 0.0f).method_1344();
            }
            if (back) {
                builder.method_22918(matrix, 0.0f, -0.00390625f, 0.0f).method_1336(red, green, blue, alpha).method_22913(0.0f, 0.0f).method_22916(light).method_23763(normal, 0.0f, -1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, 1.0f, -0.00390625f, 0.0f).method_1336(red, green, blue, alpha).method_22913(1.0f, 0.0f).method_22916(light).method_23763(normal, 0.0f, -1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, 1.0f, -0.00390625f, 1.0f).method_1336(red, green, blue, alpha).method_22913(1.0f, 1.0f).method_22916(light).method_23763(normal, 0.0f, -1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, 0.0f, -0.00390625f, 1.0f).method_1336(red, green, blue, alpha).method_22913(0.0f, 1.0f).method_22916(light).method_23763(normal, 0.0f, -1.0f, 0.0f).method_1344();
            }
        }

        @Override
        public void close() {
            this.mTexture.close();
        }

        @Override
        public int getWidth() {
            return this.mTexture.getWidth();
        }

        @Override
        public int getHeight() {
            return this.mTexture.getHeight();
        }

        public String toString() {
            return "ImageSlide{texture=" + this.mTexture + "}";
        }
    }

    public static final class Icon
    extends Slide {
        private static final class_2960 BACKGROUND = class_2960.method_43902((String)"slide_show", (String)"textures/gui/slide_default.png");
        private static final class_2960 ICON_EMPTY = class_2960.method_43902((String)"slide_show", (String)"textures/gui/slide_icon_empty.png");
        private static final class_2960 ICON_FAILED = class_2960.method_43902((String)"slide_show", (String)"textures/gui/slide_icon_failed.png");
        private static final class_2960 ICON_LOADING = class_2960.method_43902((String)"slide_show", (String)"textures/gui/slide_icon_loading.png");
        private static final class_1921 sBackgroundRenderType = new SlideRenderType(BACKGROUND);
        private static final Icon DEFAULT_EMPTY = new Icon(ICON_EMPTY);
        private static final Icon DEFAULT_FAILED = new Icon(ICON_FAILED);
        private static final Icon DEFAULT_LOADING = new Icon(ICON_LOADING);
        private final class_1921 mIconRenderType;

        private Icon(class_2960 icon) {
            this.mIconRenderType = new SlideRenderType(icon);
        }

        private static float getFactor(float width, float height) {
            return Math.min(width, height) / (24.0f + class_3532.method_23278((float)(0.00390625f / (width * width + height * height))));
        }

        @Override
        public void render(@NotNull class_4597 source, @NotNull Matrix4f matrix, @NotNull Matrix3f normal, float width, float height, int color, int light, int overlay, boolean front, boolean back, long tick, float partialTick) {
            int alpha;
            if ((front || back) && (alpha = color >>> 24) > 0) {
                float factor = Icon.getFactor(width, height);
                int xSize = Math.round(width / factor);
                int ySize = Math.round(height / factor);
                this.renderIcon(source, matrix, normal, alpha, light, xSize, ySize, front, back);
                this.renderBackground(source, matrix, normal, alpha, light, xSize, ySize, front, back);
            }
        }

        private void renderIcon(@NotNull class_4597 source, Matrix4f matrix, Matrix3f normal, int alpha, int light, int xSize, int ySize, boolean front, boolean back) {
            class_4588 builder = source.getBuffer(this.mIconRenderType);
            float x1 = (1.0f - 19.0f / (float)xSize) / 2.0f;
            float x2 = 1.0f - x1;
            float y1 = (1.0f - 16.0f / (float)ySize) / 2.0f;
            float y2 = 1.0f - y1;
            if (front) {
                builder.method_22918(matrix, x1, 0.0078125f, y2).method_1336(255, 255, 255, alpha).method_22913(0.0f, 1.0f).method_22916(light).method_23763(normal, 0.0f, 1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, x2, 0.0078125f, y2).method_1336(255, 255, 255, alpha).method_22913(1.0f, 1.0f).method_22916(light).method_23763(normal, 0.0f, 1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, x2, 0.0078125f, y1).method_1336(255, 255, 255, alpha).method_22913(1.0f, 0.0f).method_22916(light).method_23763(normal, 0.0f, 1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, x1, 0.0078125f, y1).method_1336(255, 255, 255, alpha).method_22913(0.0f, 0.0f).method_22916(light).method_23763(normal, 0.0f, 1.0f, 0.0f).method_1344();
            }
            if (back) {
                builder.method_22918(matrix, x1, -0.0078125f, y1).method_1336(255, 255, 255, alpha).method_22913(0.0f, 0.0f).method_22916(light).method_23763(normal, 0.0f, -1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, x2, -0.0078125f, y1).method_1336(255, 255, 255, alpha).method_22913(1.0f, 0.0f).method_22916(light).method_23763(normal, 0.0f, -1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, x2, -0.0078125f, y2).method_1336(255, 255, 255, alpha).method_22913(1.0f, 1.0f).method_22916(light).method_23763(normal, 0.0f, -1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, x1, -0.0078125f, y2).method_1336(255, 255, 255, alpha).method_22913(0.0f, 1.0f).method_22916(light).method_23763(normal, 0.0f, -1.0f, 0.0f).method_1344();
            }
        }

        private void renderBackground(@NotNull class_4597 source, Matrix4f matrix, Matrix3f normal, int alpha, int light, int xSize, int ySize, boolean front, boolean back) {
            class_4588 builder = source.getBuffer(sBackgroundRenderType);
            float u1 = 0.47368422f;
            float u2 = 0.5263158f;
            float x1 = 9.0f / (float)xSize;
            float x2 = 1.0f - x1;
            float y1 = 9.0f / (float)ySize;
            float y2 = 1.0f - y1;
            if (front) {
                builder.method_22918(matrix, 0.0f, 0.00390625f, y1).method_1336(255, 255, 255, alpha).method_22913(0.0f, u1).method_22916(light).method_23763(normal, 0.0f, 1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, x1, 0.00390625f, y1).method_1336(255, 255, 255, alpha).method_22913(u1, u1).method_22916(light).method_23763(normal, 0.0f, 1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, x1, 0.00390625f, 0.0f).method_1336(255, 255, 255, alpha).method_22913(u1, 0.0f).method_22916(light).method_23763(normal, 0.0f, 1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, 0.0f, 0.00390625f, 0.0f).method_1336(255, 255, 255, alpha).method_22913(0.0f, 0.0f).method_22916(light).method_23763(normal, 0.0f, 1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, 0.0f, 0.00390625f, y2).method_1336(255, 255, 255, alpha).method_22913(0.0f, u2).method_22916(light).method_23763(normal, 0.0f, 1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, x1, 0.00390625f, y2).method_1336(255, 255, 255, alpha).method_22913(u1, u2).method_22916(light).method_23763(normal, 0.0f, 1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, x1, 0.00390625f, y1).method_1336(255, 255, 255, alpha).method_22913(u1, u1).method_22916(light).method_23763(normal, 0.0f, 1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, 0.0f, 0.00390625f, y1).method_1336(255, 255, 255, alpha).method_22913(0.0f, u1).method_22916(light).method_23763(normal, 0.0f, 1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, 0.0f, 0.00390625f, 1.0f).method_1336(255, 255, 255, alpha).method_22913(0.0f, 1.0f).method_22916(light).method_23763(normal, 0.0f, 1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, x1, 0.00390625f, 1.0f).method_1336(255, 255, 255, alpha).method_22913(u1, 1.0f).method_22916(light).method_23763(normal, 0.0f, 1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, x1, 0.00390625f, y2).method_1336(255, 255, 255, alpha).method_22913(u1, u2).method_22916(light).method_23763(normal, 0.0f, 1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, 0.0f, 0.00390625f, y2).method_1336(255, 255, 255, alpha).method_22913(0.0f, u2).method_22916(light).method_23763(normal, 0.0f, 1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, x1, 0.00390625f, y1).method_1336(255, 255, 255, alpha).method_22913(u1, u1).method_22916(light).method_23763(normal, 0.0f, 1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, x2, 0.00390625f, y1).method_1336(255, 255, 255, alpha).method_22913(u2, u1).method_22916(light).method_23763(normal, 0.0f, 1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, x2, 0.00390625f, 0.0f).method_1336(255, 255, 255, alpha).method_22913(u2, 0.0f).method_22916(light).method_23763(normal, 0.0f, 1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, x1, 0.00390625f, 0.0f).method_1336(255, 255, 255, alpha).method_22913(u1, 0.0f).method_22916(light).method_23763(normal, 0.0f, 1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, x1, 0.00390625f, y2).method_1336(255, 255, 255, alpha).method_22913(u1, u2).method_22916(light).method_23763(normal, 0.0f, 1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, x2, 0.00390625f, y2).method_1336(255, 255, 255, alpha).method_22913(u2, u2).method_22916(light).method_23763(normal, 0.0f, 1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, x2, 0.00390625f, y1).method_1336(255, 255, 255, alpha).method_22913(u2, u1).method_22916(light).method_23763(normal, 0.0f, 1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, x1, 0.00390625f, y1).method_1336(255, 255, 255, alpha).method_22913(u1, u1).method_22916(light).method_23763(normal, 0.0f, 1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, x1, 0.00390625f, 1.0f).method_1336(255, 255, 255, alpha).method_22913(u1, 1.0f).method_22916(light).method_23763(normal, 0.0f, 1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, x2, 0.00390625f, 1.0f).method_1336(255, 255, 255, alpha).method_22913(u2, 1.0f).method_22916(light).method_23763(normal, 0.0f, 1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, x2, 0.00390625f, y2).method_1336(255, 255, 255, alpha).method_22913(u2, u2).method_22916(light).method_23763(normal, 0.0f, 1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, x1, 0.00390625f, y2).method_1336(255, 255, 255, alpha).method_22913(u1, u2).method_22916(light).method_23763(normal, 0.0f, 1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, x2, 0.00390625f, y1).method_1336(255, 255, 255, alpha).method_22913(u2, u1).method_22916(light).method_23763(normal, 0.0f, 1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, 1.0f, 0.00390625f, y1).method_1336(255, 255, 255, alpha).method_22913(1.0f, u1).method_22916(light).method_23763(normal, 0.0f, 1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, 1.0f, 0.00390625f, 0.0f).method_1336(255, 255, 255, alpha).method_22913(1.0f, 0.0f).method_22916(light).method_23763(normal, 0.0f, 1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, x2, 0.00390625f, 0.0f).method_1336(255, 255, 255, alpha).method_22913(u2, 0.0f).method_22916(light).method_23763(normal, 0.0f, 1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, x2, 0.00390625f, y2).method_1336(255, 255, 255, alpha).method_22913(u2, u2).method_22916(light).method_23763(normal, 0.0f, 1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, 1.0f, 0.00390625f, y2).method_1336(255, 255, 255, alpha).method_22913(1.0f, u2).method_22916(light).method_23763(normal, 0.0f, 1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, 1.0f, 0.00390625f, y1).method_1336(255, 255, 255, alpha).method_22913(1.0f, u1).method_22916(light).method_23763(normal, 0.0f, 1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, x2, 0.00390625f, y1).method_1336(255, 255, 255, alpha).method_22913(u2, u1).method_22916(light).method_23763(normal, 0.0f, 1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, x2, 0.00390625f, 1.0f).method_1336(255, 255, 255, alpha).method_22913(u2, 1.0f).method_22916(light).method_23763(normal, 0.0f, 1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, 1.0f, 0.00390625f, 1.0f).method_1336(255, 255, 255, alpha).method_22913(1.0f, 1.0f).method_22916(light).method_23763(normal, 0.0f, 1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, 1.0f, 0.00390625f, y2).method_1336(255, 255, 255, alpha).method_22913(1.0f, u2).method_22916(light).method_23763(normal, 0.0f, 1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, x2, 0.00390625f, y2).method_1336(255, 255, 255, alpha).method_22913(u2, u2).method_22916(light).method_23763(normal, 0.0f, 1.0f, 0.0f).method_1344();
            }
            if (back) {
                builder.method_22918(matrix, 0.0f, -0.00390625f, 0.0f).method_1336(255, 255, 255, alpha).method_22913(0.0f, 0.0f).method_22916(light).method_23763(normal, 0.0f, -1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, x1, -0.00390625f, 0.0f).method_1336(255, 255, 255, alpha).method_22913(u1, 0.0f).method_22916(light).method_23763(normal, 0.0f, -1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, x1, -0.00390625f, y1).method_1336(255, 255, 255, alpha).method_22913(u1, u1).method_22916(light).method_23763(normal, 0.0f, -1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, 0.0f, -0.00390625f, y1).method_1336(255, 255, 255, alpha).method_22913(0.0f, u1).method_22916(light).method_23763(normal, 0.0f, -1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, 0.0f, -0.00390625f, y1).method_1336(255, 255, 255, alpha).method_22913(0.0f, u1).method_22916(light).method_23763(normal, 0.0f, -1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, x1, -0.00390625f, y1).method_1336(255, 255, 255, alpha).method_22913(u1, u1).method_22916(light).method_23763(normal, 0.0f, -1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, x1, -0.00390625f, y2).method_1336(255, 255, 255, alpha).method_22913(u1, u2).method_22916(light).method_23763(normal, 0.0f, -1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, 0.0f, -0.00390625f, y2).method_1336(255, 255, 255, alpha).method_22913(0.0f, u2).method_22916(light).method_23763(normal, 0.0f, -1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, 0.0f, -0.00390625f, y2).method_1336(255, 255, 255, alpha).method_22913(0.0f, u2).method_22916(light).method_23763(normal, 0.0f, -1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, x1, -0.00390625f, y2).method_1336(255, 255, 255, alpha).method_22913(u1, u2).method_22916(light).method_23763(normal, 0.0f, -1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, x1, -0.00390625f, 1.0f).method_1336(255, 255, 255, alpha).method_22913(u1, 1.0f).method_22916(light).method_23763(normal, 0.0f, -1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, 0.0f, -0.00390625f, 1.0f).method_1336(255, 255, 255, alpha).method_22913(0.0f, 1.0f).method_22916(light).method_23763(normal, 0.0f, -1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, x1, -0.00390625f, 0.0f).method_1336(255, 255, 255, alpha).method_22913(u1, 0.0f).method_22916(light).method_23763(normal, 0.0f, -1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, x2, -0.00390625f, 0.0f).method_1336(255, 255, 255, alpha).method_22913(u2, 0.0f).method_22916(light).method_23763(normal, 0.0f, -1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, x2, -0.00390625f, y1).method_1336(255, 255, 255, alpha).method_22913(u2, u1).method_22916(light).method_23763(normal, 0.0f, -1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, x1, -0.00390625f, y1).method_1336(255, 255, 255, alpha).method_22913(u1, u1).method_22916(light).method_23763(normal, 0.0f, -1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, x1, -0.00390625f, y1).method_1336(255, 255, 255, alpha).method_22913(u1, u1).method_22916(light).method_23763(normal, 0.0f, -1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, x2, -0.00390625f, y1).method_1336(255, 255, 255, alpha).method_22913(u2, u1).method_22916(light).method_23763(normal, 0.0f, -1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, x2, -0.00390625f, y2).method_1336(255, 255, 255, alpha).method_22913(u2, u2).method_22916(light).method_23763(normal, 0.0f, -1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, x1, -0.00390625f, y2).method_1336(255, 255, 255, alpha).method_22913(u1, u2).method_22916(light).method_23763(normal, 0.0f, -1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, x1, -0.00390625f, y2).method_1336(255, 255, 255, alpha).method_22913(u1, u2).method_22916(light).method_23763(normal, 0.0f, -1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, x2, -0.00390625f, y2).method_1336(255, 255, 255, alpha).method_22913(u2, u2).method_22916(light).method_23763(normal, 0.0f, -1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, x2, -0.00390625f, 1.0f).method_1336(255, 255, 255, alpha).method_22913(u2, 1.0f).method_22916(light).method_23763(normal, 0.0f, -1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, x1, -0.00390625f, 1.0f).method_1336(255, 255, 255, alpha).method_22913(u1, 1.0f).method_22916(light).method_23763(normal, 0.0f, -1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, x2, -0.00390625f, 0.0f).method_1336(255, 255, 255, alpha).method_22913(u2, 0.0f).method_22916(light).method_23763(normal, 0.0f, -1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, 1.0f, -0.00390625f, 0.0f).method_1336(255, 255, 255, alpha).method_22913(1.0f, 0.0f).method_22916(light).method_23763(normal, 0.0f, -1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, 1.0f, -0.00390625f, y1).method_1336(255, 255, 255, alpha).method_22913(1.0f, u1).method_22916(light).method_23763(normal, 0.0f, -1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, x2, -0.00390625f, y1).method_1336(255, 255, 255, alpha).method_22913(u2, u1).method_22916(light).method_23763(normal, 0.0f, -1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, x2, -0.00390625f, y1).method_1336(255, 255, 255, alpha).method_22913(u2, u1).method_22916(light).method_23763(normal, 0.0f, -1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, 1.0f, -0.00390625f, y1).method_1336(255, 255, 255, alpha).method_22913(1.0f, u1).method_22916(light).method_23763(normal, 0.0f, -1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, 1.0f, -0.00390625f, y2).method_1336(255, 255, 255, alpha).method_22913(1.0f, u2).method_22916(light).method_23763(normal, 0.0f, -1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, x2, -0.00390625f, y2).method_1336(255, 255, 255, alpha).method_22913(u2, u2).method_22916(light).method_23763(normal, 0.0f, -1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, x2, -0.00390625f, y2).method_1336(255, 255, 255, alpha).method_22913(u2, u2).method_22916(light).method_23763(normal, 0.0f, -1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, 1.0f, -0.00390625f, y2).method_1336(255, 255, 255, alpha).method_22913(1.0f, u2).method_22916(light).method_23763(normal, 0.0f, -1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, 1.0f, -0.00390625f, 1.0f).method_1336(255, 255, 255, alpha).method_22913(1.0f, 1.0f).method_22916(light).method_23763(normal, 0.0f, -1.0f, 0.0f).method_1344();
                builder.method_22918(matrix, x2, -0.00390625f, 1.0f).method_1336(255, 255, 255, alpha).method_22913(u2, 1.0f).method_22916(light).method_23763(normal, 0.0f, -1.0f, 0.0f).method_1344();
            }
        }

        public String toString() {
            return "IconSlide{iconRenderType=" + this.mIconRenderType + "}";
        }
    }
}

