/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.slides.network;

import com.mojang.authlib.GameProfile;
import java.util.function.Supplier;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.fml.network.NetworkEvent;
import org.teacon.slides.Slideshow;
import org.teacon.slides.projector.ProjectorBlock;
import org.teacon.slides.util.Utilities;

public class ProjectorExportC2SPacket {
    private final boolean mFromID;
    private final String mLocation;

    public ProjectorExportC2SPacket(boolean fromID, String location) {
        this.mFromID = fromID;
        this.mLocation = location;
    }

    public ProjectorExportC2SPacket(PacketBuffer buf) {
        this.mFromID = buf.readBoolean();
        this.mLocation = buf.func_218666_n();
    }

    public void write(PacketBuffer buffer) {
        buffer.writeBoolean(this.mFromID);
        buffer.func_180714_a(this.mLocation);
    }

    public static void handle(ProjectorExportC2SPacket projectorExportPacket, Supplier<NetworkEvent.Context> context) {
        ServerPlayerEntity serverPlayer = context.get().getSender();
        if (serverPlayer == null) {
            context.get().setPacketHandled(true);
            return;
        }
        context.get().enqueueWork(() -> {
            if (ProjectorExportC2SPacket.giveImageItem(serverPlayer, projectorExportPacket.mFromID, projectorExportPacket.mLocation)) {
                return;
            }
            GameProfile profile = serverPlayer.func_146103_bH();
            Slideshow.LOGGER.debug(Utilities.MARKER, "Received illegal packet for projector export: player = {}", (Object)profile);
        });
        context.get().setPacketHandled(true);
    }

    public static boolean giveImageItem(ServerPlayerEntity serverPlayer, boolean fromID, String location) {
        if (ProjectorBlock.hasProjectorPermission(serverPlayer)) {
            ItemStack itemStack = new ItemStack((IItemProvider)Slideshow.IMAGE_ITEM.get(), 1);
            itemStack.func_77983_a("from_id", (INBT)ByteNBT.func_229672_a_((boolean)fromID));
            itemStack.func_77983_a("location", (INBT)StringNBT.func_229705_a_((String)location));
            boolean bl = serverPlayer.field_71071_by.func_70441_a(itemStack);
            if (bl && itemStack.func_190926_b()) {
                itemStack.func_190920_e(1);
                ItemEntity itemEntity = serverPlayer.func_71019_a(itemStack, false);
                if (itemEntity != null) {
                    itemEntity.func_174870_v();
                }
                serverPlayer.func_71121_q().func_184148_a(null, serverPlayer.func_226277_ct_(), serverPlayer.func_226278_cu_(), serverPlayer.func_226281_cx_(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((serverPlayer.func_70681_au().nextFloat() - serverPlayer.func_70681_au().nextFloat()) * 0.7f + 1.0f) * 2.0f);
                serverPlayer.field_71069_bz.func_75142_b();
            } else {
                ItemEntity itemEntity = serverPlayer.func_71019_a(itemStack, false);
                if (itemEntity != null) {
                    itemEntity.func_174868_q();
                    itemEntity.func_200217_b(serverPlayer.func_110124_au());
                }
            }
            return true;
        }
        return false;
    }
}

