/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.slides.projector;

import io.netty.buffer.Unpooled;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.HopperTileEntity;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.PacketDistributor;
import org.teacon.slides.Slideshow;
import org.teacon.slides.item.ImageItem;
import org.teacon.slides.network.Network;
import org.teacon.slides.network.ProjectorImageInfoS2CPacket;
import org.teacon.slides.projector.ProjectorScreenHandler;
import org.teacon.slides.projector.SourceType;
import org.teacon.slides.util.Text;

public final class ProjectorBlockEntity
extends TileEntity
implements ITickableTileEntity,
INamedContainerProvider {
    public SourceType mSourceType = SourceType.URL;
    public String mLocation = "";
    public int mColor = -1;
    public float mWidth = 1.0f;
    public float mHeight = 1.0f;
    public float mOffsetX = 0.0f;
    public float mOffsetY = 0.0f;
    public float mOffsetZ = 0.0f;
    public boolean mDoubleSided = true;
    public IInventory mContainer = null;
    public int scanIndex = -1;
    public boolean needInitContainer = false;
    public boolean needHandleReadImage = false;
    public boolean flipBack = false;
    public boolean mCFromID = false;
    public String mCLocation = "";
    public boolean mCNextFromID = false;
    public String mCNextLocation = "";

    public ProjectorBlockEntity() {
        super((TileEntityType)Slideshow.PROJECTOR_BLOCK_ENTITY.get());
    }

    private boolean tryReadImageItem(ItemStack item, boolean next) {
        if (item.func_77973_b() instanceof ImageItem && item.func_77942_o() && item.func_77978_p().func_74764_b("location")) {
            if (next) {
                this.mCNextFromID = item.func_77978_p().func_74767_n("from_id");
                this.mCNextLocation = item.func_77978_p().func_74779_i("location");
            } else {
                this.mCFromID = item.func_77978_p().func_74767_n("from_id");
                this.mCLocation = item.func_77978_p().func_74779_i("location");
            }
            return true;
        }
        return false;
    }

    private void handleReadImage(boolean back) {
        ItemStack item;
        int i;
        int j;
        int size = this.mContainer.func_70302_i_();
        if (size <= 0) {
            return;
        }
        int start = back ? size + this.scanIndex - 1 : this.scanIndex + 1;
        int end = back ? this.scanIndex - 1 : size + this.scanIndex + 1;
        boolean found = false;
        if (back) {
            for (j = start; j > end; --j) {
                i = j % size;
                item = this.mContainer.func_70301_a(i);
                if (!this.tryReadImageItem(item, false)) continue;
                this.scanIndex = i;
                found = true;
                start = i + 1;
                end = start + size;
                break;
            }
        } else {
            for (j = start; j < end; ++j) {
                i = j % size;
                item = this.mContainer.func_70301_a(i);
                if (!this.tryReadImageItem(item, false)) continue;
                this.scanIndex = i;
                found = true;
                start = i + 1;
                end = start + size;
                break;
            }
        }
        if (!found) {
            this.mCNextLocation = "";
            return;
        }
        for (j = start; j < end; ++j) {
            i = j % size;
            item = this.mContainer.func_70301_a(i);
            if (!this.tryReadImageItem(item, true)) continue;
            return;
        }
    }

    public boolean canFlip() {
        return this.mSourceType == SourceType.ContainerBlock && this.mContainer != null;
    }

    public boolean getFromID() {
        if (this.mSourceType != SourceType.ContainerBlock) {
            return this.mSourceType == SourceType.ResourceID;
        }
        return this.mCFromID;
    }

    public String getLocation() {
        if (this.mSourceType != SourceType.ContainerBlock) {
            return this.mLocation;
        }
        return this.mCLocation;
    }

    public CompoundNBT func_189515_b(CompoundNBT compoundTag) {
        this.saveCompound(compoundTag);
        return super.func_189515_b(compoundTag);
    }

    public void func_230337_a_(BlockState blockState, CompoundNBT compoundTag) {
        this.loadCompound(compoundTag);
        super.func_230337_a_(blockState, compoundTag);
    }

    public void saveCompound(CompoundNBT compoundTag) {
        switch (this.mSourceType) {
            case ResourceID: {
                compoundTag.func_74778_a("SourceType", "resource_id");
                break;
            }
            case ContainerBlock: {
                compoundTag.func_74778_a("SourceType", "container");
                break;
            }
            default: {
                compoundTag.func_74778_a("SourceType", "url");
            }
        }
        compoundTag.func_74778_a("ImageLocation", this.mLocation);
        compoundTag.func_74768_a("Color", this.mColor);
        compoundTag.func_74776_a("Width", this.mWidth);
        compoundTag.func_74776_a("Height", this.mHeight);
        compoundTag.func_74776_a("OffsetX", this.mOffsetX);
        compoundTag.func_74776_a("OffsetY", this.mOffsetY);
        compoundTag.func_74776_a("OffsetZ", this.mOffsetZ);
        compoundTag.func_74757_a("DoubleSided", this.mDoubleSided);
        compoundTag.func_74768_a("ScanIndex", this.scanIndex);
        compoundTag.func_74757_a("CFromID", this.mCFromID);
        compoundTag.func_74778_a("CLocation", this.mCLocation);
        compoundTag.func_74757_a("CNextFromID", this.mCNextFromID);
        compoundTag.func_74778_a("CNextLocation", this.mCNextLocation);
    }

    public void loadCompound(CompoundNBT compoundTag) {
        switch (compoundTag.func_74779_i("SourceType")) {
            case "resource_id": {
                this.mSourceType = SourceType.ResourceID;
                break;
            }
            case "container": {
                this.mSourceType = SourceType.ContainerBlock;
                break;
            }
            default: {
                this.mSourceType = SourceType.URL;
            }
        }
        this.mLocation = compoundTag.func_74779_i("ImageLocation");
        this.mColor = compoundTag.func_74762_e("Color");
        this.mWidth = compoundTag.func_74760_g("Width");
        this.mHeight = compoundTag.func_74760_g("Height");
        this.mOffsetX = compoundTag.func_74760_g("OffsetX");
        this.mOffsetY = compoundTag.func_74760_g("OffsetY");
        this.mOffsetZ = compoundTag.func_74760_g("OffsetZ");
        this.mDoubleSided = compoundTag.func_74767_n("DoubleSided");
        this.scanIndex = compoundTag.func_74762_e("ScanIndex");
        this.mCFromID = compoundTag.func_74767_n("CFromID");
        this.mCLocation = compoundTag.func_74779_i("CLocation");
        this.mCNextFromID = compoundTag.func_74767_n("CNextFromID");
        this.mCNextLocation = compoundTag.func_74779_i("CNextLocation");
    }

    public void synch() {
        Network.CHANNEL.send(PacketDistributor.DIMENSION.with(() -> this.field_145850_b.func_234923_W_()), (Object)new ProjectorImageInfoS2CPacket(this));
    }

    public void func_73660_a() {
        if (this.field_145850_b.func_201670_d()) {
            return;
        }
        if (this.mSourceType != SourceType.ContainerBlock) {
            return;
        }
        this.mContainer = HopperTileEntity.func_195484_a((World)this.field_145850_b, (BlockPos)ProjectorBlockEntity.tryParseCoor(this.mLocation, this.func_174877_v()));
        if (this.mContainer == null) {
            this.mCLocation = "";
            this.mCNextLocation = "";
            this.scanIndex = -1;
            return;
        }
        if (this.needInitContainer) {
            this.scanIndex = -1;
            this.handleReadImage(false);
            this.needInitContainer = false;
            this.func_70296_d();
            this.synch();
            return;
        }
        if (this.needHandleReadImage) {
            if (this.scanIndex < 0) {
                this.scanIndex = -1;
                this.handleReadImage(false);
                return;
            }
            this.handleReadImage(this.flipBack);
            this.func_70296_d();
            this.synch();
            this.needHandleReadImage = false;
            this.flipBack = false;
        }
    }

    private static BlockPos tryParseCoor(String coor, BlockPos pos) {
        try {
            String[] xyz = coor.split("\\s+");
            int[] nPos = new int[3];
            String x = xyz[0];
            nPos[0] = x.startsWith("~") ? pos.func_177958_n() + ProjectorBlockEntity.parseInt(x.substring(1)) : ProjectorBlockEntity.parseInt(x);
            String y = xyz[1];
            nPos[1] = y.startsWith("~") ? pos.func_177956_o() + ProjectorBlockEntity.parseInt(y.substring(1)) : ProjectorBlockEntity.parseInt(y);
            String z = xyz[2];
            nPos[2] = z.startsWith("~") ? pos.func_177952_p() + ProjectorBlockEntity.parseInt(z.substring(1)) : ProjectorBlockEntity.parseInt(z);
            return new BlockPos(nPos[0], nPos[1], nPos[2]);
        }
        catch (Exception e) {
            return pos.func_177977_b();
        }
    }

    private static int parseInt(String s) {
        if (s.isEmpty()) {
            return 0;
        }
        return Integer.parseInt(s);
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public boolean func_183000_F() {
        return true;
    }

    public ITextComponent func_145748_c_() {
        return Text.literal("");
    }

    public Container createMenu(int syncId, PlayerInventory playerInventory, PlayerEntity player) {
        PacketBuffer buf = new PacketBuffer(Unpooled.buffer());
        buf.func_179255_a(this.field_174879_c);
        return new ProjectorScreenHandler(syncId, buf);
    }

    public CompoundNBT getTileData() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        this.func_230337_a_(state, tag);
    }
}

