/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.slides.projector;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import org.apache.commons.lang3.StringUtils;
import org.teacon.slides.network.Network;
import org.teacon.slides.network.ProjectorAfterUpdateC2SPacket;
import org.teacon.slides.network.ProjectorExportC2SPacket;
import org.teacon.slides.projector.ProjectorBlock;
import org.teacon.slides.projector.ProjectorBlockEntity;
import org.teacon.slides.projector.ProjectorScreenHandler;
import org.teacon.slides.projector.SourceType;
import org.teacon.slides.renderer.RenderUtils;
import org.teacon.slides.renderer.SlideState;
import org.teacon.slides.util.Text;
import org.teacon.slides.util.UtilitiesClient;

public final class ProjectorScreen
extends ContainerScreen<ProjectorScreenHandler> {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("slide_show", "textures/gui/projector.png");
    private static final ITextComponent IMAGE_TEXT = Text.translatable("gui.slide_show.section.image", new Object[0]);
    private static final ITextComponent OFFSET_TEXT = Text.translatable("gui.slide_show.section.offset", new Object[0]);
    private static final ITextComponent OTHERS_TEXT = Text.translatable("gui.slide_show.section.others", new Object[0]);
    private static final ITextComponent URL_TEXT = Text.translatable("gui.slide_show.url", new Object[0]);
    private static final ITextComponent ID_TEXT = Text.translatable("gui.slide_show.id", new Object[0]);
    private static final ITextComponent EXPORT_TEXT = Text.translatable("gui.slide_show.export", new Object[0]);
    private static final ITextComponent CONTAINER_TEXT = Text.translatable("gui.slide_show.container", new Object[0]);
    private static final ITextComponent COLOR_TEXT = Text.translatable("gui.slide_show.color", new Object[0]);
    private static final ITextComponent WIDTH_TEXT = Text.translatable("gui.slide_show.width", new Object[0]);
    private static final ITextComponent HEIGHT_TEXT = Text.translatable("gui.slide_show.height", new Object[0]);
    private static final ITextComponent OFFSET_X_TEXT = Text.translatable("gui.slide_show.offset_x", new Object[0]);
    private static final ITextComponent OFFSET_Y_TEXT = Text.translatable("gui.slide_show.offset_y", new Object[0]);
    private static final ITextComponent OFFSET_Z_TEXT = Text.translatable("gui.slide_show.offset_z", new Object[0]);
    private static final ITextComponent FLIP_TEXT = Text.translatable("gui.slide_show.flip", new Object[0]);
    private static final ITextComponent ROTATE_TEXT = Text.translatable("gui.slide_show.rotate", new Object[0]);
    private static final ITextComponent SINGLE_DOUBLE_SIDED_TEXT = Text.translatable("gui.slide_show.single_double_sided", new Object[0]);
    private TextFieldWidget mURLInput;
    private TextFieldWidget mColorInput;
    private TextFieldWidget mWidthInput;
    private TextFieldWidget mHeightInput;
    private TextFieldWidget mOffsetXInput;
    private TextFieldWidget mOffsetYInput;
    private TextFieldWidget mOffsetZInput;
    private ImageButton mSwitchURL;
    private ImageButton mSwitchID;
    private ImageButton mSwitchContainer;
    private ImageButton mButtonExport;
    private ImageButton mSwitchSingleSided;
    private ImageButton mSwitchDoubleSided;
    private SourceType mSourceType;
    private boolean mDoubleSided;
    private int mImageColor = -1;
    private Vector2f mImageSize = Vector2f.field_189975_b;
    private Vector3f mImageOffset = new Vector3f();
    private ProjectorBlock.InternalRotation mRotation = ProjectorBlock.InternalRotation.NONE;
    private boolean mInvalidURL = true;
    private boolean mInvalidColor = true;
    private boolean mInvalidWidth = true;
    private boolean mInvalidHeight = true;
    private boolean mInvalidOffsetX = true;
    private boolean mInvalidOffsetY = true;
    private boolean mInvalidOffsetZ = true;
    private final ProjectorBlockEntity mEntity;
    private final int imageWidth;
    private final int imageHeight;

    public ProjectorScreen(ProjectorScreenHandler handler, PlayerInventory inventory, ITextComponent title) {
        super((Container)handler, inventory, title);
        TileEntity blockEntity = Minecraft.func_71410_x().field_71441_e.func_175625_s(handler.getPos());
        this.mEntity = blockEntity instanceof ProjectorBlockEntity ? (ProjectorBlockEntity)blockEntity : null;
        this.imageWidth = 176;
        this.imageHeight = 217;
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        if (this.mEntity == null) {
            return;
        }
        this.mSourceType = this.mEntity.mSourceType;
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        int leftPos = (this.field_230708_k_ - this.imageWidth) / 2;
        int topPos = (this.field_230709_l_ - this.imageHeight) / 2;
        this.mURLInput = new TextFieldWidget(this.field_230712_o_, leftPos + 30, topPos + 29, 137, 16, (ITextComponent)Text.translatable("gui.slide_show.url", new Object[0]));
        this.mURLInput.func_146203_f(512);
        this.mURLInput.func_212954_a(text -> {
            if (StringUtils.isNotBlank((CharSequence)text)) {
                switch (this.mSourceType) {
                    case URL: {
                        this.mInvalidURL = SlideState.createURI(text) == null;
                        break;
                    }
                    case ResourceID: {
                        this.mInvalidURL = ResourceLocation.func_208304_a((String)text) == null;
                        break;
                    }
                    default: {
                        this.mInvalidURL = false;
                        break;
                    }
                }
            } else {
                this.mInvalidURL = false;
            }
            this.mURLInput.func_146193_g(this.mInvalidURL ? 14699339 : 0xE0E0E0);
        });
        this.mURLInput.func_146180_a(this.mEntity.mLocation);
        this.func_230480_a_((Widget)this.mURLInput);
        this.func_212928_a((IGuiEventListener)this.mURLInput);
        this.mColorInput = new TextFieldWidget(this.field_230712_o_, leftPos + 55, topPos + 155, 56, 16, (ITextComponent)Text.translatable("gui.slide_show.color", new Object[0]));
        this.mColorInput.func_146203_f(8);
        this.mColorInput.func_212954_a(text -> {
            try {
                this.mImageColor = Integer.parseUnsignedInt(text, 16);
                this.mInvalidColor = false;
            }
            catch (Exception e) {
                this.mInvalidColor = true;
            }
            this.mColorInput.func_146193_g(this.mInvalidColor ? 14699339 : 0xE0E0E0);
        });
        this.mColorInput.func_146180_a(String.format("%08X", this.mEntity.mColor));
        this.func_230480_a_((Widget)this.mColorInput);
        this.mWidthInput = new TextFieldWidget(this.field_230712_o_, leftPos + 30, topPos + 51, 56, 16, (ITextComponent)Text.translatable("gui.slide_show.width", new Object[0]));
        this.mWidthInput.func_212954_a(text -> {
            try {
                Vector2f newSize = new Vector2f(ProjectorScreen.parseFloat(text), this.mImageSize.field_189983_j);
                this.updateSize(newSize);
                this.mInvalidWidth = false;
            }
            catch (Exception e) {
                this.mInvalidWidth = true;
            }
            this.mWidthInput.func_146193_g(this.mInvalidWidth ? 14699339 : 0xE0E0E0);
        });
        this.mWidthInput.func_146180_a(ProjectorScreen.floatToString(this.mEntity.mWidth));
        this.func_230480_a_((Widget)this.mWidthInput);
        this.mHeightInput = new TextFieldWidget(this.field_230712_o_, leftPos + 111, topPos + 51, 56, 16, (ITextComponent)Text.translatable("gui.slide_show.height", new Object[0]));
        this.mHeightInput.func_212954_a(input -> {
            try {
                Vector2f newSize = new Vector2f(this.mImageSize.field_189982_i, ProjectorScreen.parseFloat(input));
                this.updateSize(newSize);
                this.mInvalidHeight = false;
            }
            catch (Exception e) {
                this.mInvalidHeight = true;
            }
            this.mHeightInput.func_146193_g(this.mInvalidHeight ? 14699339 : 0xE0E0E0);
        });
        this.mHeightInput.func_146180_a(ProjectorScreen.floatToString(this.mEntity.mHeight));
        this.func_230480_a_((Widget)this.mHeightInput);
        this.mOffsetXInput = new TextFieldWidget(this.field_230712_o_, leftPos + 30, topPos + 103, 29, 16, (ITextComponent)Text.translatable("gui.slide_show.offset_x", new Object[0]));
        this.mOffsetXInput.func_212954_a(input -> {
            try {
                this.mImageOffset = new Vector3f(ProjectorScreen.parseFloat(input), this.mImageOffset.func_195900_b(), this.mImageOffset.func_195902_c());
                this.mInvalidOffsetX = false;
            }
            catch (Exception e) {
                this.mInvalidOffsetX = true;
            }
            this.mOffsetXInput.func_146193_g(this.mInvalidOffsetX ? 14699339 : 0xE0E0E0);
        });
        this.mOffsetXInput.func_146180_a(ProjectorScreen.floatToString(this.mEntity.mOffsetX));
        this.func_230480_a_((Widget)this.mOffsetXInput);
        this.mOffsetYInput = new TextFieldWidget(this.field_230712_o_, leftPos + 84, topPos + 103, 29, 16, (ITextComponent)Text.translatable("gui.slide_show.offset_y", new Object[0]));
        this.mOffsetYInput.func_212954_a(input -> {
            try {
                this.mImageOffset = new Vector3f(this.mImageOffset.func_195899_a(), ProjectorScreen.parseFloat(input), this.mImageOffset.func_195902_c());
                this.mInvalidOffsetY = false;
            }
            catch (Exception e) {
                this.mInvalidOffsetY = true;
            }
            this.mOffsetYInput.func_146193_g(this.mInvalidOffsetY ? 14699339 : 0xE0E0E0);
        });
        this.mOffsetYInput.func_146180_a(ProjectorScreen.floatToString(this.mEntity.mOffsetY));
        this.func_230480_a_((Widget)this.mOffsetYInput);
        this.mOffsetZInput = new TextFieldWidget(this.field_230712_o_, leftPos + 138, topPos + 103, 29, 16, (ITextComponent)Text.translatable("gui.slide_show.offset_z", new Object[0]));
        this.mOffsetZInput.func_212954_a(input -> {
            try {
                this.mImageOffset = new Vector3f(this.mImageOffset.func_195899_a(), this.mImageOffset.func_195900_b(), ProjectorScreen.parseFloat(input));
                this.mInvalidOffsetZ = false;
            }
            catch (Exception e) {
                this.mInvalidOffsetZ = true;
            }
            this.mOffsetZInput.func_146193_g(this.mInvalidOffsetZ ? 14699339 : 0xE0E0E0);
        });
        this.mOffsetZInput.func_146180_a(ProjectorScreen.floatToString(this.mEntity.mOffsetZ));
        this.func_230480_a_((Widget)this.mOffsetZInput);
        this.func_230480_a_((Widget)new ImageButton(leftPos + 117, topPos + 153, 18, 19, 179, 153, 0, GUI_TEXTURE, button -> {
            ProjectorBlock.InternalRotation newRotation = this.mRotation.flip();
            this.updateRotation(newRotation);
        }));
        this.func_230480_a_((Widget)new ImageButton(leftPos + 142, topPos + 153, 18, 19, 179, 173, 0, GUI_TEXTURE, button -> {
            ProjectorBlock.InternalRotation newRotation = this.mRotation.compose(Rotation.CLOCKWISE_90);
            this.updateRotation(newRotation);
        }));
        this.mRotation = (ProjectorBlock.InternalRotation)((Object)this.mEntity.func_195044_w().func_177229_b(ProjectorBlock.ROTATION));
        this.mSwitchURL = new ImageButton(leftPos + 9, topPos + 27, 18, 19, 179, 53, 0, GUI_TEXTURE, button -> {
            this.mSourceType = SourceType.ResourceID;
            this.mSwitchID.field_230694_p_ = true;
            this.mSwitchURL.field_230694_p_ = false;
        });
        this.mSwitchID = new ImageButton(leftPos + 9, topPos + 27, 18, 19, 179, 73, 0, GUI_TEXTURE, button -> {
            this.mSourceType = SourceType.ContainerBlock;
            this.mSwitchContainer.field_230694_p_ = true;
            this.mSwitchID.field_230694_p_ = false;
            this.mButtonExport.field_230694_p_ = false;
        });
        this.mSwitchContainer = new ImageButton(leftPos + 9, topPos + 27, 18, 19, 179, 93, 0, GUI_TEXTURE, button -> {
            this.mSourceType = SourceType.URL;
            this.mSwitchURL.field_230694_p_ = true;
            this.mSwitchContainer.field_230694_p_ = false;
            this.mButtonExport.field_230694_p_ = true;
        });
        this.mButtonExport = new ImageButton(leftPos + 149, topPos + 7, 18, 19, 179, 33, 0, GUI_TEXTURE, button -> this.sendExport());
        this.mSwitchSingleSided = new ImageButton(leftPos + 9, topPos + 153, 18, 19, 179, 113, 0, GUI_TEXTURE, button -> {
            this.mDoubleSided = false;
            this.mSwitchDoubleSided.field_230694_p_ = true;
            this.mSwitchSingleSided.field_230694_p_ = false;
        });
        this.mSwitchDoubleSided = new ImageButton(leftPos + 9, topPos + 153, 18, 19, 179, 133, 0, GUI_TEXTURE, button -> {
            this.mDoubleSided = true;
            this.mSwitchSingleSided.field_230694_p_ = true;
            this.mSwitchDoubleSided.field_230694_p_ = false;
        });
        this.mSwitchURL.field_230694_p_ = this.mSourceType == SourceType.URL;
        this.mSwitchID.field_230694_p_ = this.mSourceType == SourceType.ResourceID;
        this.mSwitchContainer.field_230694_p_ = this.mSourceType == SourceType.ContainerBlock;
        this.mButtonExport.field_230694_p_ = this.mSourceType != SourceType.ContainerBlock;
        this.mSwitchDoubleSided.field_230694_p_ = this.mDoubleSided = this.mEntity.mDoubleSided;
        this.mSwitchSingleSided.field_230694_p_ = !this.mDoubleSided;
        this.func_230480_a_((Widget)this.mSwitchURL);
        this.func_230480_a_((Widget)this.mSwitchID);
        this.func_230480_a_((Widget)this.mSwitchContainer);
        this.func_230480_a_((Widget)this.mButtonExport);
        this.func_230480_a_((Widget)this.mSwitchSingleSided);
        this.func_230480_a_((Widget)this.mSwitchDoubleSided);
    }

    private void updateRotation(ProjectorBlock.InternalRotation newRotation) {
        if (!(this.mInvalidOffsetX || this.mInvalidOffsetY || this.mInvalidOffsetZ)) {
            Vector3f absolute = ProjectorScreen.relativeToAbsolute(this.mImageOffset, this.mImageSize, this.mRotation);
            Vector3f newRelative = ProjectorScreen.absoluteToRelative(absolute, this.mImageSize, newRotation);
            this.mOffsetXInput.func_146180_a(ProjectorScreen.floatToString(newRelative.func_195899_a()));
            this.mOffsetYInput.func_146180_a(ProjectorScreen.floatToString(newRelative.func_195900_b()));
            this.mOffsetZInput.func_146180_a(ProjectorScreen.floatToString(newRelative.func_195902_c()));
        }
        this.mRotation = newRotation;
    }

    private void updateSize(Vector2f newSize) {
        if (!(this.mInvalidOffsetX || this.mInvalidOffsetY || this.mInvalidOffsetZ)) {
            Vector3f absolute = ProjectorScreen.relativeToAbsolute(this.mImageOffset, this.mImageSize, this.mRotation);
            Vector3f newRelative = ProjectorScreen.absoluteToRelative(absolute, newSize, this.mRotation);
            this.mOffsetXInput.func_146180_a(ProjectorScreen.floatToString(newRelative.func_195899_a()));
            this.mOffsetYInput.func_146180_a(ProjectorScreen.floatToString(newRelative.func_195900_b()));
            this.mOffsetZInput.func_146180_a(ProjectorScreen.floatToString(newRelative.func_195902_c()));
        }
        this.mImageSize = newSize;
    }

    public void func_231023_e_() {
        if (this.mEntity == null) {
            this.field_230706_i_.field_71439_g.func_71053_j();
            return;
        }
        this.mURLInput.func_146178_a();
        this.mColorInput.func_146178_a();
        this.mWidthInput.func_146178_a();
        this.mHeightInput.func_146178_a();
        this.mOffsetXInput.func_146178_a();
        this.mOffsetYInput.func_146178_a();
        this.mOffsetZInput.func_146178_a();
    }

    private void sendExport() {
        if (this.mSourceType == SourceType.ContainerBlock) {
            return;
        }
        Network.CHANNEL.sendToServer((Object)new ProjectorExportC2SPacket(this.mSourceType == SourceType.ResourceID, this.mURLInput.func_146179_b()));
    }

    public void func_231164_f_() {
        boolean invalidOffset;
        super.func_231164_f_();
        this.field_230706_i_.field_195559_v.func_197967_a(false);
        if (this.mEntity == null) {
            return;
        }
        boolean invalidSize = this.mInvalidWidth || this.mInvalidHeight;
        boolean bl = invalidOffset = this.mInvalidOffsetX || this.mInvalidOffsetY || this.mInvalidOffsetZ;
        if (!this.mInvalidURL) {
            this.mEntity.mLocation = this.mURLInput.func_146179_b();
        }
        if (!this.mInvalidColor) {
            this.mEntity.mColor = this.mImageColor;
        }
        if (!invalidSize) {
            this.mEntity.mWidth = this.mImageSize.field_189982_i;
            this.mEntity.mHeight = this.mImageSize.field_189983_j;
        }
        if (!invalidOffset) {
            this.mEntity.mOffsetX = this.mImageOffset.func_195899_a();
            this.mEntity.mOffsetY = this.mImageOffset.func_195900_b();
            this.mEntity.mOffsetZ = this.mImageOffset.func_195902_c();
        }
        this.mEntity.needInitContainer = this.mEntity.mSourceType == this.mSourceType;
        this.mEntity.mSourceType = this.mSourceType;
        this.mEntity.mDoubleSided = this.mDoubleSided;
        Network.CHANNEL.sendToServer((Object)new ProjectorAfterUpdateC2SPacket(this.mEntity, this.mRotation));
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifier) {
        if (keyCode == 256) {
            this.field_230706_i_.field_71439_g.func_71053_j();
            return true;
        }
        return this.mURLInput.func_231046_a_(keyCode, scanCode, modifier) || this.mURLInput.func_212955_f() || this.mColorInput.func_231046_a_(keyCode, scanCode, modifier) || this.mColorInput.func_212955_f() || this.mWidthInput.func_231046_a_(keyCode, scanCode, modifier) || this.mWidthInput.func_212955_f() || this.mHeightInput.func_231046_a_(keyCode, scanCode, modifier) || this.mHeightInput.func_212955_f() || this.mOffsetXInput.func_231046_a_(keyCode, scanCode, modifier) || this.mOffsetXInput.func_212955_f() || this.mOffsetYInput.func_231046_a_(keyCode, scanCode, modifier) || this.mOffsetYInput.func_212955_f() || this.mOffsetZInput.func_231046_a_(keyCode, scanCode, modifier) || this.mOffsetZInput.func_212955_f() || super.func_231046_a_(keyCode, scanCode, modifier);
    }

    public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        this.func_230446_a_(matrices);
        super.func_230430_a_(matrices, mouseX, mouseY, delta);
    }

    protected void func_230450_a_(MatrixStack matrixStack, float f, int i, int j) {
        UtilitiesClient.beginDrawingTexture(GUI_TEXTURE);
        this.func_238474_b_(matrixStack, (this.field_230708_k_ - this.imageWidth) / 2, (this.field_230709_l_ - this.imageHeight) / 2, 0, 0, this.imageWidth, this.imageHeight);
    }

    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        if (this.mEntity == null) {
            return;
        }
        int alpha = this.mImageColor >>> 24;
        if (alpha > 0) {
            int red = this.mImageColor >> 16 & 0xFF;
            int green = this.mImageColor >> 8 & 0xFF;
            int blue = this.mImageColor & 0xFF;
            RenderUtils.setShaderColor((float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f, (float)alpha / 255.0f);
            this.func_238474_b_(matrixStack, 38, 131, 180, 194, 10, 10);
            this.func_238474_b_(matrixStack, 82, 159, 180, 194, 17, 17);
        }
        RenderUtils.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
        this.func_238474_b_(matrixStack, 82, 159, 202, 194 - this.mRotation.ordinal() * 20, 17, 17);
        ProjectorScreen.drawCenteredStringWithoutShadow(matrixStack, this.field_230712_o_, IMAGE_TEXT, (float)this.imageWidth / 2.0f, -14.0f);
        ProjectorScreen.drawCenteredStringWithoutShadow(matrixStack, this.field_230712_o_, OFFSET_TEXT, (float)this.imageWidth / 2.0f, 60.0f);
        ProjectorScreen.drawCenteredStringWithoutShadow(matrixStack, this.field_230712_o_, OTHERS_TEXT, (float)this.imageWidth / 2.0f, 112.0f);
        int offsetX = mouseX - (this.field_230708_k_ - this.imageWidth) / 2;
        int offsetY = mouseY - (this.field_230709_l_ - this.imageHeight) / 2;
        if (offsetX >= 9 && offsetY >= 27 && offsetX < 27 && offsetY < 46) {
            if (this.mSourceType == SourceType.ResourceID) {
                this.func_238652_a_(matrixStack, ID_TEXT, offsetX, offsetY);
            } else if (this.mSourceType == SourceType.ContainerBlock) {
                this.func_238652_a_(matrixStack, CONTAINER_TEXT, offsetX, offsetY);
            } else {
                this.func_238652_a_(matrixStack, URL_TEXT, offsetX, offsetY);
            }
        } else if (offsetX >= 149 && offsetY >= 7 && offsetX < 167 && offsetY < 26) {
            if (this.mSourceType != SourceType.ContainerBlock) {
                this.func_238652_a_(matrixStack, EXPORT_TEXT, offsetX, offsetY);
            }
        } else if (offsetX >= 34 && offsetY >= 153 && offsetX < 52 && offsetY < 172) {
            this.func_238652_a_(matrixStack, COLOR_TEXT, offsetX, offsetY);
        } else if (offsetX >= 9 && offsetY >= 49 && offsetX < 27 && offsetY < 68) {
            this.func_238652_a_(matrixStack, WIDTH_TEXT, offsetX, offsetY);
        } else if (offsetX >= 90 && offsetY >= 49 && offsetX < 108 && offsetY < 68) {
            this.func_238652_a_(matrixStack, HEIGHT_TEXT, offsetX, offsetY);
        } else if (offsetX >= 9 && offsetY >= 101 && offsetX < 27 && offsetY < 120) {
            this.func_238652_a_(matrixStack, OFFSET_X_TEXT, offsetX, offsetY);
        } else if (offsetX >= 63 && offsetY >= 101 && offsetX < 81 && offsetY < 120) {
            this.func_238652_a_(matrixStack, OFFSET_Y_TEXT, offsetX, offsetY);
        } else if (offsetX >= 117 && offsetY >= 101 && offsetX < 135 && offsetY < 120) {
            this.func_238652_a_(matrixStack, OFFSET_Z_TEXT, offsetX, offsetY);
        } else if (offsetX >= 117 && offsetY >= 153 && offsetX < 135 && offsetY < 172) {
            this.func_238652_a_(matrixStack, FLIP_TEXT, offsetX, offsetY);
        } else if (offsetX >= 142 && offsetY >= 153 && offsetX < 160 && offsetY < 172) {
            this.func_238652_a_(matrixStack, ROTATE_TEXT, offsetX, offsetY);
        } else if (offsetX >= 9 && offsetY >= 153 && offsetX < 27 && offsetY < 172) {
            this.func_238652_a_(matrixStack, SINGLE_DOUBLE_SIDED_TEXT, offsetX, offsetY);
        }
    }

    private static void drawCenteredStringWithoutShadow(MatrixStack stack, FontRenderer renderer, ITextComponent string, float x, float y) {
        renderer.func_243248_b(stack, string, x - (float)renderer.func_238414_a_((ITextProperties)string) / 2.0f, y, 0x404040);
    }

    private static float parseFloat(String text) {
        return (float)Math.round(Float.parseFloat(text) * 10000.0f) / 10000.0f;
    }

    private static String floatToString(float value) {
        return String.valueOf((float)Math.round(value * 10000.0f) / 10000.0f);
    }

    private static Vector3f relativeToAbsolute(Vector3f relatedOffset, Vector2f size, ProjectorBlock.InternalRotation rotation) {
        Vector4f center = new Vector4f(0.5f * size.field_189982_i, 0.0f, 0.5f * size.field_189983_j, 1.0f);
        center.func_229372_a_(Matrix4f.func_226599_b_((float)relatedOffset.func_195899_a(), (float)(-relatedOffset.func_195902_c()), (float)relatedOffset.func_195900_b()));
        center.func_229372_a_(Matrix4f.func_226599_b_((float)-0.5f, (float)0.0f, (float)(0.5f - size.field_189983_j)));
        rotation.transform(center);
        return new Vector3f(center.func_195910_a(), center.func_195913_b(), center.func_195914_c());
    }

    private static Vector3f absoluteToRelative(Vector3f absoluteOffset, Vector2f size, ProjectorBlock.InternalRotation rotation) {
        Vector4f center = new Vector4f(absoluteOffset);
        rotation.invert().transform(center);
        center.func_229372_a_(Matrix4f.func_226599_b_((float)0.5f, (float)0.0f, (float)(-0.5f + size.field_189983_j)));
        center.func_229372_a_(Matrix4f.func_226599_b_((float)(-0.5f * size.field_189982_i), (float)0.0f, (float)(-0.5f * size.field_189983_j)));
        return new Vector3f(center.func_195910_a(), center.func_195914_c(), -center.func_195913_b());
    }
}

