/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.slides.texture;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.annotation.Nonnull;
import org.teacon.slides.texture.LZWDecoder;

public class GIFDecoder {
    public static final int DEFAULT_DELAY_MILLIS = 40;
    private final byte[] mBuf;
    private final LZWDecoder mDec;
    private int mPos;
    private final int mHeaderPos;
    private final int mScreenWidth;
    private final int mScreenHeight;
    private final byte[][] mGlobalPalette;
    private final byte[] mImage;
    private byte[][] mTmpPalette;
    private final byte[] mTmpImage;
    private final int[] mTmpInterlace;

    public GIFDecoder(byte[] buf, LZWDecoder dec, boolean checkMagic) throws IOException {
        this.mBuf = buf;
        this.mDec = dec;
        if (checkMagic) {
            int b;
            if (this.readByte() != 71 || this.readByte() != 73 || this.readByte() != 70 || this.readByte() != 56 || (b = this.readByte()) != 55 && b != 57 || this.readByte() != 97) {
                throw new IOException();
            }
        } else {
            this.mPos = 6;
        }
        this.mScreenWidth = this.readShort();
        this.mScreenHeight = this.readShort();
        int packedField = this.readByte();
        this.skipBytes(2);
        this.mGlobalPalette = (packedField & 0x80) != 0 ? this.readPalette(2 << (packedField & 7), -1, null) : (byte[][])null;
        this.mImage = new byte[this.mScreenWidth * this.mScreenHeight * 4];
        this.mTmpImage = new byte[this.mImage.length];
        this.mTmpInterlace = new int[this.mScreenHeight];
        this.mHeaderPos = this.mPos;
    }

    public static boolean checkMagic(@Nonnull byte[] buf) {
        return buf.length >= 6 && buf[0] == 71 && buf[1] == 73 && buf[2] == 70 && buf[3] == 56 && (buf[4] == 55 || buf[4] == 57) && buf[5] == 97;
    }

    public int getScreenWidth() {
        return this.mScreenWidth;
    }

    public int getScreenHeight() {
        return this.mScreenHeight;
    }

    public int decodeNextFrame(ByteBuffer pixels) throws IOException {
        int imageControlCode = this.syncNextFrame();
        if (imageControlCode < 0) {
            throw new IOException();
        }
        int left = this.readShort();
        int top = this.readShort();
        int width = this.readShort();
        int height = this.readShort();
        if (left + width > this.mScreenWidth || top + height > this.mScreenHeight) {
            throw new IOException();
        }
        int packedField = this.readByte();
        boolean isTransparent = (imageControlCode >>> 24 & 1) != 0;
        int transparentIndex = isTransparent ? imageControlCode >>> 16 & 0xFF : -1;
        boolean localPalette = (packedField & 0x80) != 0;
        boolean isInterlaced = (packedField & 0x40) != 0;
        int paletteSize = 2 << (packedField & 7);
        if (this.mTmpPalette == null || this.mTmpPalette[0].length < paletteSize) {
            this.mTmpPalette = new byte[4][paletteSize];
        }
        byte[][] palette = localPalette ? this.readPalette(paletteSize, transparentIndex, this.mTmpPalette) : this.mGlobalPalette;
        int delayTime = imageControlCode & 0xFFFF;
        int disposalCode = imageControlCode >>> 26 & 7;
        this.decodeImage(this.mTmpImage, width, height, isInterlaced ? this.computeInterlaceReIndex(height, this.mTmpInterlace) : null);
        this.decodePalette(this.mTmpImage, palette, transparentIndex, left, top, width, height, disposalCode, pixels);
        return delayTime != 0 ? delayTime * 10 : 40;
    }

    @Nonnull
    private byte[][] readPalette(int size, int transparentIndex, byte[][] palette) throws IOException {
        if (palette == null) {
            palette = new byte[4][size];
        }
        for (int i = 0; i < size; ++i) {
            for (int k = 0; k < 3; ++k) {
                palette[k][i] = (byte)this.readByte();
            }
            palette[3][i] = i == transparentIndex ? 0 : -1;
        }
        return palette;
    }

    public void skipExtension() throws IOException {
        int blockSize = this.readByte();
        while (blockSize != 0) {
            this.skipBytes(blockSize);
            blockSize = this.readByte();
        }
    }

    private int readControlCode() throws IOException {
        int blockSize = this.readByte();
        int packedField = this.readByte();
        int delayTime = this.readShort();
        int transparentIndex = this.readByte();
        if (blockSize != 4 || this.readByte() != 0) {
            throw new IOException();
        }
        return ((packedField & 0x1F) << 24) + (transparentIndex << 16) + delayTime;
    }

    private int syncNextFrame() throws IOException {
        int controlData = 0;
        boolean restarted = false;
        block5: while (true) {
            int ch = this.read();
            switch (ch) {
                case 44: {
                    return controlData;
                }
                case 33: {
                    if (this.readByte() == 249) {
                        controlData = this.readControlCode();
                        continue block5;
                    }
                    this.skipExtension();
                    continue block5;
                }
                case -1: 
                case 59: {
                    if (restarted) {
                        return -1;
                    }
                    this.mPos = this.mHeaderPos;
                    controlData = 0;
                    restarted = true;
                    continue block5;
                }
            }
            break;
        }
        throw new IOException();
    }

    private void decodeImage(byte[] image, int width, int height, int[] interlace) throws IOException {
        LZWDecoder dec = this.mDec;
        byte[] data = dec.setContext(this);
        int y = 0;
        int iPos = 0;
        int xr = width;
        block0: while (true) {
            int len;
            if ((len = dec.readString()) == -1) {
                this.skipExtension();
                return;
            }
            int pos = 0;
            while (true) {
                if (pos >= len) continue block0;
                int ax = Math.min(xr, len - pos);
                System.arraycopy(data, pos, image, iPos, ax);
                iPos += ax;
                pos += ax;
                if ((xr -= ax) != 0) continue;
                if (++y == height) {
                    this.skipExtension();
                    return;
                }
                int iY = interlace == null ? y : interlace[y];
                iPos = iY * width;
                xr = width;
            }
            break;
        }
    }

    @Nonnull
    private int[] computeInterlaceReIndex(int height, int[] data) {
        int i;
        int pos = 0;
        for (i = 0; i < height; i += 8) {
            data[pos++] = i;
        }
        for (i = 4; i < height; i += 8) {
            data[pos++] = i;
        }
        for (i = 2; i < height; i += 4) {
            data[pos++] = i;
        }
        for (i = 1; i < height; i += 2) {
            data[pos++] = i;
        }
        return data;
    }

    private void restoreToBackground(byte[] image, int left, int top, int width, int height) {
        for (int y = 0; y < height; ++y) {
            int iPos = ((top + y) * this.mScreenWidth + left) * 4;
            for (int x = 0; x < width; ++x) {
                image[iPos + 3] = 0;
                iPos += 4;
            }
        }
    }

    private void decodePalette(byte[] srcImage, byte[][] palette, int transparentIndex, int left, int top, int width, int height, int disposalCode, ByteBuffer pixels) {
        if (disposalCode == 3) {
            pixels.put(this.mImage);
            for (int y = 0; y < height; ++y) {
                int index;
                int x;
                int iPos = ((top + y) * this.mScreenWidth + left) * 4;
                int i = y * width;
                if (transparentIndex < 0) {
                    for (x = 0; x < width; ++x) {
                        index = 0xFF & srcImage[i + x];
                        pixels.put(iPos++, palette[0][index]);
                        pixels.put(iPos++, palette[1][index]);
                        pixels.put(iPos++, palette[2][index]);
                        pixels.put(iPos++, palette[3][index]);
                    }
                    continue;
                }
                for (x = 0; x < width; ++x) {
                    index = 0xFF & srcImage[i + x];
                    if (index != transparentIndex) {
                        pixels.put(iPos++, palette[0][index]);
                        pixels.put(iPos++, palette[1][index]);
                        pixels.put(iPos++, palette[2][index]);
                        pixels.put(iPos++, palette[3][index]);
                        continue;
                    }
                    iPos += 4;
                }
            }
            pixels.rewind();
        } else {
            byte[] image = this.mImage;
            for (int y = 0; y < height; ++y) {
                int index;
                int x;
                int iPos = ((top + y) * this.mScreenWidth + left) * 4;
                int i = y * width;
                if (transparentIndex < 0) {
                    for (x = 0; x < width; ++x) {
                        index = 0xFF & srcImage[i + x];
                        image[iPos++] = palette[0][index];
                        image[iPos++] = palette[1][index];
                        image[iPos++] = palette[2][index];
                        image[iPos++] = palette[3][index];
                    }
                    continue;
                }
                for (x = 0; x < width; ++x) {
                    index = 0xFF & srcImage[i + x];
                    if (index != transparentIndex) {
                        image[iPos++] = palette[0][index];
                        image[iPos++] = palette[1][index];
                        image[iPos++] = palette[2][index];
                        image[iPos++] = palette[3][index];
                        continue;
                    }
                    iPos += 4;
                }
            }
            pixels.put(image).rewind();
            if (disposalCode == 2) {
                this.restoreToBackground(this.mImage, left, top, width, height);
            }
        }
    }

    private int read() {
        if (this.mPos < this.mBuf.length) {
            return this.mBuf[this.mPos++] & 0xFF;
        }
        return -1;
    }

    public int readByte() throws IOException {
        if (this.mPos < this.mBuf.length) {
            return this.mBuf[this.mPos++] & 0xFF;
        }
        throw new EOFException();
    }

    private int readShort() throws IOException {
        int lsb = this.readByte();
        int msb = this.readByte();
        return lsb + (msb << 8);
    }

    public void readBytes(byte[] b, int off, int len) throws IOException {
        int avail = this.mBuf.length - this.mPos;
        if (avail <= 0) {
            throw new EOFException();
        }
        if (len > avail) {
            len = avail;
        }
        if (len <= 0) {
            return;
        }
        System.arraycopy(this.mBuf, this.mPos, b, off, len);
        this.mPos += len;
    }

    private void skipBytes(int n) throws IOException {
        if (this.mPos + n < this.mBuf.length) {
            this.mPos += n;
        } else {
            throw new EOFException();
        }
    }
}

