/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.slides.network;

import com.mojang.authlib.GameProfile;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.network.CustomPayloadEvent;
import org.teacon.slides.Slideshow;
import org.teacon.slides.util.Utilities;

public class ImageAfterUpdateC2SPacket {
    private final InteractionHand hand;
    private final boolean fromId;
    private final String location;

    public ImageAfterUpdateC2SPacket(InteractionHand hand, boolean fromId, String location) {
        this.hand = hand;
        this.fromId = fromId;
        this.location = location;
    }

    public ImageAfterUpdateC2SPacket(FriendlyByteBuf buf) {
        this.hand = buf.readBoolean() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        this.fromId = buf.readBoolean();
        this.location = buf.m_130136_(512);
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.hand == InteractionHand.MAIN_HAND);
        buffer.writeBoolean(this.fromId);
        buffer.m_130070_(this.location);
    }

    public static void handle(ImageAfterUpdateC2SPacket packet, CustomPayloadEvent.Context context) {
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            ItemStack itemStack = player.m_21120_(packet.hand);
            if (itemStack != null && !itemStack.m_41619_() && itemStack.m_150930_((Item)Slideshow.IMAGE_ITEM.get())) {
                itemStack.m_41700_("from_id", (Tag)ByteTag.m_128273_((boolean)packet.fromId));
                itemStack.m_41700_("location", (Tag)StringTag.m_129297_((String)packet.location));
                return;
            }
            GameProfile profile = player.m_36316_();
            Slideshow.LOGGER.debug(Utilities.MARKER, "Received illegal packet for projector export: player = {}", (Object)profile);
        });
    }
}

