/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.slides.network;

import com.mojang.authlib.GameProfile;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.network.CustomPayloadEvent;
import org.teacon.slides.Slideshow;
import org.teacon.slides.projector.ProjectorBlock;
import org.teacon.slides.util.Utilities;

public class ProjectorExportC2SPacket {
    private final boolean mFromID;
    private final String mLocation;

    public ProjectorExportC2SPacket(boolean fromID, String location) {
        this.mFromID = fromID;
        this.mLocation = location;
    }

    public ProjectorExportC2SPacket(FriendlyByteBuf buf) {
        this.mFromID = buf.readBoolean();
        this.mLocation = buf.m_130277_();
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.mFromID);
        buffer.m_130070_(this.mLocation);
    }

    public static void handle(ProjectorExportC2SPacket projectorExportPacket, CustomPayloadEvent.Context context) {
        ServerPlayer serverPlayer = context.getSender();
        if (serverPlayer == null) {
            context.setPacketHandled(true);
            return;
        }
        context.enqueueWork(() -> {
            if (ProjectorExportC2SPacket.giveImageItem(serverPlayer, projectorExportPacket.mFromID, projectorExportPacket.mLocation)) {
                return;
            }
            GameProfile profile = serverPlayer.m_36316_();
            Slideshow.LOGGER.debug(Utilities.MARKER, "Received illegal packet for projector export: player = {}", (Object)profile);
        });
        context.setPacketHandled(true);
    }

    public static boolean giveImageItem(ServerPlayer serverPlayer, boolean fromID, String location) {
        if (ProjectorBlock.hasProjectorPermission(serverPlayer)) {
            ItemStack itemStack = new ItemStack((ItemLike)Slideshow.IMAGE_ITEM.get(), 1);
            itemStack.m_41700_("from_id", (Tag)ByteTag.m_128273_((boolean)fromID));
            itemStack.m_41700_("location", (Tag)StringTag.m_129297_((String)location));
            boolean bl = serverPlayer.m_150109_().m_36054_(itemStack);
            if (bl && itemStack.m_41619_()) {
                itemStack.m_41764_(1);
                ItemEntity itemEntity = serverPlayer.m_36176_(itemStack, false);
                if (itemEntity != null) {
                    itemEntity.m_32065_();
                }
                serverPlayer.m_9236_().m_6263_(null, serverPlayer.m_20185_(), serverPlayer.m_20186_(), serverPlayer.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, ((serverPlayer.m_217043_().m_188501_() - serverPlayer.m_217043_().m_188501_()) * 0.7f + 1.0f) * 2.0f);
                serverPlayer.f_36095_.m_38946_();
            } else {
                ItemEntity itemEntity = serverPlayer.m_36176_(itemStack, false);
                if (itemEntity != null) {
                    itemEntity.m_32061_();
                    itemEntity.m_266426_(serverPlayer.m_20148_());
                }
            }
            return true;
        }
        return false;
    }
}

