/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.slides.projector;

import io.netty.buffer.Unpooled;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.teacon.slides.Slideshow;
import org.teacon.slides.network.Network;
import org.teacon.slides.network.ProjectorImageInfoS2CPacket;
import org.teacon.slides.projector.ProjectorBlock;
import org.teacon.slides.projector.ProjectorScreenHandler;
import org.teacon.slides.projector.SourceType;

public final class ProjectorBlockEntity
extends BlockEntity
implements MenuProvider {
    public SourceType mSourceType = SourceType.URL;
    public String mLocation = "";
    public int mColor = -1;
    public float mWidth = 1.0f;
    public float mHeight = 1.0f;
    public float mOffsetX = 0.0f;
    public float mOffsetY = 0.0f;
    public float mOffsetZ = 0.0f;
    public boolean mDoubleSided = true;
    public Container mContainer = null;
    public int scanIndex = -1;
    public boolean needInitContainer = false;
    public boolean needHandleReadImage = false;
    public boolean flipBack = false;
    public boolean mCFromID = false;
    public String mCLocation = "";
    public boolean mCNextFromID = false;
    public String mCNextLocation = "";

    public ProjectorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)Slideshow.PROJECTOR_BLOCK_ENTITY.get(), pos, state);
    }

    public void transformToSlideSpace(Matrix4f pose, Matrix3f normal) {
        BlockState state = this.m_58900_();
        Direction direction = (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_);
        ProjectorBlock.InternalRotation rotation = (ProjectorBlock.InternalRotation)((Object)state.m_61143_(ProjectorBlock.ROTATION));
        pose.translate(0.5f, 0.5f, 0.5f);
        pose.rotate((Quaternionfc)direction.m_253075_());
        normal.rotate((Quaternionfc)direction.m_253075_());
        pose.translate(0.0f, 0.5f, 0.0f);
        rotation.transform(pose);
        rotation.transform(normal);
        pose.translate(-0.5f, 0.0f, 0.5f - this.mHeight);
        pose.translate(this.mOffsetX, -this.mOffsetZ, this.mOffsetY);
        pose.scale(this.mWidth, 1.0f, this.mHeight);
    }

    private boolean tryReadImageItem(ItemStack item, boolean next) {
        if (item.m_150930_((Item)Slideshow.IMAGE_ITEM.get()) && item.m_41782_() && item.m_41783_().m_128441_("location")) {
            if (next) {
                this.mCNextFromID = item.m_41783_().m_128471_("from_id");
                this.mCNextLocation = item.m_41783_().m_128461_("location");
            } else {
                this.mCFromID = item.m_41783_().m_128471_("from_id");
                this.mCLocation = item.m_41783_().m_128461_("location");
            }
            return true;
        }
        return false;
    }

    private void handleReadImage(boolean back) {
        ItemStack item;
        int i;
        int j;
        int size = this.mContainer.m_6643_();
        if (size <= 0) {
            return;
        }
        int start = back ? size + this.scanIndex - 1 : this.scanIndex + 1;
        int end = back ? this.scanIndex - 1 : size + this.scanIndex + 1;
        boolean found = false;
        if (back) {
            for (j = start; j > end; --j) {
                i = j % size;
                item = this.mContainer.m_8020_(i);
                if (!this.tryReadImageItem(item, false)) continue;
                this.scanIndex = i;
                found = true;
                start = i + 1;
                end = start + size;
                break;
            }
        } else {
            for (j = start; j < end; ++j) {
                i = j % size;
                item = this.mContainer.m_8020_(i);
                if (!this.tryReadImageItem(item, false)) continue;
                this.scanIndex = i;
                found = true;
                start = i + 1;
                end = start + size;
                break;
            }
        }
        if (!found) {
            this.mCNextLocation = "";
            return;
        }
        for (j = start; j < end; ++j) {
            i = j % size;
            item = this.mContainer.m_8020_(i);
            if (!this.tryReadImageItem(item, true)) continue;
            return;
        }
    }

    public boolean canFlip() {
        return this.mSourceType == SourceType.ContainerBlock && this.mContainer != null;
    }

    public boolean getFromID() {
        if (this.mSourceType != SourceType.ContainerBlock) {
            return this.mSourceType == SourceType.ResourceID;
        }
        return this.mCFromID;
    }

    public String getLocation() {
        if (this.mSourceType != SourceType.ContainerBlock) {
            return this.mLocation;
        }
        return this.mCLocation;
    }

    public void m_183515_(CompoundTag compoundTag) {
        this.saveCompound(compoundTag);
        super.m_183515_(compoundTag);
    }

    public void m_142466_(CompoundTag compoundTag) {
        this.loadCompound(compoundTag);
        super.m_142466_(compoundTag);
    }

    public void saveCompound(CompoundTag compoundTag) {
        compoundTag.m_128359_("SourceType", switch (this.mSourceType) {
            case SourceType.ResourceID -> "resource_id";
            case SourceType.ContainerBlock -> "container";
            default -> "url";
        });
        compoundTag.m_128359_("ImageLocation", this.mLocation);
        compoundTag.m_128405_("Color", this.mColor);
        compoundTag.m_128350_("Width", this.mWidth);
        compoundTag.m_128350_("Height", this.mHeight);
        compoundTag.m_128350_("OffsetX", this.mOffsetX);
        compoundTag.m_128350_("OffsetY", this.mOffsetY);
        compoundTag.m_128350_("OffsetZ", this.mOffsetZ);
        compoundTag.m_128379_("DoubleSided", this.mDoubleSided);
        compoundTag.m_128405_("ScanIndex", this.scanIndex);
        compoundTag.m_128379_("CFromID", this.mCFromID);
        compoundTag.m_128359_("CLocation", this.mCLocation);
        compoundTag.m_128379_("CNextFromID", this.mCNextFromID);
        compoundTag.m_128359_("CNextLocation", this.mCNextLocation);
    }

    public void loadCompound(CompoundTag compoundTag) {
        this.mSourceType = switch (compoundTag.m_128461_("SourceType")) {
            case "resource_id" -> SourceType.ResourceID;
            case "container" -> SourceType.ContainerBlock;
            default -> SourceType.URL;
        };
        this.mLocation = compoundTag.m_128461_("ImageLocation");
        this.mColor = compoundTag.m_128451_("Color");
        this.mWidth = compoundTag.m_128457_("Width");
        this.mHeight = compoundTag.m_128457_("Height");
        this.mOffsetX = compoundTag.m_128457_("OffsetX");
        this.mOffsetY = compoundTag.m_128457_("OffsetY");
        this.mOffsetZ = compoundTag.m_128457_("OffsetZ");
        this.mDoubleSided = compoundTag.m_128471_("DoubleSided");
        this.scanIndex = compoundTag.m_128451_("ScanIndex");
        this.mCFromID = compoundTag.m_128471_("CFromID");
        this.mCLocation = compoundTag.m_128461_("CLocation");
        this.mCNextFromID = compoundTag.m_128471_("CNextFromID");
        this.mCNextLocation = compoundTag.m_128461_("CNextLocation");
    }

    public void sync() {
        Network.CHANNEL.send((Object)new ProjectorImageInfoS2CPacket(this), PacketDistributor.DIMENSION.with((Object)this.f_58857_.m_46472_()));
    }

    public static void tick(Level world, BlockPos pos, ProjectorBlockEntity entity) {
        if (world.m_5776_()) {
            return;
        }
        if (entity.mSourceType != SourceType.ContainerBlock) {
            return;
        }
        entity.mContainer = HopperBlockEntity.m_59390_((Level)world, (BlockPos)ProjectorBlockEntity.tryParseCoor(entity.mLocation, pos));
        if (entity.mContainer == null) {
            entity.mCLocation = "";
            entity.mCNextLocation = "";
            entity.scanIndex = -1;
            return;
        }
        if (entity.needInitContainer) {
            entity.scanIndex = -1;
            entity.handleReadImage(false);
            entity.needInitContainer = false;
            entity.m_6596_();
            entity.sync();
            return;
        }
        if (entity.needHandleReadImage) {
            if (entity.scanIndex < 0) {
                entity.scanIndex = -1;
                entity.handleReadImage(false);
                return;
            }
            entity.handleReadImage(entity.flipBack);
            entity.m_6596_();
            entity.sync();
            entity.needHandleReadImage = false;
            entity.flipBack = false;
        }
    }

    private static BlockPos tryParseCoor(String coor, BlockPos pos) {
        try {
            String[] xyz = coor.split("\\s+");
            int[] nPos = new int[3];
            String x = xyz[0];
            nPos[0] = x.startsWith("~") ? pos.m_123341_() + ProjectorBlockEntity.parseInt(x.substring(1)) : ProjectorBlockEntity.parseInt(x);
            String y = xyz[1];
            nPos[1] = y.startsWith("~") ? pos.m_123342_() + ProjectorBlockEntity.parseInt(y.substring(1)) : ProjectorBlockEntity.parseInt(y);
            String z = xyz[2];
            nPos[2] = z.startsWith("~") ? pos.m_123343_() + ProjectorBlockEntity.parseInt(z.substring(1)) : ProjectorBlockEntity.parseInt(z);
            return new BlockPos(nPos[0], nPos[1], nPos[2]);
        }
        catch (Exception e) {
            return pos.m_7495_();
        }
    }

    private static int parseInt(String s) {
        if (s.isEmpty()) {
            return 0;
        }
        return Integer.parseInt(s);
    }

    public CompoundTag m_5995_() {
        CompoundTag compoundTag = new CompoundTag();
        this.m_183515_(compoundTag);
        return compoundTag;
    }

    public boolean m_6326_() {
        return true;
    }

    public Component m_5446_() {
        return Component.m_237113_((String)"");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int syncId, Inventory playerInventory, Player player) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.m_130064_(this.f_58858_);
        return new ProjectorScreenHandler(syncId, buf);
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }
}

