/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.slides.network;

import com.mojang.authlib.GameProfile;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkEvent;
import org.teacon.slides.Slideshow;
import org.teacon.slides.projector.ProjectorBlock;
import org.teacon.slides.projector.ProjectorBlockEntity;
import org.teacon.slides.util.Utilities;

public final class ProjectorAfterUpdateC2SPacket {
    private final BlockPos mPos;
    private final ProjectorBlock.InternalRotation mRotation;
    private final CompoundTag mTag;
    private final boolean mBoolean;

    public ProjectorAfterUpdateC2SPacket(ProjectorBlockEntity entity, ProjectorBlock.InternalRotation rotation) {
        this.mPos = entity.m_58899_();
        this.mRotation = rotation;
        this.mTag = new CompoundTag();
        entity.saveCompound(this.mTag);
        this.mBoolean = entity.needInitContainer;
    }

    public ProjectorAfterUpdateC2SPacket(FriendlyByteBuf buf) {
        this.mPos = buf.m_130135_();
        this.mRotation = ProjectorBlock.InternalRotation.VALUES[buf.m_130242_()];
        this.mTag = buf.m_130260_();
        this.mBoolean = buf.readBoolean();
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.mPos);
        buffer.m_130130_(this.mRotation.ordinal());
        buffer.m_130079_(this.mTag);
        buffer.writeBoolean(this.mBoolean);
    }

    public static void handle(ProjectorAfterUpdateC2SPacket packet, Supplier<NetworkEvent.Context> context) {
        ServerPlayer player = context.get().getSender();
        if (player == null) {
            context.get().setPacketHandled(true);
        } else {
            context.get().enqueueWork(() -> {
                ServerLevel level = player.m_9236_();
                BlockPos pos = packet.mPos;
                BlockEntity blockEntity = level.m_7702_(pos);
                if (ProjectorBlock.hasProjectorPermission(player) && level.m_46749_(pos) && blockEntity instanceof ProjectorBlockEntity) {
                    ProjectorBlockEntity blockEntity1 = (ProjectorBlockEntity)blockEntity;
                    BlockState state = (BlockState)blockEntity.m_58900_().m_61124_(ProjectorBlock.ROTATION, (Comparable)((Object)packet.mRotation));
                    blockEntity1.loadCompound(packet.mTag);
                    blockEntity1.needInitContainer = packet.mBoolean;
                    blockEntity.m_6596_();
                    if (!level.m_7731_(pos, state, 3)) {
                        level.m_7260_(pos, state, state, 2);
                    }
                } else {
                    GameProfile profile = player.m_36316_();
                    Slideshow.LOGGER.debug(Utilities.MARKER, "Received illegal packet for projector update: player = {}, pos = {}", (Object)profile, (Object)packet.mPos);
                }
            });
            context.get().setPacketHandled(true);
        }
    }
}

