/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.slides.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.teacon.slides.config.Config;
import org.teacon.slides.projector.ProjectorBlock;
import org.teacon.slides.projector.ProjectorBlockEntity;
import org.teacon.slides.projector.SourceType;
import org.teacon.slides.renderer.Slide;
import org.teacon.slides.renderer.SlideState;

public class ProjectorRenderer
implements BlockEntityRenderer<ProjectorBlockEntity> {
    public void render(ProjectorBlockEntity blockEntity, float partialTick, PoseStack matrices, MultiBufferSource source, int packedLight, int packedOverlay) {
        BlockState state = blockEntity.m_58900_();
        Slide slide = SlideState.getSlide(blockEntity.getLocation(), blockEntity.getFromID());
        if (blockEntity.mSourceType == SourceType.ContainerBlock) {
            SlideState.cacheSlide(blockEntity.mCNextLocation, blockEntity.mCNextFromID);
        }
        if (slide == null) {
            return;
        }
        float width = blockEntity.mWidth;
        float height = blockEntity.mHeight;
        int color = blockEntity.mColor;
        boolean isTransparent = (color & 0xFF000000) == 0;
        boolean isPowered = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_);
        boolean doubleSided = blockEntity.mDoubleSided;
        if (!isTransparent && !isPowered) {
            matrices.m_85836_();
            PoseStack.Pose lastPose = matrices.m_85850_();
            Matrix4f pose = new Matrix4f(lastPose.m_85861_());
            Matrix3f normal = new Matrix3f(lastPose.m_85864_());
            blockEntity.transformToSlideSpace(pose, normal);
            boolean flipped = ((ProjectorBlock.InternalRotation)((Object)state.m_61143_(ProjectorBlock.ROTATION))).isFlipped();
            slide.render(source, pose, normal, width, height, color, packedLight, OverlayTexture.f_118083_, flipped || doubleSided, !flipped || doubleSided, SlideState.getAnimationTick(), partialTick);
            matrices.m_85849_();
        }
    }

    public boolean shouldRenderOffScreen(ProjectorBlockEntity p_112306_) {
        return true;
    }

    public int m_142163_() {
        return Config.getRenderDistance();
    }
}

