/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.slides.texture;

import java.io.EOFException;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.teacon.slides.texture.GIFDecoder;

public class LZWDecoder {
    private int mInitCodeSize;
    private int mClearCode;
    private int mEOFCode;
    private int mCodeSize;
    private int mCodeMask;
    private int mTableIndex;
    private int mPrevCode;
    private int mBlockPos;
    private int mBlockLength;
    private final byte[] mBlock = new byte[255];
    private int mInData;
    private int mInBits;
    private final int[] mPrefix = new int[4096];
    private final byte[] mSuffix = new byte[4096];
    private final byte[] mInitial = new byte[4096];
    private final int[] mLength = new int[4096];
    private final byte[] mString = new byte[4096];
    private GIFDecoder mContext;

    public byte[] setContext(@NotNull GIFDecoder context) throws IOException {
        this.mContext = context;
        this.mBlockPos = 0;
        this.mBlockLength = 0;
        this.mInData = 0;
        this.mInBits = 0;
        this.mInitCodeSize = context.readByte();
        this.mClearCode = 1 << this.mInitCodeSize;
        this.mEOFCode = this.mClearCode + 1;
        this.initTable();
        return this.mString;
    }

    public final int readString() throws IOException {
        int code = this.getCode();
        if (code == this.mEOFCode) {
            return -1;
        }
        if (code == this.mClearCode) {
            this.initTable();
            code = this.getCode();
            if (code == this.mEOFCode) {
                return -1;
            }
        } else {
            int newSuffixIndex;
            if (code < this.mTableIndex) {
                newSuffixIndex = code;
            } else {
                newSuffixIndex = this.mPrevCode;
                if (code != this.mTableIndex) {
                    throw new IOException();
                }
            }
            if (this.mTableIndex < 4096) {
                int prevCode;
                int tableIndex = this.mTableIndex++;
                this.mPrefix[tableIndex] = prevCode = this.mPrevCode;
                this.mSuffix[tableIndex] = this.mInitial[newSuffixIndex];
                this.mInitial[tableIndex] = this.mInitial[prevCode];
                this.mLength[tableIndex] = this.mLength[prevCode] + 1;
                if (this.mTableIndex == 1 << this.mCodeSize && this.mTableIndex < 4096) {
                    ++this.mCodeSize;
                    this.mCodeMask = (1 << this.mCodeSize) - 1;
                }
            }
        }
        int c = code;
        int len = this.mLength[c];
        for (int i = len - 1; i >= 0; --i) {
            this.mString[i] = this.mSuffix[c];
            c = this.mPrefix[c];
        }
        this.mPrevCode = code;
        return len;
    }

    private void initTable() {
        int i;
        int size = 1 << this.mInitCodeSize;
        for (i = 0; i < size; ++i) {
            this.mPrefix[i] = -1;
            this.mSuffix[i] = (byte)i;
            this.mInitial[i] = (byte)i;
            this.mLength[i] = 1;
        }
        for (i = size; i < 4096; ++i) {
            this.mPrefix[i] = -1;
            this.mSuffix[i] = 0;
            this.mInitial[i] = 0;
            this.mLength[i] = 1;
        }
        this.mCodeSize = this.mInitCodeSize + 1;
        this.mCodeMask = (1 << this.mCodeSize) - 1;
        this.mTableIndex = size + 2;
        this.mPrevCode = 0;
    }

    private int getCode() throws IOException {
        while (this.mInBits < this.mCodeSize) {
            this.mInData |= this.readByte() << this.mInBits;
            this.mInBits += 8;
        }
        int code = this.mInData & this.mCodeMask;
        this.mInBits -= this.mCodeSize;
        this.mInData >>>= this.mCodeSize;
        return code;
    }

    private int readByte() throws IOException {
        if (this.mBlockPos == this.mBlockLength) {
            this.readBlock();
        }
        return this.mBlock[this.mBlockPos++] & 0xFF;
    }

    private void readBlock() throws IOException {
        this.mBlockPos = 0;
        this.mBlockLength = this.mContext.readByte();
        if (this.mBlockLength <= 0) {
            throw new EOFException();
        }
        this.mContext.readBytes(this.mBlock, 0, this.mBlockLength);
    }
}

