/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.slides.projector;

import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2614;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.teacon.slides.Slideshow;
import org.teacon.slides.network.ProjectorImageInfoS2CPayload;
import org.teacon.slides.network.ProjectorOpenScreenPayload;
import org.teacon.slides.projector.ProjectorBlock;
import org.teacon.slides.projector.ProjectorScreenHandler;
import org.teacon.slides.projector.SourceType;
import org.teacon.slides.util.RegistryServer;
import org.teacon.slides.util.Utilities;

public final class ProjectorBlockEntity
extends class_2586
implements ExtendedScreenHandlerFactory<ProjectorOpenScreenPayload> {
    public SourceType mSourceType = SourceType.URL;
    public String mLocation = "";
    public int mColor = -1;
    public float mWidth = 1.0f;
    public float mHeight = 1.0f;
    public float mOffsetX = 0.0f;
    public float mOffsetY = 0.0f;
    public float mOffsetZ = 0.0f;
    public boolean mDoubleSided = true;
    public class_1263 mContainer = null;
    public int scanIndex = -1;
    public boolean needInitContainer = false;
    public boolean needHandleReadImage = false;
    public boolean flipBack = false;
    public boolean mCFromID = false;
    public String mCLocation = "";
    public boolean mCNextFromID = false;
    public String mCNextLocation = "";

    public ProjectorBlockEntity(class_2338 pos, class_2680 state) {
        super(Slideshow.PROJECTOR_BLOCK_ENTITY, pos, state);
    }

    public void transformToSlideSpace(Matrix4f pose, Matrix3f normal) {
        class_2680 state = this.method_11010();
        class_2350 direction = (class_2350)state.method_11654((class_2769)class_2741.field_12525);
        ProjectorBlock.InternalRotation rotation = (ProjectorBlock.InternalRotation)((Object)state.method_11654(ProjectorBlock.ROTATION));
        pose.translate(0.5f, 0.5f, 0.5f);
        pose.rotate((Quaternionfc)direction.method_23224());
        normal.rotate((Quaternionfc)direction.method_23224());
        pose.translate(0.0f, 0.5f, 0.0f);
        rotation.transform(pose);
        rotation.transform(normal);
        pose.translate(-0.5f, 0.0f, 0.5f - this.mHeight);
        pose.translate(this.mOffsetX, -this.mOffsetZ, this.mOffsetY);
        pose.scale(this.mWidth, 1.0f, this.mHeight);
    }

    private boolean tryReadImageItem(class_1799 item, boolean next) {
        String loc;
        if (item.method_31574(Slideshow.IMAGE_ITEM) && (loc = (String)item.method_58694(Slideshow.LOCATION_COMPONENT)) != null) {
            if (next) {
                this.mCNextFromID = Boolean.TRUE.equals(item.method_58694(Slideshow.FROM_ID_COMPONENT));
                this.mCNextLocation = loc;
            } else {
                this.mCFromID = Boolean.TRUE.equals(item.method_58694(Slideshow.FROM_ID_COMPONENT));
                this.mCLocation = loc;
            }
            return true;
        }
        return false;
    }

    private void handleReadImage(boolean back) {
        class_1799 item;
        int i;
        int j;
        int size = this.mContainer.method_5439();
        if (size <= 0) {
            return;
        }
        int start = back ? size + this.scanIndex - 1 : this.scanIndex + 1;
        int end = back ? this.scanIndex - 1 : size + this.scanIndex + 1;
        boolean found = false;
        if (back) {
            for (j = start; j > end; --j) {
                i = j % size;
                item = this.mContainer.method_5438(i);
                if (!this.tryReadImageItem(item, false)) continue;
                this.scanIndex = i;
                found = true;
                start = i + 1;
                end = start + size;
                break;
            }
        } else {
            for (j = start; j < end; ++j) {
                i = j % size;
                item = this.mContainer.method_5438(i);
                if (!this.tryReadImageItem(item, false)) continue;
                this.scanIndex = i;
                found = true;
                start = i + 1;
                end = start + size;
                break;
            }
        }
        if (!found) {
            this.mCNextLocation = "";
            return;
        }
        for (j = start; j < end; ++j) {
            i = j % size;
            item = this.mContainer.method_5438(i);
            if (!this.tryReadImageItem(item, true)) continue;
            return;
        }
    }

    public boolean canFlip() {
        return this.mSourceType == SourceType.ContainerBlock && this.mContainer != null;
    }

    public boolean getFromID() {
        if (this.mSourceType != SourceType.ContainerBlock) {
            return this.mSourceType == SourceType.ResourceID;
        }
        return this.mCFromID;
    }

    public String getLocation() {
        if (this.mSourceType != SourceType.ContainerBlock) {
            return this.mLocation;
        }
        return this.mCLocation;
    }

    protected void method_11007(class_11372 view) {
        view.method_71469("SourceType", switch (this.mSourceType) {
            case SourceType.ResourceID -> "resource_id";
            case SourceType.ContainerBlock -> "container";
            default -> "url";
        });
        view.method_71469("ImageLocation", this.mLocation);
        view.method_71465("Color", this.mColor);
        view.method_71464("Width", this.mWidth);
        view.method_71464("Height", this.mHeight);
        view.method_71464("OffsetX", this.mOffsetX);
        view.method_71464("OffsetY", this.mOffsetY);
        view.method_71464("OffsetZ", this.mOffsetZ);
        view.method_71472("DoubleSided", this.mDoubleSided);
        view.method_71465("ScanIndex", this.scanIndex);
        view.method_71472("CFromID", this.mCFromID);
        view.method_71469("CLocation", this.mCLocation);
        view.method_71472("CNextFromID", this.mCNextFromID);
        view.method_71469("CNextLocation", this.mCNextLocation);
        super.method_11007(view);
    }

    protected void method_11014(class_11368 view) {
        this.mSourceType = switch (view.method_71428("SourceType", null)) {
            case "resource_id" -> SourceType.ResourceID;
            case "container" -> SourceType.ContainerBlock;
            default -> SourceType.URL;
        };
        this.mLocation = view.method_71428("ImageLocation", "");
        this.mColor = view.method_71424("Color", -1);
        this.mWidth = view.method_71423("Width", 1.0f);
        this.mHeight = view.method_71423("Height", 1.0f);
        this.mOffsetX = view.method_71423("OffsetX", 0.0f);
        this.mOffsetY = view.method_71423("OffsetY", 0.0f);
        this.mOffsetZ = view.method_71423("OffsetZ", 0.0f);
        this.mDoubleSided = view.method_71433("DoubleSided", true);
        this.scanIndex = view.method_71424("ScanIndex", -1);
        this.mCFromID = view.method_71433("CFromID", false);
        this.mCLocation = view.method_71428("CLocation", "");
        this.mCNextFromID = view.method_71433("CNextFromID", false);
        this.mCNextLocation = view.method_71428("CNextLocation", "");
        super.method_11014(view);
    }

    public void saveCompound(class_2487 compoundTag) {
        compoundTag.method_10582("SourceType", switch (this.mSourceType) {
            case SourceType.ResourceID -> "resource_id";
            case SourceType.ContainerBlock -> "container";
            default -> "url";
        });
        compoundTag.method_10582("ImageLocation", this.mLocation);
        compoundTag.method_10569("Color", this.mColor);
        compoundTag.method_10548("Width", this.mWidth);
        compoundTag.method_10548("Height", this.mHeight);
        compoundTag.method_10548("OffsetX", this.mOffsetX);
        compoundTag.method_10548("OffsetY", this.mOffsetY);
        compoundTag.method_10548("OffsetZ", this.mOffsetZ);
        compoundTag.method_10556("DoubleSided", this.mDoubleSided);
        compoundTag.method_10569("ScanIndex", this.scanIndex);
        compoundTag.method_10556("CFromID", this.mCFromID);
        compoundTag.method_10582("CLocation", this.mCLocation);
        compoundTag.method_10556("CNextFromID", this.mCNextFromID);
        compoundTag.method_10582("CNextLocation", this.mCNextLocation);
    }

    public void loadCompound(class_2487 compoundTag) {
        compoundTag.method_10558("SourceType").ifPresent(string -> {
            this.mSourceType = switch (string) {
                case "resource_id" -> SourceType.ResourceID;
                case "container" -> SourceType.ContainerBlock;
                default -> SourceType.URL;
            };
        });
        compoundTag.method_10558("ImageLocation").ifPresent(string -> {
            this.mLocation = string;
        });
        compoundTag.method_10550("Color").ifPresent(string -> {
            this.mColor = string;
        });
        compoundTag.method_10583("Width").ifPresent(string -> {
            this.mWidth = string.floatValue();
        });
        compoundTag.method_10583("Height").ifPresent(string -> {
            this.mHeight = string.floatValue();
        });
        compoundTag.method_10583("OffsetX").ifPresent(string -> {
            this.mOffsetX = string.floatValue();
        });
        compoundTag.method_10583("OffsetY").ifPresent(string -> {
            this.mOffsetY = string.floatValue();
        });
        compoundTag.method_10583("OffsetZ").ifPresent(string -> {
            this.mOffsetZ = string.floatValue();
        });
        compoundTag.method_10577("DoubleSided").ifPresent(string -> {
            this.mDoubleSided = string;
        });
        compoundTag.method_10550("ScanIndex").ifPresent(string -> {
            this.scanIndex = string;
        });
        compoundTag.method_10577("CFromID").ifPresent(string -> {
            this.mCFromID = string;
        });
        compoundTag.method_10558("CLocation").ifPresent(string -> {
            this.mCLocation = string;
        });
        compoundTag.method_10577("CNextFromID").ifPresent(string -> {
            this.mCNextFromID = string;
        });
        compoundTag.method_10558("CNextLocation").ifPresent(string -> {
            this.mCNextLocation = string;
        });
    }

    public void sync() {
        Utilities.forPlayersTacking(this, player -> RegistryServer.sendToPlayer(player, new ProjectorImageInfoS2CPayload(this)));
    }

    public static void tick(class_1937 world, class_2338 pos, ProjectorBlockEntity entity) {
        if (world.method_8608()) {
            return;
        }
        if (entity.mSourceType != SourceType.ContainerBlock) {
            return;
        }
        entity.mContainer = class_2614.method_11250((class_1937)world, (class_2338)ProjectorBlockEntity.tryParseCoor(entity.mLocation, pos));
        if (entity.mContainer == null) {
            entity.mCLocation = "";
            entity.mCNextLocation = "";
            entity.scanIndex = -1;
            return;
        }
        if (entity.needInitContainer) {
            entity.scanIndex = -1;
            entity.handleReadImage(false);
            entity.needInitContainer = false;
            entity.method_5431();
            entity.sync();
            return;
        }
        if (entity.needHandleReadImage) {
            if (entity.scanIndex < 0) {
                entity.scanIndex = -1;
                entity.handleReadImage(false);
                return;
            }
            entity.handleReadImage(entity.flipBack);
            entity.method_5431();
            entity.sync();
            entity.needHandleReadImage = false;
            entity.flipBack = false;
        }
    }

    private static class_2338 tryParseCoor(String coor, class_2338 pos) {
        try {
            String[] xyz = coor.split("\\s+");
            int[] nPos = new int[3];
            String x = xyz[0];
            nPos[0] = x.startsWith("~") ? pos.method_10263() + ProjectorBlockEntity.parseInt(x.substring(1)) : ProjectorBlockEntity.parseInt(x);
            String y = xyz[1];
            nPos[1] = y.startsWith("~") ? pos.method_10264() + ProjectorBlockEntity.parseInt(y.substring(1)) : ProjectorBlockEntity.parseInt(y);
            String z = xyz[2];
            nPos[2] = z.startsWith("~") ? pos.method_10260() + ProjectorBlockEntity.parseInt(z.substring(1)) : ProjectorBlockEntity.parseInt(z);
            return new class_2338(nPos[0], nPos[1], nPos[2]);
        }
        catch (Exception e) {
            return pos.method_10074();
        }
    }

    private static int parseInt(String s) {
        if (s.isEmpty()) {
            return 0;
        }
        return Integer.parseInt(s);
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        class_2487 compoundTag = new class_2487();
        this.saveCompound(compoundTag);
        return compoundTag;
    }

    public class_2561 method_5476() {
        return class_2561.method_43470((String)"");
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new ProjectorScreenHandler(syncId, new ProjectorOpenScreenPayload(this.field_11867));
    }

    public ProjectorOpenScreenPayload getScreenOpeningData(class_3222 serverPlayerEntity) {
        return new ProjectorOpenScreenPayload(this.field_11867);
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }
}

