/*
 * Decompiled with CFR 0.152.
 */
package lightningtow.hudify;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.http.HttpResponse;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import javax.imageio.ImageIO;
import lightningtow.hudify.HudifyConfig;
import lightningtow.hudify.integrations.CustomhudIntegration;
import lightningtow.hudify.util.SpotifyData;
import lightningtow.hudify.util.SpotifyUtil;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;

public class HudifyMain
implements ClientModInitializer {
    public static final String MOD_ID = "hudify";
    public static final String MOD_DISPLAY_NAME = "Hudify";
    private static boolean toggleKeyPrevState = false;
    private static boolean nextKeyPrevState = false;
    private static boolean prevKeyPrevState = false;
    private static final ExecutorService EXECUTOR_SERVICE = Executors.newSingleThreadExecutor();
    public static final int jsonImageChoice = 2;
    public static final boolean DUMPING = false;
    private static final class_304.class_11900 HUDIFY_CATEGORY = class_304.class_11900.method_74698((class_2960)class_2960.method_60654((String)"hudify"));

    public static void dump(String source) {
        if (HudifyConfig.db) {
            HudifyMain.LogThis(Level.INFO, String.join((CharSequence)", ", "dump from " + source + " - Status Code " + SpotifyData.sp_status_code, "(" + SpotifyData.sp_progress + " / " + SpotifyData.sp_duration + ")", SpotifyData.sp_track, SpotifyData.sp_first_artist, "(" + SpotifyData.sp_artists + ")", SpotifyData.sp_context_type));
        }
    }

    private static void tick_message() {
        if (SpotifyData.sp_msg_time_rem > 0) {
            --SpotifyData.sp_msg_time_rem;
        } else {
            SpotifyData.set_sp_message("");
        }
    }

    public static void send_message(String msg, int msg_dur) {
        SpotifyData.sp_msg_time_rem = msg_dur;
        SpotifyData.set_sp_message(msg);
    }

    public static String tryTruncate(String victim) {
        int len = HudifyConfig.truncate_length;
        if (len == -1) {
            return victim;
        }
        String thing = victim;
        thing = victim.length() > len ? victim.substring(0, len).trim() + "..." : victim;
        return thing;
    }

    public static void LogThis(Level lvl, String msg) {
        msg = "(Hudify) " + (String)msg;
        LogManager.getLogger((String)MOD_DISPLAY_NAME).log(lvl, (String)msg);
    }

    public static void getAlbumArt() {
        class_310 client = class_310.method_1551();
        class_2960 TEXTURE_NOT_FOUND = class_2960.method_60654((String)"textures/item/barrier.png");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            HudifyMain.LogThis(Level.INFO, "link: " + SpotifyData.g_album_art_link);
            InputStream inputStream = SpotifyData.g_album_art_link == null || SpotifyData.g_album_art_link.isEmpty() ? new URL("https://i.scdn.co/image/ab67616d00001e02ff9ca10b55ce82ae553c8228").openStream() : new URL(SpotifyData.g_album_art_link).openStream();
            HudifyMain.LogThis(Level.INFO, "1");
            int targetsize = 256;
            HudifyMain.LogThis(Level.INFO, "before read");
            BufferedImage bufferedImage = ImageIO.read(inputStream);
            HudifyMain.LogThis(Level.INFO, "after read");
            HudifyMain.LogThis(Level.INFO, "2");
            ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
            bufferedImage = null;
            HudifyMain.LogThis(Level.INFO, "2b");
            byte[] byteArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream = null;
            HudifyMain.LogThis(Level.INFO, "3");
            SpotifyData.g_native_image = class_1011.method_49277((byte[])byteArray);
            HudifyMain.LogThis(Level.INFO, "4");
            String hi = "hi";
            Supplier<String> nameSupplier = new Supplier<String>(){

                @Override
                public String get() {
                    return "hi";
                }
            };
            HudifyMain.LogThis(Level.INFO, "5");
            class_1043 nativeImageBackedTexture = new class_1043((Supplier)nameSupplier, SpotifyData.g_native_image);
            HudifyMain.LogThis(Level.INFO, "5.5");
            client.method_1531().method_4615(SpotifyData.g_album_art_identifier);
            HudifyMain.LogThis(Level.INFO, "6");
            client.method_1531().method_4616(SpotifyData.g_album_art_identifier, (class_1044)nativeImageBackedTexture);
            HudifyMain.LogThis(Level.INFO, "7");
            HudifyMain.LogThis(Level.INFO, "8");
            inputStream.close();
        }
        catch (IOException e) {
            HudifyMain.LogThis(Level.ERROR, "error in try(InputStream) in CustomHudExtender: " + Arrays.toString(e.getStackTrace()));
        }
    }

    public static void genBracketVariables(String trackname) {
        SpotifyData.sp_track = HudifyMain.tryTruncate(trackname);
        SpotifyData.sp_track_smartbrackets = HudifyMain.tryTruncate(SpotifyUtil.smartbrackets(trackname));
        SpotifyData.sp_track_nobrackets = HudifyMain.tryTruncate(SpotifyUtil.nobrackets(trackname));
    }

    public void onInitializeClient() {
        try {
            CustomhudIntegration.initCustomhud();
            HudifyMain.LogThis(Level.INFO, "Successfully integrated with CustomHud");
        }
        catch (Exception e) {
            HudifyMain.LogThis(Level.ERROR, "Error integrating with CustomHud: " + String.valueOf(e));
        }
        HudifyConfig.init((String)MOD_ID, HudifyConfig.class);
        SpotifyUtil.initialize();
        SpotifyData.resetData();
        Thread requestThread = new Thread(() -> {
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(HudifyConfig.poll_rate);
                        if (class_310.method_1551().field_1687 == null) {
                            Thread.sleep(HudifyConfig.inactive_poll_rate);
                            SpotifyData.sp_progress = 0;
                            SpotifyData.sp_duration = -1;
                            continue;
                        }
                        HudifyMain.updatePlaybackInfo();
                        HudifyMain.tick_message();
                        if (SpotifyData.sp_status_code == 204) {
                            SpotifyUtil.refreshActiveSession();
                            Thread.sleep(HudifyConfig.inactive_poll_rate);
                            continue;
                        }
                        if (SpotifyData.sp_status_code != 429) continue;
                        HudifyMain.LogThis(Level.ERROR, "RATE LIMITED============================================================");
                        Thread.sleep(3000L);
                    }
                }
                catch (InterruptedException e) {
                    HudifyMain.LogThis(Level.ERROR, "error in main loop: " + Arrays.toString(e.getStackTrace()));
                    continue;
                }
                break;
            }
        });
        requestThread.setName("Spotify Thread");
        requestThread.start();
        HudifyMain.registerKeyBindings();
    }

    public static void updatePlaybackInfo() {
        block24: {
            Object dump_msg = "updatePlaybackInfo";
            try {
                String albumart;
                HttpResponse<String> playbackResponse = SpotifyUtil.getClient().send(SpotifyUtil.getPlaybackRequest(), HttpResponse.BodyHandlers.ofString());
                SpotifyData.sp_status_code = playbackResponse.statusCode();
                if (playbackResponse.statusCode() == 429) {
                    return;
                }
                if (playbackResponse.statusCode() == 401) {
                    if (!SpotifyUtil.refreshAccessToken()) {
                        SpotifyData.sp_is_authorized = false;
                    }
                    break block24;
                }
                if (playbackResponse.statusCode() != 200) break block24;
                JsonObject json = (JsonObject)JsonParser.parseString((String)playbackResponse.body());
                boolean truncating = HudifyConfig.truncate_length != -1;
                int len = HudifyConfig.truncate_length;
                dump_msg = (String)dump_msg + " " + String.valueOf(json.get("progress_ms")) + " / " + String.valueOf(json.get("item").getAsJsonObject().get("duration_ms"));
                SpotifyData.sp_is_podcast = json.get("currently_playing_type").getAsString().equals("episode");
                SpotifyData.sp_progress = json.get("progress_ms").getAsInt() / 1000;
                SpotifyData.sp_duration = json.get("item").getAsJsonObject().get("duration_ms").getAsInt() / 1000;
                SpotifyData.sp_shuffle_enabled = json.get("shuffle_state").getAsBoolean();
                SpotifyData.sp_repeat_state = json.get("repeat_state").getAsString();
                if (SpotifyData.sp_repeat_state.equals("context")) {
                    SpotifyData.sp_repeat_state = "all";
                }
                HudifyMain.genBracketVariables(json.get("item").getAsJsonObject().get("name").getAsString());
                SpotifyData.g_album_art_link = albumart = json.get("item").getAsJsonObject().get("album").getAsJsonObject().get("images").getAsJsonArray().get(2).getAsJsonObject().get("url").getAsString();
                if (SpotifyData.g_prev_album_art_link.isEmpty() || !SpotifyData.g_prev_album_art_link.equals(albumart)) {
                    HudifyMain.LogThis(Level.INFO, "album art links do NOT match, running getAlbumArt");
                    SpotifyData.g_prev_album_art_link = albumart;
                    try {
                        HudifyMain.getAlbumArt();
                        HudifyMain.LogThis(Level.INFO, "got album art");
                    }
                    catch (Exception e) {
                        HudifyMain.LogThis(Level.ERROR, "exception caught in getAlbumArt(): " + e.getMessage() + " " + Arrays.toString(e.getStackTrace()));
                    }
                }
                SpotifyData.sp_device_id = json.get("device").getAsJsonObject().get("id").getAsString();
                SpotifyData.sp_device_is_active = json.get("device").getAsJsonObject().get("is_active").getAsBoolean();
                SpotifyData.sp_device_name = json.get("device").getAsJsonObject().get("name").getAsString();
                SpotifyData.sp_is_playing = json.get("is_playing").getAsBoolean();
                JsonObject contextJson = json.get("context").getAsJsonObject();
                SpotifyData.sp_context_type = contextJson.get("type").getAsString();
                SpotifyData.sp_prev_context = SpotifyData.sp_context_name;
                if (!SpotifyData.sp_prev_context_uri.equals(contextJson.get("uri").getAsString()) || SpotifyData.sp_prev_context.isEmpty()) {
                    if (HudifyConfig.db) {
                        // empty if block
                    }
                    SpotifyData.sp_prev_context_uri = contextJson.get("uri").getAsString();
                    switch (SpotifyData.sp_context_type) {
                        case "album": {
                            SpotifyData.sp_context_name = SpotifyData.sp_album;
                            break;
                        }
                        case "show": {
                            SpotifyData.sp_context_name = SpotifyData.sp_artists;
                            break;
                        }
                        case "artist": 
                        case "playlist": {
                            EXECUTOR_SERVICE.execute(() -> {
                                JsonObject fullContextJson = SpotifyUtil.apiRequest(SpotifyUtil.reqType.GET, contextJson.get("href").getAsString());
                                SpotifyData.sp_context_name = fullContextJson == null ? "" : fullContextJson.get("name").getAsString().replaceAll("\"", "");
                            });
                        }
                    }
                }
                if (SpotifyData.sp_is_podcast.booleanValue()) {
                    String show;
                    SpotifyData.sp_artists = show = json.get("item").getAsJsonObject().get("show").getAsJsonObject().get("name").getAsString();
                    SpotifyData.sp_first_artist = show;
                    SpotifyData.sp_album = "";
                    HudifyMain.dump((String)dump_msg);
                    return;
                }
                JsonArray artistArray = json.get("item").getAsJsonObject().get("artists").getAsJsonArray();
                StringBuilder artistString = new StringBuilder(artistArray.get(0).getAsJsonObject().get("name").getAsString());
                SpotifyData.sp_first_artist = artistString.toString();
                for (int i = 1; i < artistArray.size(); ++i) {
                    artistString.append(", ").append(artistArray.get(i).getAsJsonObject().get("name").getAsString());
                }
                SpotifyData.sp_artists = HudifyMain.tryTruncate(artistString.toString());
                SpotifyData.sp_album = HudifyMain.tryTruncate(json.get("item").getAsJsonObject().get("album").getAsJsonObject().get("name").getAsString());
                SpotifyData.UpdateMaps();
            }
            catch (Exception e) {
                HudifyMain.LogThis(Level.ERROR, "exception caught in updatePlaybackInfo(): " + e.getMessage() + " " + Arrays.toString(e.getStackTrace()));
            }
        }
    }

    public static void registerKeyBindings() {
        HudifyMain.registerToggleKey();
        HudifyMain.registerNextKey();
        HudifyMain.registerPrevKey();
    }

    private static void registerToggleKey() {
        class_304 newKey = new class_304("hudify.key.toggle", class_3675.class_307.field_1668, -1, HUDIFY_CATEGORY);
        KeyBindingHelper.registerKeyBinding((class_304)newKey);
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (newKey.method_1436() && !toggleKeyPrevState) {
                if (SpotifyData.sp_is_authorized.booleanValue()) {
                    if (HudifyConfig.db) {
                        HudifyMain.LogThis(Level.INFO, "Toggle key pressed");
                    }
                    SpotifyUtil.togglePlayPause();
                } else {
                    SpotifyUtil.authorize();
                }
            }
            toggleKeyPrevState = newKey.method_1436();
        });
    }

    private static void registerNextKey() {
        class_304 newKey = new class_304("hudify.key.next", class_3675.class_307.field_1668, class_3675.field_16237.method_1444(), HUDIFY_CATEGORY);
        KeyBindingHelper.registerKeyBinding((class_304)newKey);
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (newKey.method_1436() && !nextKeyPrevState) {
                if (SpotifyData.sp_is_authorized.booleanValue()) {
                    if (HudifyConfig.db) {
                        HudifyMain.LogThis(Level.INFO, "Next key pressed");
                    }
                    SpotifyUtil.nextSong();
                } else {
                    SpotifyUtil.authorize();
                }
            }
            nextKeyPrevState = newKey.method_1436();
        });
    }

    private static void registerPrevKey() {
        class_304 newKey = new class_304("hudify.key.prev", class_3675.class_307.field_1668, class_3675.field_16237.method_1444(), HUDIFY_CATEGORY);
        KeyBindingHelper.registerKeyBinding((class_304)newKey);
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (newKey.method_1436() && !prevKeyPrevState) {
                if (SpotifyData.sp_is_authorized.booleanValue()) {
                    if (HudifyConfig.db) {
                        HudifyMain.LogThis(Level.INFO, "Prev key pressed");
                    }
                    SpotifyUtil.prevSong();
                } else {
                    SpotifyUtil.authorize();
                }
            }
            prevKeyPrevState = newKey.method_1436();
        });
    }
}

