/*
 * Decompiled with CFR 0.152.
 */
package lightningtow.hudify.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.sun.net.httpserver.HttpServer;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Scanner;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import lightningtow.hudify.HudifyConfig;
import lightningtow.hudify.HudifyMain;
import lightningtow.hudify.util.AuthServerHandler;
import lightningtow.hudify.util.SpotifyData;
import net.minecraft.class_156;
import org.apache.logging.log4j.Level;

public class SpotifyUtil {
    private static String verifier;
    private static String authCode;
    private static String accessToken;
    private static String refreshToken;
    private static final String tokenAddress = "https://accounts.spotify.com/api/token";
    private static HttpClient client;
    private static HttpServer authServer;
    private static ThreadPoolExecutor threadPoolExecutor;
    private static HttpRequest playbackRequest;
    private static File authFile;
    private static final String auth_filename = "hudify_tokens_dont_edit.json";
    private static final ExecutorService EXECUTOR_SERVICE;

    public static String get_client_id() {
        return HudifyConfig.CLIENT_ID.trim();
    }

    public static String get_redirect_uri() {
        return SpotifyUtil.encodeURL(HudifyConfig.CALLBACK_URI.trim());
    }

    public static HttpClient getClient() {
        return client;
    }

    public static HttpRequest getPlaybackRequest() {
        return playbackRequest;
    }

    private static String encodeURL(String url) {
        String newurl = URLEncoder.encode(url, StandardCharsets.UTF_8);
        HudifyMain.LogThis(Level.DEBUG, "encoding url " + url + " to " + newurl);
        return newurl;
    }

    public static void initialize() {
        HudifyMain.LogThis(Level.INFO, "initializing Spotify integration");
        authFile = new File(System.getProperty("user.dir") + File.separator + "config" + File.separator + auth_filename);
        try {
            if (!authFile.exists()) {
                boolean fileCreated = authFile.createNewFile();
                if (fileCreated) {
                    HudifyMain.LogThis(Level.INFO, "Created new token file at: " + authFile.getAbsolutePath());
                }
                accessToken = "";
                refreshToken = "";
                SpotifyData.sp_is_authorized = false;
                SpotifyUtil.authorize();
            } else {
                Scanner scan = new Scanner(authFile);
                if (scan.hasNextLine()) {
                    JsonObject authJson = JsonParser.parseString((String)scan.nextLine()).getAsJsonObject();
                    accessToken = authJson.get("access_token").getAsString();
                    refreshToken = authJson.get("refresh_token").getAsString();
                    SpotifyData.sp_is_authorized = true;
                } else {
                    accessToken = "";
                    refreshToken = "";
                    SpotifyData.sp_is_authorized = false;
                }
                scan.close();
            }
        }
        catch (IOException e) {
            HudifyMain.LogThis(Level.ERROR, "exception caught in initialize():" + e.getMessage());
        }
        client = HttpClient.newHttpClient();
        SpotifyUtil.updatePlaybackRequest();
    }

    public static void authorize() {
        if (HudifyConfig.db) {
            HudifyMain.LogThis(Level.INFO, "running SpotifyUtil.authorize()");
        }
        if (SpotifyUtil.get_client_id().trim().isEmpty()) {
            HudifyMain.LogThis(Level.INFO, "Could not authorize, empty client ID");
            HudifyMain.send_message("Could not authorize, empty client ID", 3);
            return;
        }
        StringBuilder authURI = null;
        String[] scope_list = new String[]{"user-read-playback-state", "user-modify-playback-state", "playlist-read-private"};
        try {
            authURI = new StringBuilder();
            authURI.append("https://accounts.spotify.com/authorize");
            authURI.append("?client_id=").append(SpotifyUtil.get_client_id());
            authURI.append("&response_type=code");
            authURI.append("&redirect_uri=").append(SpotifyUtil.get_redirect_uri());
            authURI.append("&scope=");
            for (String scope : scope_list) {
                authURI.append("%20").append(scope);
            }
            authURI.append("&code_challenge_method=S256");
            verifier = AuthServerHandler.generateCodeVerifier();
            String challenge = AuthServerHandler.generateCodeChallenge(verifier);
            authURI.append("&code_challenge=").append(challenge);
            authServer = HttpServer.create(new InetSocketAddress("127.0.0.1", 8001), 0);
            threadPoolExecutor = (ThreadPoolExecutor)Executors.newFixedThreadPool(10);
            authServer.setExecutor(threadPoolExecutor);
            authServer.createContext("/callback", new AuthServerHandler());
            authServer.start();
        }
        catch (Exception e) {
            HudifyMain.LogThis(Level.ERROR, "exception caught in SpotifyUtil.authorize():" + e.getMessage());
        }
        if (authURI == null) {
            HudifyMain.LogThis(Level.INFO, "Could not authorize, authURI is null");
            HudifyMain.send_message("Could not authorize, authURI is null", 3);
            return;
        }
        HudifyMain.LogThis(Level.INFO, "Sucessfully opened authorization prompt");
        class_156.method_668().method_670(authURI.toString());
    }

    public static void authorize(String authCode) {
        SpotifyUtil.authCode = authCode;
        authServer.stop(0);
        threadPoolExecutor.shutdown();
        SpotifyUtil.requestAccessToken();
    }

    private static void requestAccessToken() {
        if (HudifyConfig.db) {
            HudifyMain.LogThis(Level.INFO, "running SpotifyUtil.requestAccessToken");
        }
        try {
            StringBuilder accessBody = new StringBuilder();
            accessBody.append("grant_type=authorization_code");
            accessBody.append("&code=").append(authCode);
            accessBody.append("&redirect_uri=").append(SpotifyUtil.get_redirect_uri());
            accessBody.append("&client_id=").append(SpotifyUtil.get_client_id());
            accessBody.append("&code_verifier=").append(verifier);
            HttpRequest accessRequest = HttpRequest.newBuilder(new URI(tokenAddress)).header("Content-Type", "application/x-www-form-urlencoded").header("Accept", "application/json").POST(HttpRequest.BodyPublishers.ofString(accessBody.toString())).build();
            if (HudifyConfig.db) {
                HudifyMain.LogThis(Level.INFO, "url request " + String.valueOf(accessBody));
            }
            HttpResponse<String> accessResponse = client.send(accessRequest, HttpResponse.BodyHandlers.ofString());
            JsonObject accessJson = JsonParser.parseString((String)accessResponse.body()).getAsJsonObject();
            accessToken = accessJson.get("access_token").getAsString();
            refreshToken = accessJson.get("refresh_token").getAsString();
            SpotifyUtil.updatePlaybackRequest();
            SpotifyUtil.writeAuthFile();
            SpotifyData.sp_is_authorized = true;
        }
        catch (Exception e) {
            HudifyMain.LogThis(Level.ERROR, "exception caught in requestAccessToken():" + e.getMessage());
        }
    }

    public static boolean refreshAccessToken() {
        block4: {
            if (HudifyConfig.db) {
                HudifyMain.LogThis(Level.INFO, "running SpotifyUtil.refreshAccessToken");
            }
            try {
                String refreshRequestBody = "grant_type=refresh_token&refresh_token=" + refreshToken + "&client_id=" + SpotifyUtil.get_client_id();
                HttpRequest refreshRequest = HttpRequest.newBuilder(new URI(tokenAddress)).header("Content-Type", "application/x-www-form-urlencoded").header("Accept", "application/json").POST(HttpRequest.BodyPublishers.ofString(refreshRequestBody)).build();
                HttpResponse<String> refreshResponse = client.send(refreshRequest, HttpResponse.BodyHandlers.ofString());
                if (refreshResponse.statusCode() == 200) {
                    JsonObject refreshJson = JsonParser.parseString((String)refreshResponse.body()).getAsJsonObject();
                    accessToken = refreshJson.get("access_token").getAsString();
                    refreshToken = refreshJson.get("refresh_token").getAsString();
                    SpotifyUtil.writeAuthFile();
                    SpotifyUtil.updatePlaybackRequest();
                    return true;
                }
            }
            catch (Exception e) {
                if (!HudifyConfig.db) break block4;
                HudifyMain.LogThis(Level.ERROR, "exception caught in refreshAccessToken():" + e.getMessage());
            }
        }
        return false;
    }

    public static void refreshActiveSession() {
        block6: {
            try {
                String playerAddress = "https://api.spotify.com/v1/me/player/";
                HttpRequest getDevices = HttpRequest.newBuilder(new URI(playerAddress + "devices")).header("Authorization", "Bearer " + accessToken).header("Accept", "application/json").build();
                HttpResponse<String> devices = client.send(getDevices, HttpResponse.BodyHandlers.ofString());
                JsonArray devicesJson = JsonParser.parseString((String)devices.body()).getAsJsonObject().get("devices").getAsJsonArray();
                String computerName = InetAddress.getLocalHost().getHostName();
                String thisDeviceID = "";
                if (devicesJson.isEmpty()) {
                    SpotifyData.sp_duration = 1;
                    SpotifyData.sp_progress = 0;
                    if (HudifyConfig.db) {
                        HudifyMain.LogThis(Level.INFO, "SpotifyUtil.refreshActiveSession: no active device");
                    }
                    SpotifyData.sp_is_playing = false;
                    return;
                }
                for (int i = 0; i < devicesJson.size(); ++i) {
                    JsonObject currDevice = devicesJson.get(i).getAsJsonObject();
                    if (!currDevice.get("name").getAsString().equals(computerName)) continue;
                    thisDeviceID = currDevice.get("id").getAsString();
                    break;
                }
                String deviceIDBody = "{\"device_ids\" : [\"" + thisDeviceID + "\"]}";
                HttpRequest setActive = HttpRequest.newBuilder(new URI(playerAddress)).header("Authorization", "Bearer " + accessToken).PUT(HttpRequest.BodyPublishers.ofString(deviceIDBody)).build();
                if (HudifyConfig.db) {
                    HudifyMain.LogThis(Level.INFO, "RefreshActiveSession - API responded with status code: " + client.send(setActive, HttpResponse.BodyHandlers.ofString()).statusCode());
                }
            }
            catch (Exception e) {
                if (!HudifyConfig.db) break block6;
                HudifyMain.LogThis(Level.ERROR, "exception caught in refreshActiveSession():" + e.getMessage());
            }
        }
    }

    public static void writeAuthFile() {
        try {
            FileWriter jsonWriter = new FileWriter(authFile);
            jsonWriter.write("{\"access_token\" : \"" + accessToken + "\", \"refresh_token\" : \"" + refreshToken + "\" }");
            jsonWriter.flush();
            jsonWriter.close();
        }
        catch (IOException e) {
            HudifyMain.LogThis(Level.ERROR, e.getMessage());
        }
    }

    public static void updatePlaybackRequest() {
        playbackRequest = HttpRequest.newBuilder(URI.create("https://api.spotify.com/v1/me/player?additional_types=episode")).header("Accept", "application/json").header("Authorization", "Bearer " + accessToken).header("Content-Type", "application/json").build();
    }

    public static JsonObject apiRequest(reqType type, String url) {
        try {
            if (HudifyConfig.db) {
                // empty if block
            }
            HttpRequest.Builder reqBuilder = HttpRequest.newBuilder(new URI(url));
            switch (type.ordinal()) {
                case 0: {
                    reqBuilder.GET();
                    break;
                }
                case 2: {
                    reqBuilder.PUT(HttpRequest.BodyPublishers.ofString(""));
                    break;
                }
                case 1: {
                    reqBuilder.POST(HttpRequest.BodyPublishers.ofString(""));
                    break;
                }
                case 3: {
                    reqBuilder.DELETE();
                }
            }
            reqBuilder.header("Authorization", "Bearer " + accessToken).build();
            HttpRequest request = reqBuilder.build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            if (HudifyConfig.db) {
                // empty if block
            }
            if (response.statusCode() == 200) {
                return null;
            }
            if (response.statusCode() == 200) {
                return null;
            }
            if (response.statusCode() == 401) {
                if (SpotifyUtil.refreshAccessToken()) {
                    SpotifyUtil.apiRequest(type, url);
                } else {
                    SpotifyData.sp_is_authorized = false;
                }
            } else if (response.statusCode() == 403) {
                if (HudifyConfig.db) {
                    HudifyMain.LogThis(Level.INFO, "403:" + String.valueOf(response));
                }
            } else if (response.statusCode() == 404) {
                SpotifyUtil.refreshActiveSession();
                if (HudifyConfig.db) {
                    HudifyMain.LogThis(Level.INFO, "Retrying get request...");
                }
                response = client.send(request, HttpResponse.BodyHandlers.ofString());
            } else if (response.statusCode() == 429) {
                HudifyMain.LogThis(Level.ERROR, "RATE LIMITED============================================================");
                Thread.sleep(3000L);
                return null;
            }
            if (response.body().isEmpty()) {
                return null;
            }
            try {
                return (JsonObject)JsonParser.parseString((String)response.body());
            }
            catch (Exception e) {
                HudifyMain.LogThis(Level.ERROR, "Error parsing api response:" + String.valueOf((Object)type) + " request " + url + " returned 403 forbidden");
                return null;
            }
        }
        catch (IOException | InterruptedException | URISyntaxException e) {
            if (e instanceof IOException && e.getMessage().equals("Connection reset")) {
                HudifyMain.LogThis(Level.INFO, "Attempting to retry get request...");
                SpotifyUtil.apiRequest(type, url);
                HudifyMain.LogThis(Level.INFO, "Successfully sent get request");
            } else {
                HudifyMain.LogThis(Level.ERROR, "exception caught in getRequest(): " + e.getMessage());
            }
            return null;
        }
    }

    public static String nobrackets(String input) {
        char[] blacklist = new char[]{'{', '(', '-'};
        String output = "";
        char x1 = '(';
        char x2 = '[';
        char x3 = '{';
        char x4 = '-';
        char x5 = '\u2013';
        int len = input.length();
        for (int i = 0; i < len; ++i) {
            char c = input.charAt(i);
            if (c != x1 && c != x2 && c != x3 && c != x4 && c != x5) continue;
            output = input.substring(0, i - 1);
            return output;
        }
        return input;
    }

    public static String smartbrackets(String input) {
        String output = input;
        ArrayList<String> blacklist = new ArrayList<String>();
        blacklist.add("bonus track");
        blacklist.add("bonus");
        blacklist.add("intro");
        blacklist.add("outro");
        blacklist.add("interlude");
        blacklist.add("cover");
        blacklist.add("remix");
        blacklist.add("david garrett edition");
        blacklist.add("original mix");
        blacklist.add("single version");
        blacklist.add("recorded at spotify singles nyc");
        blacklist.add("spotify singles");
        blacklist.add("single mix");
        blacklist.add("remastere?d? [0-9]{4} \\/ remixed");
        blacklist.add("remastere?d? [0-9]{4}$");
        blacklist.add("[0-9]{4} - remastere?d?");
        blacklist.add("[0-9]{4} remastere?d?");
        blacklist.add("remastere?d?");
        blacklist.add("single");
        blacklist.add("music from [\\w\\s]*");
        blacklist.add("from [^\\])]*");
        if (HudifyConfig.smartbrackets_kill_featuring) {
            blacklist.add("with [^\\])]*");
            blacklist.add("featuring [\\w\\s]*");
            blacklist.add("feat. [\\w\\s]*");
            blacklist.add("ft[^\\])]*");
        }
        ArrayList<Object> real_blacklist = new ArrayList<Object>();
        for (String string : blacklist) {
            real_blacklist.add(" - Spider-Man: Across the Spider-Verse");
            real_blacklist.add(" - " + string);
            real_blacklist.add(" \u2013 " + string);
            real_blacklist.add("\\/\\/ " + string);
            real_blacklist.add("\\(" + string + "\\)");
            real_blacklist.add("\\[" + string + "\\]");
        }
        for (String string : real_blacklist) {
            String regex = "(?i)" + string;
            output = output.replaceAll(regex, "");
        }
        return output.trim();
    }

    public static void nextSong() {
        EXECUTOR_SERVICE.execute(() -> {
            SpotifyUtil.apiRequest(reqType.POST, "https://api.spotify.com/v1/me/player/next");
            SpotifyData.sp_duration = -2;
            HudifyMain.LogThis(Level.INFO, "Skipping to next song");
        });
    }

    public static void prevSong() {
        EXECUTOR_SERVICE.execute(() -> {
            SpotifyUtil.apiRequest(reqType.POST, "https://api.spotify.com/v1/me/player/previous");
            SpotifyData.sp_duration = -2;
            HudifyMain.LogThis(Level.INFO, "Skipping to previous song");
        });
    }

    public static void togglePlayPause() {
        if (SpotifyData.sp_is_playing.booleanValue()) {
            if (HudifyConfig.db) {
                HudifyMain.send_message("Paused playback", 3);
            }
            HudifyMain.LogThis(Level.INFO, "Pausing playback");
            EXECUTOR_SERVICE.execute(() -> SpotifyUtil.apiRequest(reqType.PUT, "https://api.spotify.com/v1/me/player/pause"));
        } else {
            if (HudifyConfig.db) {
                HudifyMain.send_message("Resumed playback", 3);
            }
            HudifyMain.LogThis(Level.INFO, "Resuming playback");
            EXECUTOR_SERVICE.execute(() -> SpotifyUtil.apiRequest(reqType.PUT, "https://api.spotify.com/v1/me/player/play"));
        }
    }

    static {
        EXECUTOR_SERVICE = Executors.newSingleThreadExecutor();
    }

    public static enum reqType {
        GET,
        POST,
        PUT,
        DELETE;

    }
}

