/*
 * Decompiled with CFR 0.152.
 */
package com.example.pmshaders;

import com.example.pmshaders.IrisDetector;

public final class IrisIntegration {
    private IrisIntegration() {
    }

    public static void attemptRegisterCloudsShader() {
        if (!IrisDetector.isIrisPresent()) {
            return;
        }
        System.out.println("PMShaders: Iris detected, PMWeather shader creation is disabled. Add Iris registration here if desired.");
        String[] candidates = new String[]{"me.jellysquid.mods.iris.api.IrisAPI", "me.jellysquid.mods.iris.client.IrisClient", "me.jellysquid.mods.iris.client.render.PostProcessing", "me.jellysquid.mods.iris.client.render.IrisPostProcessor"};
        boolean found = false;
        for (String clsName : candidates) {
            try {
                Class<?> c = Class.forName(clsName);
                System.out.println("Found Iris class: " + clsName + " -> " + String.valueOf(c));
                found = true;
            }
            catch (ClassNotFoundException c) {
            }
            catch (Throwable t) {
                System.out.println("Error checking Iris class " + clsName + ": " + String.valueOf(t));
            }
        }
        if (!found) {
            System.out.println("PMShaders: No known Iris classes found; full Iris integration requires the Iris API and may need updating for your Iris version.");
        } else {
            System.out.println("PMShaders: You can now add reflection code to register the shader JSON with Iris' postprocessing in this method.");
        }
    }
}

