/*
 * Decompiled with CFR 0.152.
 */
package dev.fixyl.componentviewer.config.keymapping;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;

public class AdvancedKeyMapping
extends KeyMapping {
    public static final String GENERAL_CATEGORY = "key.category.componentviewer.controls";
    public static final String CONFIG_CATEGORY = "key.category.componentviewer.controls.cycle_configs";
    private final ConflictContext conflictContext;

    public AdvancedKeyMapping(String translationKey, int keyCode, String category, ConflictContext conflictContext) {
        super(translationKey, keyCode, category);
        this.conflictContext = conflictContext;
    }

    public AdvancedKeyMapping(String translationKey, int keyCode, String category) {
        this(translationKey, keyCode, category, ConflictContext.getDefault());
    }

    public ConflictContext getConfictContext() {
        return this.conflictContext;
    }

    public boolean matchesKey(InputConstants.Key key) {
        return this.key.equals((Object)key);
    }

    public boolean isDownAnywhere() {
        Minecraft minecraftClient = Minecraft.getInstance();
        if (minecraftClient == null) {
            return false;
        }
        Window window = minecraftClient.getWindow();
        if (window == null) {
            return false;
        }
        return InputConstants.isKeyDown((long)window.getWindow(), (int)this.key.getValue());
    }

    public static enum ConflictContext {
        UNIVERSAL,
        IN_SCREEN,
        IN_GAME;


        public static ConflictContext getDefault() {
            return UNIVERSAL;
        }
    }
}

