/*
 * Decompiled with CFR 0.152.
 */
package dev.fixyl.componentviewer.control.keyboard;

import dev.fixyl.componentviewer.DisablableMod;
import dev.fixyl.componentviewer.config.keymapping.CycleSelectionKeyMapping;
import dev.fixyl.componentviewer.config.keymapping.EnumOptionKeyMapping;
import dev.fixyl.componentviewer.config.keymapping.KeyMappings;
import dev.fixyl.componentviewer.config.keymapping.TickedKeyMapping;
import dev.fixyl.componentviewer.config.option.BooleanOption;
import dev.fixyl.componentviewer.event.EventDispatcher;
import dev.fixyl.componentviewer.screen.ConfigScreen;
import java.util.List;
import net.minecraft.class_11908;
import net.minecraft.class_310;

public abstract class Keyboard {
    protected final class_310 minecraftClient;
    protected final DisablableMod disablableMod;
    protected final EventDispatcher eventDispatcher;
    protected final List<TickedKeyMapping> tickedKeys;
    protected final List<CycleSelectionKeyMapping> cycleSelectionKeys;
    protected final List<EnumOptionKeyMapping> enumOptionKeys;
    private BooleanOption alternativeCopyModifierKey;
    private BooleanOption allowCyclingOptionsWhileInScreen;

    protected Keyboard(class_310 minecarftClient, DisablableMod disablableMod, EventDispatcher eventDispatcher, KeyMappings keyMappings, BooleanOption alternativeCopyModifierKey, BooleanOption allowCyclingOptionsWhileInScreen) {
        this.minecraftClient = minecarftClient;
        this.disablableMod = disablableMod;
        this.eventDispatcher = eventDispatcher;
        this.tickedKeys = keyMappings.getSubClassKeyMappings(TickedKeyMapping.class);
        this.cycleSelectionKeys = keyMappings.getSubClassKeyMappings(CycleSelectionKeyMapping.class);
        this.enumOptionKeys = keyMappings.getSubClassKeyMappings(EnumOptionKeyMapping.class);
        this.alternativeCopyModifierKey = alternativeCopyModifierKey;
        this.allowCyclingOptionsWhileInScreen = allowCyclingOptionsWhileInScreen;
    }

    public void onEndClientTick() {
        for (TickedKeyMapping tickedKey : this.tickedKeys) {
            tickedKey.onEndClientTick();
        }
    }

    public void onKeyPress(class_11908 keyEvent) {
        if (this.disablableMod.isModDisabled()) {
            return;
        }
        for (CycleSelectionKeyMapping cycleKey : this.cycleSelectionKeys) {
            if (!cycleKey.matchesKeyEvent(keyEvent)) continue;
            this.eventDispatcher.invokeCycleComponentEvent(cycleKey.getCycleType());
        }
        if (this.isCopy(keyEvent)) {
            this.eventDispatcher.invokeCopyActionEvent();
        }
        if (this.isCyclingOptionsPossible()) {
            for (EnumOptionKeyMapping enumOptionKey : this.enumOptionKeys) {
                enumOptionKey.cycleEnumIfKeyEventMatches(keyEvent);
            }
        }
    }

    public void clearAllOptionCycleToasts() {
        for (EnumOptionKeyMapping enumOptionKey : this.enumOptionKeys) {
            enumOptionKey.clearToast();
        }
    }

    private boolean isCopy(class_11908 keyEvent) {
        return keyEvent.method_74228() == 67 && (this.alternativeCopyModifierKey.getBooleanValue() ? keyEvent.method_74238() : keyEvent.method_74240());
    }

    private boolean isCyclingOptionsPossible() {
        if (this.minecraftClient.field_1687 == null || this.minecraftClient.field_1724 == null) {
            return false;
        }
        if (this.minecraftClient.field_1755 == null) {
            return true;
        }
        return this.allowCyclingOptionsWhileInScreen.getBooleanValue() && !(this.minecraftClient.field_1755 instanceof ConfigScreen);
    }
}

