/*
 * Decompiled with CFR 0.152.
 */
package dev.fixyl.componentviewer.config.option;

import dev.fixyl.componentviewer.annotation.NullPermitted;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_7172;
import net.minecraft.class_7919;

public abstract class AdvancedOption<T> {
    private static final String ID_REGEX = "^[a-z]++(?:_[a-z]++)*+(?:\\.[a-z]++(?:_[a-z]++)*+)*+$";
    protected class_7172<T> option;
    protected final String id;
    protected final T defaultValue;
    protected final String translationKey;
    protected final class_7172.class_7277<T> tooltipSupplier;
    @NullPermitted
    protected final Function<T, String> translationKeyOverwrite;
    @NullPermitted
    protected final BooleanSupplier dependencyFulfillmentSupplier;
    protected final Consumer<T> changeCallback;

    protected AdvancedOption(AdvancedOptionBuilder<T, ?, ?> builder) {
        Objects.requireNonNull(builder.id, "Option id not specified");
        if (!builder.id.matches(ID_REGEX)) {
            throw new IllegalArgumentException(String.format("Invalid option id '%s'", builder.id));
        }
        this.id = builder.id;
        this.defaultValue = Objects.requireNonNull(builder.defaultValue, "Default value not specified");
        this.translationKey = Objects.toString(builder.translationKey);
        this.tooltipSupplier = builder.descriptionTranslationKey == null ? class_7172.method_42399() : class_7172.method_42717((class_2561)class_2561.method_43471((String)builder.descriptionTranslationKey));
        this.translationKeyOverwrite = builder.translationKeyOverwrite;
        this.dependencyFulfillmentSupplier = builder.dependencyFulfillmentSupplier;
        this.changeCallback = Objects.requireNonNullElse(builder.changeCallback, value -> {});
    }

    protected final void postConstruct() {
        this.option = this.createOptionInstance(this.translationKey, this.tooltipSupplier, AdvancedOption.createCaptionBasedToString(this.translationKeyOverwrite, this::getDefaultCaptionBasedToString), this.defaultValue, this.changeCallback);
    }

    public Type getType() {
        Type type = this.getClass().getGenericSuperclass();
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return parameterizedType.getActualTypeArguments()[0];
        }
        throw new IllegalStateException("AdvancedOption doesn't have a type although it's necessary?");
    }

    public String getId() {
        return this.id;
    }

    public String getTranslationKey() {
        return this.translationKey;
    }

    public T getValue() {
        return (T)this.option.method_41753();
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public void setValue(@NullPermitted T value) {
        if (value == null) {
            this.resetValue();
            return;
        }
        this.option.method_41748(value);
    }

    public void resetValue() {
        this.option.method_41748(this.defaultValue);
    }

    public class_7919 getTooltip() {
        return this.tooltipSupplier.apply(this.getValue());
    }

    public class_339 createWidget(int x, int y, int width, Consumer<T> changeCallback) {
        return this.option.method_47603(class_310.method_1551().field_1690, x, y, width, changeCallback);
    }

    public boolean isDependent() {
        return this.dependencyFulfillmentSupplier != null;
    }

    public boolean isDependencyFulfilled() {
        return !this.isDependent() || this.dependencyFulfillmentSupplier.getAsBoolean();
    }

    protected abstract class_7172<T> createOptionInstance(String var1, class_7172.class_7277<T> var2, class_7172.class_7303<T> var3, T var4, Consumer<T> var5);

    protected abstract class_7172.class_7303<T> getDefaultCaptionBasedToString();

    private static <T> class_7172.class_7303<T> createCaptionBasedToString(@NullPermitted Function<T, String> translationKeyOverwrite, Supplier<class_7172.class_7303<T>> defaultSupplier) {
        if (translationKeyOverwrite == null) {
            return defaultSupplier.get();
        }
        return (optionText, value) -> {
            String translationKey = (String)translationKeyOverwrite.apply(value);
            if (translationKey == null) {
                return class_2561.method_43470((String)Objects.toString(null));
            }
            return class_2561.method_43469((String)translationKey, (Object[])new Object[]{value});
        };
    }

    public static abstract class AdvancedOptionBuilder<T, O extends AdvancedOption<T>, B extends AdvancedOptionBuilder<T, O, B>> {
        protected String id;
        protected T defaultValue;
        @NullPermitted
        protected String translationKey;
        @NullPermitted
        protected String descriptionTranslationKey;
        @NullPermitted
        protected Function<T, String> translationKeyOverwrite;
        @NullPermitted
        protected BooleanSupplier dependencyFulfillmentSupplier;
        @NullPermitted
        protected Consumer<T> changeCallback;

        protected AdvancedOptionBuilder(String id) {
            this.id = id;
        }

        public B setDefaultValue(T defaultValue) {
            this.defaultValue = defaultValue;
            return this.self();
        }

        public B setTranslationKey(@NullPermitted String translationKey) {
            this.translationKey = translationKey;
            return this.self();
        }

        public B setDescriptionTranslationKey(@NullPermitted String descriptionTranslationKey) {
            this.descriptionTranslationKey = descriptionTranslationKey;
            return this.self();
        }

        public B setTranslationKeyOverwrite(@NullPermitted Function<T, String> translationKeyOverwrite) {
            this.translationKeyOverwrite = translationKeyOverwrite;
            return this.self();
        }

        public B setDependency(@NullPermitted BooleanSupplier dependencyFulfillmentSupplier) {
            this.dependencyFulfillmentSupplier = dependencyFulfillmentSupplier;
            return this.self();
        }

        public B setChangeCallback(@NullPermitted Consumer<T> changeCallback) {
            this.changeCallback = changeCallback;
            return this.self();
        }

        public abstract O build();

        protected abstract B self();
    }
}

