/*
 * Decompiled with CFR 0.152.
 */
package dev.fixyl.componentviewer.control;

import net.minecraft.client.ScrollWheelHandler;

public class Selection {
    private int amount;
    private int selectedIndex;

    public Selection(int amount) {
        this.amount = Selection.assertPositiveAmount(amount);
        this.selectedIndex = 0;
    }

    public void setAmount(int amount) {
        this.amount = Selection.assertPositiveAmount(amount);
        this.selectedIndex = Math.clamp((long)this.selectedIndex, 0, amount - 1);
    }

    public int getAmount() {
        return this.amount;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void updateByScrolling(double scrollDistance) {
        this.selectedIndex = ScrollWheelHandler.getNextScrollWheelSelection((double)scrollDistance, (int)this.selectedIndex, (int)this.amount);
    }

    public void updateByCycling(CycleType cycleType) {
        int newIndex;
        switch (cycleType.ordinal()) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                int n = this.selectedIndex + 1;
                break;
            }
            case 1: {
                int n = this.selectedIndex - 1;
                break;
            }
            case 2: {
                int n = 0;
                break;
            }
            case 3: {
                int n = newIndex = this.amount - 1;
            }
        }
        this.selectedIndex = newIndex >= this.amount ? 0 : (newIndex < 0 ? this.amount - 1 : newIndex);
    }

    public void updateByValue(int newIndex) {
        this.selectedIndex = Math.clamp((long)newIndex, 0, this.amount - 1);
    }

    private static int assertPositiveAmount(int amount) {
        if (amount <= 0) {
            throw new IllegalArgumentException("Selection amount must be > 0");
        }
        return amount;
    }

    public static enum CycleType {
        NEXT,
        PREVIOUS,
        FIRST,
        LAST;

    }
}

