/*
 * Decompiled with CFR 0.152.
 */
package dev.fixyl.componentviewer.control.component;

import dev.fixyl.componentviewer.annotation.NullPermitted;
import dev.fixyl.componentviewer.config.enums.TooltipComponents;
import dev.fixyl.componentviewer.control.component.ItemStackComponents;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.ItemStack;

final class MappedItemStackComponents
extends ItemStackComponents {
    private final Supplier<DataComponentMap> dataComponentMap;

    MappedItemStackComponents(ItemStack itemStack, Supplier<DataComponentMap> dataComponentMap, TooltipComponents componentContext) {
        super(itemStack, componentContext);
        this.dataComponentMap = dataComponentMap;
    }

    @Override
    public int size() {
        return this.dataComponentMap.get().size();
    }

    @Override
    public boolean isEmpty() {
        return this.dataComponentMap.get().isEmpty();
    }

    @Override
    public List<DataComponentType<?>> getComponentTypes() {
        return this.dataComponentMap.get().keySet().stream().sorted(REGISTRY_ID_COMPARATOR).toList();
    }

    @Override
    @NullPermitted
    public <T> T getValue(DataComponentType<T> dataComponentType) {
        return (T)this.dataComponentMap.get().get(dataComponentType);
    }

    @Override
    public <T> boolean wasRemoved(DataComponentType<T> dataComponentType) {
        return false;
    }
}

