/*
 * Decompiled with CFR 0.152.
 */
package dev.fixyl.componentviewer.config.option;

import com.mojang.serialization.Codec;
import dev.fixyl.componentviewer.config.option.AdvancedOption;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import net.minecraft.class_7172;
import net.minecraft.class_7291;
import net.minecraft.class_7995;

public class EnumOption<E extends Enum<E>>
extends AdvancedOption<E> {
    private final Class<E> enumClass;
    private final IntFunction<E> enumByIdFunction;

    private EnumOption(EnumOptionBuilder<E> builder) {
        super(builder);
        this.enumClass = ((Enum)this.defaultValue).getDeclaringClass();
        this.enumByIdFunction = class_7995.method_47914(rec$ -> ((class_7291)rec$).method_7362(), (Object[])this.getEnumConstants(), (class_7995.class_7996)class_7995.class_7996.field_41665);
        this.postConstruct();
    }

    @Override
    public Type getType() {
        return this.enumClass;
    }

    public E[] getEnumConstants() {
        return (Enum[])this.enumClass.getEnumConstants();
    }

    public void cycleValue() {
        int nextId = ((class_7291)((Enum)this.option.method_41753())).method_7362() + 1;
        E nextValue = this.getEnumById(nextId);
        this.option.method_41748(nextValue);
    }

    @Override
    protected class_7172<E> createOptionInstance(String translationkey, class_7172.class_7277<E> tooltipSupplier, class_7172.class_7303<E> captionBasedToString, E defaultValue, Consumer<E> changeCallback) {
        return new class_7172(translationkey, tooltipSupplier, captionBasedToString, (class_7172.class_7178)new class_7172.class_7173(Arrays.asList(this.getEnumConstants()), Codec.INT.xmap(this::getEnumById, rec$ -> ((class_7291)rec$).method_7362())), defaultValue, changeCallback);
    }

    @Override
    protected class_7172.class_7303<E> getDefaultCaptionBasedToString() {
        return class_7172.method_42720();
    }

    private E getEnumById(int id) {
        return (E)((Enum)this.enumByIdFunction.apply(id));
    }

    public static <E extends Enum<E>> EnumOptionBuilder<E> create(String id) {
        return new EnumOptionBuilder(id);
    }

    public static class EnumOptionBuilder<E extends Enum<E>>
    extends AdvancedOption.AdvancedOptionBuilder<E, EnumOption<E>, EnumOptionBuilder<E>> {
        public EnumOptionBuilder(String id) {
            super(id);
        }

        @Override
        public EnumOption<E> build() {
            return new EnumOption(this);
        }

        @Override
        protected EnumOptionBuilder<E> self() {
            return this;
        }
    }
}

