/*
 * Decompiled with CFR 0.152.
 */
package dev.fixyl.componentviewer.config.option;

import dev.fixyl.componentviewer.config.option.AdvancedOption;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_7172;

public class IntegerOption
extends AdvancedOption<Integer> {
    private final Integer minValue;
    private final Integer maxValue;

    private IntegerOption(IntegerOptionBuilder builder) {
        super(builder);
        Objects.requireNonNull(builder.minValue, "Min value not specified");
        Objects.requireNonNull(builder.maxValue, "Max value not specified");
        if (builder.minValue > builder.maxValue) {
            throw new IllegalArgumentException("Min value is greater than max value");
        }
        if ((Integer)this.defaultValue < builder.minValue || (Integer)this.defaultValue > builder.maxValue) {
            throw new IllegalArgumentException(String.format("Default value not within specified range: %s to %s", builder.minValue, builder.maxValue));
        }
        this.minValue = builder.minValue;
        this.maxValue = builder.maxValue;
        this.postConstruct();
    }

    public int getIntValue() {
        Integer value = (Integer)this.getValue();
        return value != null ? value : 0;
    }

    public int getIntDefaultValue() {
        return this.defaultValue != null ? (Integer)this.defaultValue : 0;
    }

    @Override
    protected class_7172<Integer> createOptionInstance(String translationkey, class_7172.class_7277<Integer> tooltipSupplier, class_7172.class_7303<Integer> captionBasedToString, Integer defaultValue, Consumer<Integer> changeCallback) {
        class_7172.class_7174 intRange = new class_7172.class_7174(this.minValue.intValue(), this.maxValue.intValue());
        return new class_7172(translationkey, tooltipSupplier, captionBasedToString, (class_7172.class_7178)intRange, intRange.comp_675(), (Object)defaultValue, changeCallback);
    }

    @Override
    protected class_7172.class_7303<Integer> getDefaultCaptionBasedToString() {
        return (optionText, value) -> class_2561.method_43473();
    }

    public static IntegerOptionBuilder create(String id) {
        return new IntegerOptionBuilder(id);
    }

    public static class IntegerOptionBuilder
    extends AdvancedOption.AdvancedOptionBuilder<Integer, IntegerOption, IntegerOptionBuilder> {
        private Integer minValue;
        private Integer maxValue;

        public IntegerOptionBuilder(String id) {
            super(id);
        }

        public IntegerOptionBuilder setIntegerRange(Integer minValue, Integer maxValue) {
            this.minValue = minValue;
            this.maxValue = maxValue;
            return this;
        }

        @Override
        public IntegerOption build() {
            return new IntegerOption(this);
        }

        @Override
        protected IntegerOptionBuilder self() {
            return this;
        }
    }
}

