/*
 * Decompiled with CFR 0.152.
 */
package dev.fixyl.componentviewer.control;

import dev.fixyl.componentviewer.DisablableMod;
import dev.fixyl.componentviewer.annotation.NullPermitted;
import dev.fixyl.componentviewer.config.Configs;
import dev.fixyl.componentviewer.config.enums.ClipboardCopy;
import dev.fixyl.componentviewer.config.enums.ClipboardFormatting;
import dev.fixyl.componentviewer.config.enums.ClipboardSelector;
import dev.fixyl.componentviewer.config.enums.TooltipDisplay;
import dev.fixyl.componentviewer.config.enums.TooltipFormatting;
import dev.fixyl.componentviewer.config.enums.TooltipInjectMethod;
import dev.fixyl.componentviewer.config.enums.TooltipKeepSelection;
import dev.fixyl.componentviewer.config.enums.TooltipPurpose;
import dev.fixyl.componentviewer.control.HoveredItemStack;
import dev.fixyl.componentviewer.control.Selection;
import dev.fixyl.componentviewer.control.Tooltip;
import dev.fixyl.componentviewer.control.keyboard.Clipboard;
import dev.fixyl.componentviewer.formatting.Formatter;
import dev.fixyl.componentviewer.formatting.JsonFormatter;
import dev.fixyl.componentviewer.formatting.ObjectFormatter;
import dev.fixyl.componentviewer.formatting.SnbtFormatter;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1269;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_9279;
import net.minecraft.class_9336;

public final class ControlFlow {
    private final class_310 minecraftClient;
    private final DisablableMod disablableMod;
    private final Configs configs;
    private final Clipboard clipboard;
    private final Formatter snbtFormatter;
    private final Formatter jsonFormatter;
    private final Formatter objectFormatter;
    private long renderTick;
    private HoveredItemStack hoveredItemStack;
    private class_1799 previousItemStack;
    private long lastTimeItemStackHovered;
    private boolean isTooltipShown;
    private long lastTimeTooltipShown;

    public ControlFlow(class_310 minecraftClient, DisablableMod disablableMod, Configs configs) {
        this.minecraftClient = minecraftClient;
        this.disablableMod = disablableMod;
        this.configs = configs;
        this.clipboard = new Clipboard();
        this.snbtFormatter = new SnbtFormatter();
        this.jsonFormatter = new JsonFormatter();
        this.objectFormatter = new ObjectFormatter();
        this.renderTick = 0L;
        this.lastTimeItemStackHovered = -1L;
        this.isTooltipShown = false;
        this.lastTimeTooltipShown = -1L;
    }

    public void onStartRender() {
        ++this.renderTick;
    }

    public void onTooltip(class_1799 itemStack, Tooltip tooltip) {
        if (itemStack == null || this.disablableMod.isModDisabled()) {
            return;
        }
        if (this.hoveredItemStack == null || itemStack != this.previousItemStack) {
            HoveredItemStack newHoveredItemStack = new HoveredItemStack(itemStack, this.configs);
            if (this.configs.tooltipKeepSelection.getValue() != TooltipKeepSelection.NEVER && this.configs.tooltipPurpose.getValue() == TooltipPurpose.COMPONENTS && this.hoveredItemStack != null) {
                this.keepSelection(newHoveredItemStack);
            }
            this.hoveredItemStack = newHoveredItemStack;
            this.previousItemStack = itemStack;
        }
        this.lastTimeItemStackHovered = this.renderTick;
        this.isTooltipShown = this.shouldDisplayToolip();
        if (!this.isTooltipShown) {
            return;
        }
        this.lastTimeTooltipShown = this.renderTick;
        if (this.configs.tooltipInjectMethod.getValue() == TooltipInjectMethod.REPLACE) {
            tooltip.clear();
        } else if (!tooltip.isEmpty()) {
            tooltip.addSpacer();
        }
        if (this.configs.tooltipPurpose.getValue() == TooltipPurpose.COMPONENTS) {
            this.handleComponentPurpose(tooltip);
        } else {
            this.handleItemStackPurpose(tooltip);
        }
    }

    public void onCycleComponent(Selection.CycleType cycleType) {
        if (this.isComponentSelectionShown()) {
            this.hoveredItemStack.getComponentSelection().ifPresent(selection -> selection.updateByCycling(cycleType));
        }
    }

    public class_1269 onMouseScroll(double scrollDistance) {
        Optional<Selection> optionalSelection;
        if (this.isComponentSelectionShown() && this.configs.controlsAllowScrolling.getBooleanValue() && (optionalSelection = this.hoveredItemStack.getComponentSelection()).isPresent()) {
            optionalSelection.orElseThrow().updateByScrolling(scrollDistance);
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public void onCopyAction() {
        if (!this.isItemStackHovered()) {
            return;
        }
        ClipboardCopy clipboardCopy = (ClipboardCopy)((Object)this.configs.clipboardCopy.getValue());
        Objects.requireNonNull(clipboardCopy);
        ClipboardCopy clipboardCopy2 = clipboardCopy;
        int n = 0;
        block5: while (true) {
            switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"ITEM_STACK", "GIVE_COMMAND", ClipboardCopy.class}, (ClipboardCopy)clipboardCopy2, n)) {
                case 0: {
                    this.copyItemStack(this.hoveredItemStack.getItemStack());
                    break block5;
                }
                case 1: {
                    this.copyGiveCommand(this.hoveredItemStack.getItemStack());
                    break block5;
                }
                case 2: {
                    ClipboardCopy copyType = clipboardCopy2;
                    if (copyType != ClipboardCopy.COMPONENT_VALUE || !this.isComponentSelectionShown()) {
                        n = 3;
                        continue block5;
                    }
                    this.hoveredItemStack.getSelectedComponent().ifPresent(this::copyComponentValue);
                    break block5;
                }
            }
            break;
        }
    }

    public boolean isItemStackHovered() {
        return this.lastTimeItemStackHovered == this.renderTick;
    }

    public boolean isTooltipShown() {
        return this.isTooltipShown && this.lastTimeTooltipShown == this.renderTick;
    }

    private boolean isComponentSelectionShown() {
        return this.isTooltipShown() && this.configs.tooltipPurpose.getValue() == TooltipPurpose.COMPONENTS && this.configs.tooltipComponentValues.getBooleanValue();
    }

    private boolean shouldDisplayToolip() {
        TooltipDisplay tooltipDisplay = (TooltipDisplay)((Object)this.configs.tooltipDisplay.getValue());
        if (tooltipDisplay == TooltipDisplay.NEVER || tooltipDisplay == TooltipDisplay.HOLD && !this.configs.keyShowTooltip.isDownAnywhere()) {
            return false;
        }
        return this.minecraftClient.field_1690.field_1827 || !this.configs.tooltipAdvancedTooltips.getBooleanValue();
    }

    private void keepSelection(HoveredItemStack newHoveredItemStack) {
        switch ((TooltipKeepSelection)((Object)this.configs.tooltipKeepSelection.getValue())) {
            case INDEX: {
                this.keepSelectionByIndex(newHoveredItemStack);
                break;
            }
            case TYPE: {
                this.keepSelectionByType(newHoveredItemStack);
                break;
            }
        }
    }

    private void keepSelectionByIndex(HoveredItemStack newHoveredItemStack) {
        this.hoveredItemStack.getComponentSelection().ifPresent(currentSelection -> newHoveredItemStack.getComponentSelection().ifPresent(newSelection -> newSelection.updateByValue(currentSelection.getSelectedIndex())));
    }

    private void keepSelectionByType(HoveredItemStack newHoveredItemStack) {
        this.hoveredItemStack.getSelectedComponent().ifPresent(component -> {
            int indexOfComponent = newHoveredItemStack.getComponents().indexOf(component.comp_2443());
            if (indexOfComponent < 0) {
                this.keepSelectionByIndex(newHoveredItemStack);
                return;
            }
            newHoveredItemStack.getComponentSelection().ifPresent(newSelection -> newSelection.updateByValue(indexOfComponent));
        });
    }

    private void handleComponentPurpose(Tooltip tooltip) {
        boolean showComponentValues = this.configs.tooltipComponentValues.getBooleanValue();
        tooltip.addComponentSelection(this.hoveredItemStack, !showComponentValues, this.configs.tooltipShowAmount.getBooleanValue());
        if (this.hoveredItemStack.getComponents().isEmpty() || !showComponentValues) {
            return;
        }
        class_9336<?> selectedComponent = this.hoveredItemStack.getSelectedComponent().orElseThrow();
        tooltip.addSpacer().addComponentValue(selectedComponent, this.getTooltipFormatter(selectedComponent), this.getTooltipIndentation(), this.configs.tooltipColoredFormatting.getBooleanValue());
    }

    private void handleItemStackPurpose(Tooltip tooltip) {
        tooltip.addItemStack(this.hoveredItemStack.getItemStack(), this.getTooltipFormatter(), this.configs.tooltipIndentation.getIntValue(), this.configs.tooltipColoredFormatting.getBooleanValue());
    }

    private <T> void copyComponentValue(class_9336<T> component) {
        this.clipboard.copyComponentValue(component, this.getClipboardFormatter(component), this.getClipboardIndentation(), this.configs.clipboardSuccessNotification.getBooleanValue());
    }

    private void copyItemStack(class_1799 itemStack) {
        this.clipboard.copyItemStack(itemStack, this.getClipboardFormatter(), this.getClipboardIndentation(), this.configs.clipboardSuccessNotification.getBooleanValue());
    }

    private void copyGiveCommand(class_1799 itemStack) {
        this.clipboard.copyGiveCommand(itemStack, this.getGiveCommandSelector(), this.configs.clipboardPrependSlash.getBooleanValue(), this.configs.clipboardIncludeCount.getBooleanValue(), this.configs.clipboardSuccessNotification.getBooleanValue());
    }

    private Formatter getTooltipFormatter() {
        return this.getTooltipFormatter(null);
    }

    private <T> Formatter getTooltipFormatter(@NullPermitted class_9336<T> component) {
        return switch ((TooltipFormatting)((Object)this.configs.tooltipFormatting.getValue())) {
            default -> throw new MatchException(null, null);
            case TooltipFormatting.SNBT -> this.snbtFormatter;
            case TooltipFormatting.JSON -> this.jsonFormatter;
            case TooltipFormatting.OBJECT -> component != null && component.comp_2444() instanceof class_9279 ? this.snbtFormatter : this.objectFormatter;
        };
    }

    private Formatter getClipboardFormatter() {
        return this.getClipboardFormatter(null);
    }

    private <T> Formatter getClipboardFormatter(@NullPermitted class_9336<T> component) {
        return switch ((ClipboardFormatting)((Object)this.configs.clipboardFormatting.getValue())) {
            default -> throw new MatchException(null, null);
            case ClipboardFormatting.SYNC -> this.getTooltipFormatter(component);
            case ClipboardFormatting.SNBT -> this.snbtFormatter;
            case ClipboardFormatting.JSON -> this.jsonFormatter;
            case ClipboardFormatting.OBJECT -> component != null && component.comp_2444() instanceof class_9279 ? this.snbtFormatter : this.objectFormatter;
        };
    }

    private int getTooltipIndentation() {
        return this.configs.tooltipIndentation.getIntValue();
    }

    private int getClipboardIndentation() {
        int clipboardIndentation = this.configs.clipboardIndentation.getIntValue();
        return clipboardIndentation == -1 ? this.getTooltipIndentation() : clipboardIndentation;
    }

    private String getGiveCommandSelector() {
        return switch ((ClipboardSelector)((Object)this.configs.clipboardSelector.getValue())) {
            default -> throw new MatchException(null, null);
            case ClipboardSelector.EVERYONE -> "@a";
            case ClipboardSelector.NEAREST -> "@p";
            case ClipboardSelector.SELF -> "@s";
            case ClipboardSelector.PLAYER -> this.minecraftClient.method_53462().getName();
        };
    }
}

