/*
 * Decompiled with CFR 0.152.
 */
package dev.fixyl.componentviewer.control.component;

import dev.fixyl.componentviewer.annotation.NullPermitted;
import dev.fixyl.componentviewer.config.enums.TooltipComponents;
import dev.fixyl.componentviewer.control.component.ItemStackComponents;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_1799;
import net.minecraft.class_9326;
import net.minecraft.class_9331;

final class PatchedItemStackComponents
extends ItemStackComponents {
    private final Supplier<class_9326> dataComponentPatch;

    PatchedItemStackComponents(class_1799 itemStack, Supplier<class_9326> dataComponentPatch, TooltipComponents componentContext) {
        super(itemStack, componentContext);
        this.dataComponentPatch = dataComponentPatch;
    }

    @Override
    public int size() {
        return this.dataComponentPatch.get().method_57847();
    }

    @Override
    public boolean isEmpty() {
        return this.dataComponentPatch.get().method_57848();
    }

    @Override
    public List<class_9331<?>> getComponentTypes() {
        class_9326 currentPatch = this.dataComponentPatch.get();
        return currentPatch.method_57846().stream().map(Map.Entry::getKey).sorted(REGISTRY_ID_COMPARATOR).sorted(Comparator.comparing(dataComponentType -> PatchedItemStackComponents.wasRemovedWithPatch(dataComponentType, currentPatch))).toList();
    }

    @Override
    @NullPermitted
    public <T> T getValue(class_9331<T> dataComponentType) {
        Optional optionalValue = this.dataComponentPatch.get().method_57845(dataComponentType);
        if (optionalValue == null) {
            return null;
        }
        if (optionalValue.isEmpty()) {
            return (T)this.itemStack.method_58658().method_58694(dataComponentType);
        }
        return optionalValue.orElseThrow();
    }

    @Override
    public <T> boolean wasRemoved(class_9331<T> dataComponentType) {
        return PatchedItemStackComponents.wasRemovedWithPatch(dataComponentType, this.dataComponentPatch.get());
    }

    private static <T> boolean wasRemovedWithPatch(class_9331<T> dataComponentType, class_9326 dataComponentPatch) {
        Optional optionalValue = dataComponentPatch.method_57845(dataComponentType);
        if (optionalValue == null) {
            return false;
        }
        return optionalValue.isEmpty();
    }
}

