/*
 * Decompiled with CFR 0.152.
 */
package dev.fixyl.componentviewer.control.component;

import dev.fixyl.componentviewer.annotation.NullPermitted;
import dev.fixyl.componentviewer.config.enums.TooltipComponents;
import dev.fixyl.componentviewer.control.component.ItemStackComponents;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.ItemStack;

final class PatchedItemStackComponents
extends ItemStackComponents {
    private final Supplier<DataComponentPatch> dataComponentPatch;

    PatchedItemStackComponents(ItemStack itemStack, Supplier<DataComponentPatch> dataComponentPatch, TooltipComponents componentContext) {
        super(itemStack, componentContext);
        this.dataComponentPatch = dataComponentPatch;
    }

    @Override
    public int size() {
        return this.dataComponentPatch.get().size();
    }

    @Override
    public boolean isEmpty() {
        return this.dataComponentPatch.get().isEmpty();
    }

    @Override
    public List<DataComponentType<?>> getComponentTypes() {
        DataComponentPatch currentPatch = this.dataComponentPatch.get();
        return currentPatch.entrySet().stream().map(Map.Entry::getKey).sorted(REGISTRY_ID_COMPARATOR).sorted(Comparator.comparing(dataComponentType -> PatchedItemStackComponents.wasRemovedWithPatch(dataComponentType, currentPatch))).toList();
    }

    @Override
    @NullPermitted
    public <T> T getValue(DataComponentType<T> dataComponentType) {
        Optional optionalValue = this.dataComponentPatch.get().get(dataComponentType);
        if (optionalValue == null) {
            return null;
        }
        if (optionalValue.isEmpty()) {
            return (T)this.itemStack.getPrototype().get(dataComponentType);
        }
        return optionalValue.orElseThrow();
    }

    @Override
    public <T> boolean wasRemoved(DataComponentType<T> dataComponentType) {
        return PatchedItemStackComponents.wasRemovedWithPatch(dataComponentType, this.dataComponentPatch.get());
    }

    private static <T> boolean wasRemovedWithPatch(DataComponentType<T> dataComponentType, DataComponentPatch dataComponentPatch) {
        Optional optionalValue = dataComponentPatch.get(dataComponentType);
        if (optionalValue == null) {
            return false;
        }
        return optionalValue.isEmpty();
    }
}

