/*
 * Decompiled with CFR 0.152.
 */
package dev.fixyl.componentviewer.control.keyboard;

import com.mojang.blaze3d.platform.InputConstants;
import dev.fixyl.componentviewer.DisablableMod;
import dev.fixyl.componentviewer.config.keymapping.AdvancedKeyMapping;
import dev.fixyl.componentviewer.config.keymapping.CycleSelectionKeyMapping;
import dev.fixyl.componentviewer.config.keymapping.EnumOptionKeyMapping;
import dev.fixyl.componentviewer.config.keymapping.KeyMappings;
import dev.fixyl.componentviewer.config.keymapping.TickedKeyMapping;
import dev.fixyl.componentviewer.config.option.BooleanOption;
import dev.fixyl.componentviewer.event.EventDispatcher;
import dev.fixyl.componentviewer.screen.ConfigScreen;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonInfo;

public abstract class Keyboard {
    protected final Minecraft minecraftClient;
    protected final DisablableMod disablableMod;
    protected final EventDispatcher eventDispatcher;
    protected final AdvancedKeyMapping[] keyMappings;
    protected final List<TickedKeyMapping> tickedKeys;
    protected final List<CycleSelectionKeyMapping> cycleSelectionKeys;
    protected final List<EnumOptionKeyMapping> enumOptionKeys;
    private BooleanOption alternativeCopyModifierKey;
    private BooleanOption allowCyclingOptionsWhileInScreen;

    protected Keyboard(Minecraft minecarftClient, DisablableMod disablableMod, EventDispatcher eventDispatcher, KeyMappings keyMappings, BooleanOption alternativeCopyModifierKey, BooleanOption allowCyclingOptionsWhileInScreen) {
        this.minecraftClient = minecarftClient;
        this.disablableMod = disablableMod;
        this.eventDispatcher = eventDispatcher;
        this.keyMappings = keyMappings.getKeyMappings();
        this.tickedKeys = keyMappings.getSubClassKeyMappings(TickedKeyMapping.class);
        this.cycleSelectionKeys = keyMappings.getSubClassKeyMappings(CycleSelectionKeyMapping.class);
        this.enumOptionKeys = keyMappings.getSubClassKeyMappings(EnumOptionKeyMapping.class);
        this.alternativeCopyModifierKey = alternativeCopyModifierKey;
        this.allowCyclingOptionsWhileInScreen = allowCyclingOptionsWhileInScreen;
    }

    public void onEndClientTick() {
        for (TickedKeyMapping tickedKey : this.tickedKeys) {
            tickedKey.onEndClientTick();
        }
    }

    public void onKeyInput(KeyEvent keyEvent, Action action) {
        InputConstants.Key key = InputConstants.getKey((KeyEvent)keyEvent);
        this.setDownStateForAll(key, action);
        if (this.shouldCaptureInput(action)) {
            this.onInput(key);
            if (key.getType() == InputConstants.Type.KEYSYM && this.isCopy(keyEvent)) {
                this.eventDispatcher.invokeCopyActionEvent();
            }
        }
    }

    public void onButtonInput(MouseButtonInfo mouseButtonInfo, Action action) {
        InputConstants.Key key = InputConstants.Type.MOUSE.getOrCreate(mouseButtonInfo.button());
        this.setDownStateForAll(key, action);
        if (this.shouldCaptureInput(action)) {
            this.onInput(key);
        }
    }

    public void clearAllOptionCycleToasts() {
        for (EnumOptionKeyMapping enumOptionKey : this.enumOptionKeys) {
            enumOptionKey.clearToast();
        }
    }

    private void onInput(InputConstants.Key key) {
        for (CycleSelectionKeyMapping cycleKey : this.cycleSelectionKeys) {
            if (!cycleKey.matchesKey(key)) continue;
            this.eventDispatcher.invokeCycleComponentEvent(cycleKey.getCycleType());
        }
        if (this.isCyclingOptionsPossible()) {
            for (EnumOptionKeyMapping enumOptionKey : this.enumOptionKeys) {
                enumOptionKey.cycleEnumIfKeyMatches(key);
            }
        }
    }

    private boolean shouldCaptureInput(Action action) {
        return !this.disablableMod.isModDisabled() && action != Action.RELEASE;
    }

    private void setDownStateForAll(InputConstants.Key key, Action action) {
        boolean isDown = action != Action.RELEASE;
        for (AdvancedKeyMapping keyMapping : this.keyMappings) {
            if (!keyMapping.matchesKey(key)) continue;
            keyMapping.setDownAnywhere(isDown);
        }
    }

    private boolean isCopy(KeyEvent keyEvent) {
        return keyEvent.key() == 67 && (this.alternativeCopyModifierKey.getBooleanValue() ? keyEvent.hasAltDown() : keyEvent.hasControlDown());
    }

    private boolean isCyclingOptionsPossible() {
        if (this.minecraftClient.level == null || this.minecraftClient.player == null) {
            return false;
        }
        if (this.minecraftClient.screen == null) {
            return true;
        }
        return this.allowCyclingOptionsWhileInScreen.getBooleanValue() && !(this.minecraftClient.screen instanceof ConfigScreen);
    }

    public static enum Action {
        RELEASE,
        PRESS,
        REPEAT;


        public static Action fromGlfw(int action) {
            return switch (action) {
                case 0 -> RELEASE;
                case 1 -> PRESS;
                case 2 -> REPEAT;
                default -> throw new IllegalArgumentException(String.format("There is no GLFW action with %s", action));
            };
        }
    }
}

