/*
 * Decompiled with CFR 0.152.
 */
package dev.fixyl.componentviewer.control.keyboard;

import dev.fixyl.componentviewer.ComponentViewer;
import dev.fixyl.componentviewer.DisablableMod;
import dev.fixyl.componentviewer.config.Configs;
import dev.fixyl.componentviewer.config.keymapping.AdvancedKeyMapping;
import dev.fixyl.componentviewer.control.keyboard.Keyboard;
import dev.fixyl.componentviewer.event.EventDispatcher;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;

@EventBusSubscriber(modid="componentviewer", value={Dist.CLIENT})
public class NeoForgeKeyboard
extends Keyboard {
    public NeoForgeKeyboard(Minecraft minecraftClient, DisablableMod disablableMod, EventDispatcher eventDispatcher, Configs configs) {
        super(minecraftClient, disablableMod, eventDispatcher, configs, configs.controlsAlternativeCopyModifierKey, configs.controlsAllowCyclingOptionsWhileInScreen);
    }

    @SubscribeEvent
    private static void registerKeyMappings(RegisterKeyMappingsEvent event) {
        Configs configs = ComponentViewer.getInstance().configs;
        for (KeyMapping.Category category : configs.getKeyMappingCategories()) {
            event.registerCategory(category);
        }
        for (AdvancedKeyMapping keyMapping : configs.getKeyMappings()) {
            keyMapping.setKeyConflictContext((IKeyConflictContext)(switch (keyMapping.getConfictContext()) {
                default -> throw new MatchException(null, null);
                case AdvancedKeyMapping.ConflictContext.UNIVERSAL -> KeyConflictContext.UNIVERSAL;
                case AdvancedKeyMapping.ConflictContext.IN_SCREEN -> KeyConflictContext.GUI;
                case AdvancedKeyMapping.ConflictContext.IN_GAME -> KeyConflictContext.IN_GAME;
            }));
            event.register((KeyMapping)keyMapping);
        }
    }
}

