/*
 * Decompiled with CFR 0.152.
 */
package dev.fixyl.componentviewer;

import dev.fixyl.componentviewer.DisablableMod;
import dev.fixyl.componentviewer.config.Configs;
import dev.fixyl.componentviewer.config.enums.DisableMod;
import dev.fixyl.componentviewer.event.EventDispatcher;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.server.IntegratedServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ComponentViewer
implements DisablableMod {
    public static final String MOD_ID = "componentviewer";
    private static ComponentViewer instance;
    public final Logger logger;
    public final EventDispatcher eventDispatcher;
    public final Configs configs;

    protected ComponentViewer(EventDispatcher eventDispatcher, Path configDir) {
        ComponentViewer.setInstance(this);
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.eventDispatcher = eventDispatcher;
        this.configs = new Configs(configDir, this.logger);
    }

    @Override
    public boolean isModDisabled() {
        return switch ((DisableMod)((Object)this.configs.disableMod.getValue())) {
            default -> throw new MatchException(null, null);
            case DisableMod.NEVER -> false;
            case DisableMod.IN_SURVIVAL -> this.currentlyInSurvival();
            case DisableMod.ON_SERVER -> this.currentlyOnServer();
            case DisableMod.BOTH -> this.currentlyInSurvival() && this.currentlyOnServer();
        };
    }

    public static void dispatchEventSafely(Consumer<EventDispatcher> consumer) {
        if (instance != null) {
            consumer.accept(ComponentViewer.instance.eventDispatcher);
        }
    }

    public static <R> Optional<R> dispatchEventWithResultSafely(Function<EventDispatcher, R> function) {
        if (instance != null) {
            return Optional.ofNullable(function.apply(ComponentViewer.instance.eventDispatcher));
        }
        return Optional.empty();
    }

    public static ComponentViewer getInstance() {
        if (instance == null) {
            throw new IllegalStateException(String.format("'%s' hasn't been instantiated yet!", ComponentViewer.class.getName()));
        }
        return instance;
    }

    private static void setInstance(ComponentViewer instance) {
        if (ComponentViewer.instance != null) {
            throw new IllegalStateException(String.format("Cannot instantiate '%s' twice!", ComponentViewer.class.getName()));
        }
        ComponentViewer.instance = instance;
    }

    protected static Minecraft getMinecraftClient() {
        Minecraft minecraftClient = Minecraft.getInstance();
        if (minecraftClient == null) {
            throw new IllegalStateException("Minecraft hasn't been initialized yet, although it should!");
        }
        return minecraftClient;
    }

    private boolean currentlyInSurvival() {
        LocalPlayer player = ComponentViewer.getMinecraftClient().player;
        if (player == null) {
            return false;
        }
        PlayerInfo playerInfo = player.getPlayerInfo();
        return playerInfo != null && playerInfo.getGameMode().isSurvival();
    }

    private boolean currentlyOnServer() {
        Minecraft minecraftClient = ComponentViewer.getMinecraftClient();
        IntegratedServer integratedServer = minecraftClient.getSingleplayerServer();
        return minecraftClient.getCurrentServer() != null || integratedServer != null && integratedServer.isPublished();
    }
}

