/*
 * Decompiled with CFR 0.152.
 */
package dev.fixyl.componentviewer.control;

import dev.fixyl.componentviewer.annotation.NullPermitted;
import dev.fixyl.componentviewer.config.enums.TooltipComponents;
import dev.fixyl.componentviewer.control.HoveredItemStack;
import dev.fixyl.componentviewer.control.component.ItemStackComponents;
import dev.fixyl.componentviewer.formatting.Formatter;
import dev.fixyl.componentviewer.formatting.FormattingException;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class Tooltip {
    private static final Style HEADER_STYLE = Style.EMPTY.withColor(ChatFormatting.GRAY);
    private static final Style COMPONENT_STYLE = Style.EMPTY.withColor(ChatFormatting.DARK_GRAY);
    private static final Style SELECTED_COMPONENT_STYLE = Style.EMPTY.withColor(ChatFormatting.DARK_GREEN);
    private static final Style REMOVED_COMPONENT_STYLE = Style.EMPTY.withStrikethrough(Boolean.valueOf(true));
    private static final Style NOT_REGISTERED_COMPONENT_STYLE = Style.EMPTY.withItalic(Boolean.valueOf(true));
    private static final Style ERROR_STYLE = Style.EMPTY.withColor(ChatFormatting.RED);
    private static final String CONTENT_INDENTATION = " ";
    private static final String NOT_REGISTERED_TRANSLATION_KEY = "componentviewer.tooltip.not_registered";
    private static final Map<TooltipComponents, String> COMPONENT_SELECTION_TRANSLATION_KEYS = Map.of(TooltipComponents.ALL, "componentviewer.tooltip.purpose.components.selection.all", TooltipComponents.DEFAULT, "componentviewer.tooltip.purpose.components.selection.default", TooltipComponents.CHANGES, "componentviewer.tooltip.purpose.components.selection.changes");
    private static final Map<TooltipComponents, String> EMPTY_COMPONENT_SELECTION_TRANSLATION_KEYS = Map.of(TooltipComponents.ALL, "componentviewer.tooltip.purpose.components.selection.all.empty", TooltipComponents.DEFAULT, "componentviewer.tooltip.purpose.components.selection.default.empty", TooltipComponents.CHANGES, "componentviewer.tooltip.purpose.components.selection.changes.empty");
    private static final Map<TooltipComponents, String> COMPONENT_SELECTION_WITH_AMOUNT_TRANSLATION_KEYS = Map.of(TooltipComponents.ALL, "componentviewer.tooltip.purpose.components.selection.all.with_amount", TooltipComponents.DEFAULT, "componentviewer.tooltip.purpose.components.selection.default.with_amount", TooltipComponents.CHANGES, "componentviewer.tooltip.purpose.components.selection.changes.with_amount");
    private final List<Component> lines;

    public Tooltip(List<Component> lines) {
        this.lines = lines;
    }

    public int size() {
        return this.lines.size();
    }

    public boolean isEmpty() {
        return this.lines.isEmpty();
    }

    public Tooltip clear() {
        this.lines.clear();
        return this;
    }

    public Tooltip addSpacer() {
        this.lines.add((Component)Component.empty());
        return this;
    }

    public Tooltip addHeader(String translationKey, Object ... args) {
        this.lines.add((Component)Component.translatable((String)translationKey, (Object[])args).withStyle(HEADER_STYLE));
        return this;
    }

    public Tooltip addComponentSelection(HoveredItemStack hoveredItemStack, boolean hideSelectedComponent, boolean showAmount) {
        ItemStackComponents components = hoveredItemStack.getComponents();
        TooltipComponents componentContext = components.getComponentContext();
        if (components.isEmpty()) {
            this.addHeader(EMPTY_COMPONENT_SELECTION_TRANSLATION_KEYS.get((Object)componentContext), new Object[0]);
            return this;
        }
        if (showAmount) {
            this.addHeader(COMPONENT_SELECTION_WITH_AMOUNT_TRANSLATION_KEYS.get((Object)componentContext), components.size());
        } else {
            this.addHeader(COMPONENT_SELECTION_TRANSLATION_KEYS.get((Object)componentContext), new Object[0]);
        }
        String indentationOfSelected = CONTENT_INDENTATION.repeat(Math.min(components.size(), 2));
        List<DataComponentType<?>> dataComponentTypes = components.getComponentTypes();
        @NullPermitted DataComponentType<?> selectedDataComponentType = hideSelectedComponent ? null : dataComponentTypes.get(hoveredItemStack.getComponentSelection().orElseThrow().getSelectedIndex());
        for (DataComponentType<?> dataComponentType : dataComponentTypes) {
            MutableComponent componentTypeText;
            ResourceLocation resourceLocation = BuiltInRegistries.DATA_COMPONENT_TYPE.getKey(dataComponentType);
            MutableComponent mutableComponent = componentTypeText = resourceLocation == null ? Component.translatable((String)NOT_REGISTERED_TRANSLATION_KEY).withStyle(COMPONENT_STYLE).withStyle(NOT_REGISTERED_COMPONENT_STYLE) : Component.literal((String)resourceLocation.toString()).withStyle(COMPONENT_STYLE);
            if (dataComponentType == selectedDataComponentType) {
                componentTypeText.withStyle(SELECTED_COMPONENT_STYLE);
            }
            if (components.wasRemoved(dataComponentType)) {
                componentTypeText.withStyle(REMOVED_COMPONENT_STYLE);
            }
            this.lines.add((Component)Component.literal((String)(dataComponentType == selectedDataComponentType ? indentationOfSelected : CONTENT_INDENTATION)).append((Component)componentTypeText));
        }
        return this;
    }

    public <T> Tooltip addComponentValue(TypedDataComponent<T> component, Formatter formatter, int formattingIndentation, boolean coloredFormatting) {
        this.addHeader("componentviewer.tooltip.purpose.components.value", new Object[0]);
        try {
            this.lines.addAll(formatter.componentToText(component, formattingIndentation, coloredFormatting, CONTENT_INDENTATION));
        }
        catch (FormattingException e) {
            this.addFormattingException();
        }
        return this;
    }

    public Tooltip addItemStack(ItemStack itemStack, Formatter formatter, int formattingIndentation, boolean coloredFormatting) {
        this.addHeader("componentviewer.tooltip.purpose.item_stack", new Object[0]);
        try {
            this.lines.addAll(formatter.itemStackToText(itemStack, formattingIndentation, coloredFormatting, CONTENT_INDENTATION));
        }
        catch (FormattingException e) {
            this.addFormattingException();
        }
        return this;
    }

    private void addFormattingException() {
        this.lines.add((Component)Component.literal((String)CONTENT_INDENTATION).append((Component)Component.translatable((String)"componentviewer.tooltip.formatting_exception").withStyle(ERROR_STYLE)));
    }
}

